/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.pointables.nonvisitor.ARecordPointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class RecordLengthDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new RecordLengthDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.RecordAccessorTypeInferer.INSTANCE_LAX;
        }
    };
    private static final long serialVersionUID = 1L;
    private ARecordType recType;

    public void setImmutableStates(Object ... states) {
        this.recType = (ARecordType)states[0];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private IScalarEvaluator eval0;
                    private final IPointable argPtr;
                    private final ARecordPointable recordPointable;
                    private final AMutableInt64 aInt64;
                    private final ISerializerDeserializer<AInt64> int64Serde;
                    private final ArrayBackedValueStorage resultStorage;
                    private final DataOutput out;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.argPtr = new VoidPointable();
                        this.recordPointable = ARecordPointable.FACTORY.createPointable();
                        this.aInt64 = new AMutableInt64(0L);
                        this.int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.out = this.resultStorage.getDataOutput();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
                        int offset;
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.argPtr);
                        if (PointableHelper.checkAndSetMissingOrNull(resultPointable, this.argPtr)) {
                            return;
                        }
                        byte[] data = this.argPtr.getByteArray();
                        if (data[offset = this.argPtr.getStartOffset()] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                            PointableHelper.setNull(resultPointable);
                            return;
                        }
                        this.recordPointable.set(data, offset, this.argPtr.getLength());
                        int n = this.recordPointable.getSchemeFieldCount(RecordLengthDescriptor.this.recType) + this.recordPointable.getOpenFieldCount(RecordLengthDescriptor.this.recType);
                        this.aInt64.setValue((long)n);
                        this.int64Serde.serialize((Object)this.aInt64, this.out);
                        resultPointable.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.RECORD_LENGTH;
    }
}

