/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.ProgressSplitsBlock;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.AvroArrayUtils;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletion;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptUnsuccessfulCompletionEvent
implements HistoryEvent {
    private TaskAttemptUnsuccessfulCompletion datum = null;
    private TaskAttemptID attemptId;
    private TaskType taskType;
    private String status;
    private long finishTime;
    private String hostname;
    private int port;
    private String rackName;
    private String error;
    private Counters counters;
    int[][] allSplits;
    int[] clockSplits;
    int[] cpuUsages;
    int[] vMemKbytes;
    int[] physMemKbytes;
    private static final Counters EMPTY_COUNTERS = new Counters();

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, int port, String rackName, String error, Counters counters, int[][] allSplits) {
        this.attemptId = id;
        this.taskType = taskType;
        this.status = status;
        this.finishTime = finishTime;
        this.hostname = hostname;
        this.port = port;
        this.rackName = rackName;
        this.error = error;
        this.counters = counters;
        this.allSplits = allSplits;
        this.clockSplits = ProgressSplitsBlock.arrayGetWallclockTime(allSplits);
        this.cpuUsages = ProgressSplitsBlock.arrayGetCPUTime(allSplits);
        this.vMemKbytes = ProgressSplitsBlock.arrayGetVMemKbytes(allSplits);
        this.physMemKbytes = ProgressSplitsBlock.arrayGetPhysMemKbytes(allSplits);
    }

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, String error) {
        this(id, taskType, status, finishTime, hostname, -1, "", error, EMPTY_COUNTERS, null);
    }

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, int port, String rackName, String error, int[][] allSplits) {
        this(id, taskType, status, finishTime, hostname, port, rackName, error, EMPTY_COUNTERS, null);
    }

    TaskAttemptUnsuccessfulCompletionEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new TaskAttemptUnsuccessfulCompletion();
            this.datum.setTaskid((CharSequence)new Utf8(this.attemptId.getTaskID().toString()));
            this.datum.setTaskType((CharSequence)new Utf8(this.taskType.name()));
            this.datum.setAttemptId((CharSequence)new Utf8(this.attemptId.toString()));
            this.datum.setFinishTime(this.finishTime);
            this.datum.setHostname((CharSequence)new Utf8(this.hostname));
            if (this.rackName != null) {
                this.datum.setRackname((CharSequence)new Utf8(this.rackName));
            }
            this.datum.setPort(this.port);
            this.datum.setError((CharSequence)new Utf8(this.error));
            this.datum.setStatus((CharSequence)new Utf8(this.status));
            this.datum.setCounters(EventWriter.toAvro(this.counters));
            this.datum.setClockSplits(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetWallclockTime(this.allSplits)));
            this.datum.setCpuUsages(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetCPUTime(this.allSplits)));
            this.datum.setVMemKbytes(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetVMemKbytes(this.allSplits)));
            this.datum.setPhysMemKbytes(AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetPhysMemKbytes(this.allSplits)));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object odatum) {
        this.datum = (TaskAttemptUnsuccessfulCompletion)((Object)odatum);
        this.attemptId = TaskAttemptID.forName(this.datum.getAttemptId().toString());
        this.taskType = TaskType.valueOf(this.datum.getTaskType().toString());
        this.finishTime = this.datum.getFinishTime();
        this.hostname = this.datum.getHostname().toString();
        this.rackName = this.datum.getRackname().toString();
        this.port = this.datum.getPort();
        this.status = this.datum.getStatus().toString();
        this.error = this.datum.getError().toString();
        this.counters = EventReader.fromAvro(this.datum.getCounters());
        this.clockSplits = AvroArrayUtils.fromAvro(this.datum.getClockSplits());
        this.cpuUsages = AvroArrayUtils.fromAvro(this.datum.getCpuUsages());
        this.vMemKbytes = AvroArrayUtils.fromAvro(this.datum.getVMemKbytes());
        this.physMemKbytes = AvroArrayUtils.fromAvro(this.datum.getPhysMemKbytes());
    }

    public TaskID getTaskId() {
        return this.attemptId.getTaskID();
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(this.taskType.toString());
    }

    public TaskAttemptID getTaskAttemptId() {
        return this.attemptId;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getRackName() {
        return this.rackName == null ? null : this.rackName.toString();
    }

    public String getError() {
        return this.error.toString();
    }

    public String getTaskStatus() {
        return this.status.toString();
    }

    Counters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        boolean failed = TaskStatus.State.FAILED.toString().equals(this.getTaskStatus());
        return this.getTaskId().getTaskType() == TaskType.MAP ? (failed ? EventType.MAP_ATTEMPT_FAILED : EventType.MAP_ATTEMPT_KILLED) : (failed ? EventType.REDUCE_ATTEMPT_FAILED : EventType.REDUCE_ATTEMPT_KILLED);
    }

    public int[] getClockSplits() {
        return this.clockSplits;
    }

    public int[] getCpuUsages() {
        return this.cpuUsages;
    }

    public int[] getVMemKbytes() {
        return this.vMemKbytes;
    }

    public int[] getPhysMemKbytes() {
        return this.physMemKbytes;
    }
}

