/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.config.TransactionProperties;
import org.apache.asterix.common.transactions.Checkpoint;
import org.apache.asterix.common.transactions.CheckpointProperties;
import org.apache.asterix.common.transactions.ICheckpointManager;
import org.apache.asterix.common.transactions.ILockManager;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.transactions.IRecoveryManagerFactory;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.service.locking.ConcurrentLockManager;
import org.apache.asterix.transaction.management.service.logging.LogManagerWithReplication;
import org.apache.asterix.transaction.management.service.recovery.CheckpointManagerFactory;
import org.apache.asterix.transaction.management.service.transaction.TransactionManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransactionSubsystem
implements ITransactionSubsystem {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String id;
    private final ILogManager logManager;
    private final ILockManager lockManager;
    private final ITransactionManager transactionManager;
    private final IRecoveryManager recoveryManager;
    private final TransactionProperties txnProperties;
    private final ICheckpointManager checkpointManager;
    private final INcApplicationContext appCtx;
    private long profilerEntityCommitLogCount = 0L;
    private EntityCommitProfiler ecp;

    public TransactionSubsystem(INcApplicationContext appCtx, IRecoveryManagerFactory recoveryManagerFactory) {
        this.appCtx = appCtx;
        this.id = appCtx.getServiceContext().getNodeId();
        this.txnProperties = appCtx.getTransactionProperties();
        this.transactionManager = new TransactionManager((ITransactionSubsystem)this);
        this.lockManager = new ConcurrentLockManager(this.txnProperties.getLockManagerShrinkTimer(), this.txnProperties.getLockTableSize());
        ReplicationProperties repProperties = appCtx.getReplicationProperties();
        boolean replicationEnabled = repProperties.isReplicationEnabled();
        CheckpointProperties checkpointProperties = new CheckpointProperties(this.txnProperties, this.id);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.log(Level.INFO, "Checkpoint Properties: " + checkpointProperties);
        }
        this.checkpointManager = CheckpointManagerFactory.create((ITransactionSubsystem)this, (CheckpointProperties)checkpointProperties);
        Checkpoint latestCheckpoint = this.checkpointManager.getLatest();
        if (latestCheckpoint != null) {
            this.transactionManager.ensureMaxTxnId(latestCheckpoint.getMaxTxnId());
        }
        this.logManager = replicationEnabled ? new LogManagerWithReplication((ITransactionSubsystem)this) : new org.apache.asterix.transaction.management.service.logging.LogManager((ITransactionSubsystem)this);
        this.recoveryManager = recoveryManagerFactory.createRecoveryManager(appCtx.getServiceContext(), (ITransactionSubsystem)this);
        if (this.txnProperties.isCommitProfilerEnabled()) {
            this.ecp = new EntityCommitProfiler(this, this.txnProperties.getCommitProfilerReportInterval());
            ((ExecutorService)appCtx.getThreadExecutor()).submit(this.ecp);
        }
    }

    public ILogManager getLogManager() {
        return this.logManager;
    }

    public ILockManager getLockManager() {
        return this.lockManager;
    }

    public ITransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public IRecoveryManager getRecoveryManager() {
        return this.recoveryManager;
    }

    public INcApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    public TransactionProperties getTransactionProperties() {
        return this.txnProperties;
    }

    public String getId() {
        return this.id;
    }

    public void incrementEntityCommitCount() {
        ++this.profilerEntityCommitLogCount;
    }

    public ICheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    static class EntityCommitProfiler
    implements Callable<Boolean> {
        private static final Logger LOGGER = LogManager.getLogger();
        private final long reportIntervalInMillisec;
        private long lastEntityCommitCount;
        private int reportIntervalInSeconds;
        private TransactionSubsystem txnSubsystem;
        private boolean firstReport = true;
        private long startTimeStamp = 0L;
        private long reportRound = 1L;

        public EntityCommitProfiler(TransactionSubsystem txnSubsystem, int reportIntervalInSeconds) {
            Thread.currentThread().setName("EntityCommitProfiler-Thread");
            this.txnSubsystem = txnSubsystem;
            this.reportIntervalInSeconds = reportIntervalInSeconds;
            this.reportIntervalInMillisec = (long)reportIntervalInSeconds * 1000L;
            this.lastEntityCommitCount = txnSubsystem.profilerEntityCommitLogCount;
        }

        @Override
        public Boolean call() throws Exception {
            while (true) {
                Thread.sleep(this.reportIntervalInMillisec);
                if (this.txnSubsystem.profilerEntityCommitLogCount <= 0L) continue;
                if (this.firstReport) {
                    this.startTimeStamp = System.currentTimeMillis();
                    this.firstReport = false;
                }
                this.outputCount();
            }
        }

        private void outputCount() {
            long currentTimeStamp = System.currentTimeMillis();
            long currentEntityCommitCount = this.txnSubsystem.profilerEntityCommitLogCount;
            LOGGER.error("EntityCommitProfiler ReportRound[" + this.reportRound + "], AbsoluteTimeStamp[" + currentTimeStamp + "], ActualRelativeTimeStamp[" + (currentTimeStamp - this.startTimeStamp) + "], ExpectedRelativeTimeStamp[" + (long)this.reportIntervalInSeconds * this.reportRound + "], IIPS[" + (currentEntityCommitCount - this.lastEntityCommitCount) / (long)this.reportIntervalInSeconds + "], IPS[" + currentEntityCommitCount / (this.reportRound * (long)this.reportIntervalInSeconds) + "]");
            this.lastEntityCommitCount = currentEntityCommitCount;
            ++this.reportRound;
        }
    }
}

