/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class JobParameterByteStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<byte[], byte[]> runtimeValues;
    private final byte[] empty = new byte[0];

    public JobParameterByteStore() {
        this.runtimeValues = new HashMap<byte[], byte[]>();
    }

    public Map<byte[], byte[]> getParameterMap() {
        return this.runtimeValues;
    }

    public void setParameters(Map<byte[], byte[]> map) {
        this.runtimeValues = map;
    }

    public byte[] getParameterValue(byte[] name, int start, int length) {
        for (Map.Entry<byte[], byte[]> entry : this.runtimeValues.entrySet()) {
            byte[] key = entry.getKey();
            if (key.length != length) continue;
            boolean matched = true;
            for (int j = 0; j < length; ++j) {
                if (key[j] == name[j + start]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return entry.getValue();
        }
        return this.empty;
    }
}

