/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class DoubleToFloatTypeConvertComputer
implements ITypeConvertComputer {
    private static final DoubleToFloatTypeConvertComputer INSTANCE_STRICT = new DoubleToFloatTypeConvertComputer(true);
    private static final DoubleToFloatTypeConvertComputer INSTANCE_LAX = new DoubleToFloatTypeConvertComputer(false);
    private final boolean strict;

    private DoubleToFloatTypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    public static DoubleToFloatTypeConvertComputer getInstance(boolean strict) {
        return strict ? INSTANCE_STRICT : INSTANCE_LAX;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        double sourceValue = DoublePointable.getDouble((byte[])data, (int)start);
        float targetValue = this.convert(sourceValue);
        out.writeByte(ATypeTag.FLOAT.serialize());
        out.writeFloat(targetValue);
    }

    @Override
    public IAObject convertType(IAObject sourceObject, ATypeHierarchy.TypeCastingMathFunctionType mathFunction) throws HyracksDataException {
        if (mathFunction != ATypeHierarchy.TypeCastingMathFunctionType.NONE) {
            throw new RuntimeDataException(31, new Serializable[]{mathFunction, ATypeTag.DOUBLE, ATypeTag.FLOAT});
        }
        double sourceValue = ((ADouble)sourceObject).getDoubleValue();
        float targetValue = this.convert(sourceValue);
        return new AFloat(targetValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float convert(double sourceValue) throws HyracksDataException {
        if (sourceValue > 3.4028234663852886E38) {
            if (!this.strict) return Float.MAX_VALUE;
            this.raiseBoundaryCheckException(sourceValue);
            return (float)sourceValue;
        } else {
            if (!(sourceValue < -3.4028234663852886E38)) return (float)sourceValue;
            if (!this.strict) return -3.4028235E38f;
            this.raiseBoundaryCheckException(sourceValue);
        }
        return (float)sourceValue;
    }

    private void raiseBoundaryCheckException(double sourceValue) throws HyracksDataException {
        throw new RuntimeDataException(21, new Serializable[]{Double.valueOf(sourceValue), ATypeTag.FLOAT, Float.valueOf(Float.MAX_VALUE), Float.valueOf(-3.4028235E38f)});
    }
}

