/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import java.io.Serializable;
import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.om.types.BuiltinType;

public class TypeSignature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DataverseName dataverseName;
    private final String name;

    public TypeSignature(DataverseName dataverseName, String name) {
        this.dataverseName = dataverseName;
        this.name = name;
    }

    public TypeSignature(BuiltinType builtinType) {
        this(null, builtinType.getTypeName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeSignature)) {
            return false;
        }
        TypeSignature f = (TypeSignature)o;
        return Objects.equals(this.dataverseName, f.getDataverseName()) && this.name.equals(f.getName());
    }

    public String toString() {
        return (this.dataverseName != null ? this.dataverseName.getCanonicalForm() : null) + "@" + this.name;
    }

    public int hashCode() {
        return Objects.hash(this.dataverseName, this.name);
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getName() {
        return this.name;
    }
}

