/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import org.apache.asterix.builders.ArrayListFactory;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayProcessArraysEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.common.arraylist.IntArrayList;

public class ArraySymDiffEval
extends AbstractArrayProcessArraysEval {
    private final IBinaryHashFunction binaryHashFunction;
    private final Int2ObjectMap<List<ValueCounter>> hashes;
    private final IObjectPool<List<ValueCounter>, ATypeTag> arrayListAllocator = new ListObjectPool((IObjectFactory)new ArrayListFactory());
    private final IObjectPool<ValueCounter, ATypeTag> valueCounterAllocator = new ListObjectPool((IObjectFactory)new ValueCounterFactory());
    private final IBinaryComparator comp;
    private final IntArrayList intHashes;

    ArraySymDiffEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx, SourceLocation sourceLocation, IAType[] argTypes) throws HyracksDataException {
        super(args, ctx, sourceLocation, argTypes);
        this.hashes = new Int2ObjectOpenHashMap();
        this.comp = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)BuiltinType.ANY, (Object)BuiltinType.ANY, true).createBinaryComparator();
        this.intHashes = new IntArrayList(50, 10);
        this.binaryHashFunction = BinaryHashFunctionFactoryProvider.INSTANCE.getBinaryHashFunctionFactory((Object)BuiltinType.ANY).createBinaryHashFunction();
    }

    @Override
    protected void init() {
        this.hashes.clear();
        this.intHashes.clear();
    }

    @Override
    protected void finish(IAsterixListBuilder listBuilder) throws HyracksDataException {
        for (int i = 0; i < this.intHashes.size(); ++i) {
            List items = (List)this.hashes.get(this.intHashes.get(i));
            for (int k = 0; k < items.size(); ++k) {
                ValueCounter item = (ValueCounter)items.get(k);
                if (!this.checkCounter(item.counter)) continue;
                listBuilder.addItem((IValueReference)item.value);
            }
        }
    }

    @Override
    protected void release() {
        this.arrayListAllocator.reset();
        this.valueCounterAllocator.reset();
    }

    protected boolean checkCounter(int counter) {
        return counter == 1;
    }

    @Override
    protected boolean processItem(IPointable item, int listIndex, IAsterixListBuilder listBuilder) throws HyracksDataException {
        int hash = this.binaryHashFunction.hash(item.getByteArray(), item.getStartOffset(), item.getLength());
        List sameHashes = (List)this.hashes.get(hash);
        if (sameHashes == null) {
            sameHashes = (List)this.arrayListAllocator.allocate(null);
            sameHashes.clear();
            this.addItem(item, listIndex, sameHashes);
            this.hashes.put(hash, (Object)sameHashes);
            this.intHashes.add(hash);
            return true;
        }
        ValueCounter itemListIdxCounter = (ValueCounter)PointableHelper.findItem((IValueReference)item, sameHashes, this.comp);
        if (itemListIdxCounter == null) {
            this.addItem(item, listIndex, sameHashes);
            return true;
        }
        if (itemListIdxCounter.listIndex != listIndex) {
            itemListIdxCounter.listIndex = listIndex;
            itemListIdxCounter.counter++;
        }
        return false;
    }

    private void addItem(IPointable item, int listIndex, List<ValueCounter> sameHashes) {
        ValueCounter valueCounter = (ValueCounter)this.valueCounterAllocator.allocate(null);
        valueCounter.reset(item, listIndex, 1);
        sameHashes.add(valueCounter);
    }

    public class ValueCounterFactory
    implements IObjectFactory<ValueCounter, ATypeTag> {
        public ValueCounter create(ATypeTag arg) {
            return new ValueCounter();
        }
    }

    protected class ValueCounter
    implements IValueReference {
        private IPointable value;
        private int listIndex;
        private int counter;

        ValueCounter() {
        }

        protected void reset(IPointable value, int listIndex, int counter) {
            this.value = value;
            this.listIndex = listIndex;
            this.counter = counter;
        }

        public byte[] getByteArray() {
            return this.value.getByteArray();
        }

        public int getStartOffset() {
            return this.value.getStartOffset();
        }

        public int getLength() {
            return this.value.getLength();
        }
    }
}

