# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

import _cython_3_0_11
import enum
from _typeshed import Incomplete
from typing import Callable, ClassVar

DEVICE_CPU: Device
__reduce_cython__: _cython_3_0_11.cython_function_or_method
__setstate_cython__: _cython_3_0_11.cython_function_or_method
__test__: dict

class CSharedSyncEvent:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None:
        """Create and return a new object.  See help(type) for accurate signature."""
    def __reduce__(self): ...

class Device:
    device_id: Incomplete
    device_type: Incomplete
    device_type_id: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None:
        """Create and return a new object.  See help(type) for accurate signature."""
    @staticmethod
    def resolve(*args, **kwargs): ...
    def __eq__(self, other: object) -> bool:
        """Return self==value."""
    def __ge__(self, other: object) -> bool:
        """Return self>=value."""
    def __gt__(self, other: object) -> bool:
        """Return self>value."""
    def __le__(self, other: object) -> bool:
        """Return self<=value."""
    def __lt__(self, other: object) -> bool:
        """Return self<value."""
    def __ne__(self, other: object) -> bool:
        """Return self!=value."""
    def __reduce__(self): ...

class DeviceType(enum.Enum):
    __new__: ClassVar[Callable] = ...
    CPU: ClassVar[DeviceType] = ...
    CUDA: ClassVar[DeviceType] = ...
    CUDA_HOST: ClassVar[DeviceType] = ...
    CUDA_MANAGED: ClassVar[DeviceType] = ...
    EXT_DEV: ClassVar[DeviceType] = ...
    HEXAGON: ClassVar[DeviceType] = ...
    METAL: ClassVar[DeviceType] = ...
    ONEAPI: ClassVar[DeviceType] = ...
    OPENCL: ClassVar[DeviceType] = ...
    ROCM: ClassVar[DeviceType] = ...
    ROCM_HOST: ClassVar[DeviceType] = ...
    VPI: ClassVar[DeviceType] = ...
    VULKAN: ClassVar[DeviceType] = ...
    WEBGPU: ClassVar[DeviceType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[object]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    _value_repr_: ClassVar[None] = ...
