/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.security.PrivilegedAction;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.osgi.service.subsystem.SubsystemException;

public abstract class AbstractAction
implements PrivilegedAction<Object> {
    protected final boolean disableRootCheck;
    protected final BasicSubsystem requestor;
    protected final BasicSubsystem target;

    public AbstractAction(BasicSubsystem requestor, BasicSubsystem target, boolean disableRootCheck) {
        this.requestor = requestor;
        this.target = target;
        this.disableRootCheck = disableRootCheck;
    }

    protected void checkRoot() {
        if (!this.disableRootCheck && this.target.isRoot()) {
            throw new SubsystemException("This operation may not be performed on the root subsystem");
        }
    }

    protected void checkValid() {
        BasicSubsystem s = (BasicSubsystem)Activator.getInstance().getSubsystemServiceRegistrar().getSubsystemService(this.target);
        if (s != this.target) {
            throw new IllegalStateException("Detected stale subsystem instance: " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForStateChange() {
        BasicSubsystem basicSubsystem = this.target;
        synchronized (basicSubsystem) {
            try {
                this.target.wait();
            }
            catch (InterruptedException e) {
                throw new SubsystemException(e);
            }
        }
    }
}

