/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIESOR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.blueprint.utils.threading.impl;

import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public class DiscardableCallable<V> implements Callable<V>, Runnable, Discardable<Runnable> {
    private AtomicReference<Callable<V>> c = new AtomicReference<Callable<V>>();
    private Queue<Discardable<Runnable>> _removeFromListOnCall;

    public DiscardableCallable(Callable<V> call, Queue<Discardable<Runnable>> _unprocessedWork) {
        c.set(call);
        _removeFromListOnCall = _unprocessedWork;
        _removeFromListOnCall.add(this);
    }

    private DiscardableCallable(Callable<V> call) {
        c.set(call);
        _removeFromListOnCall = new LinkedBlockingQueue<Discardable<Runnable>>();
    }

    public Runnable discard() {
        _removeFromListOnCall.remove(this);
        return new DiscardableCallable<V>(c.getAndSet(null));
    }

    public V call() throws Exception {
        _removeFromListOnCall.remove(this);
        Callable<V> call = c.get();
        if (call != null) {
            return call.call();
        }
        throw new CancellationException();
    }

    public void run() {
        try {
            call();
        } catch (Exception e) {
        }
    }
}