/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.zlib.BuiltInGzipDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;

public class GzipCodec
extends DefaultCodec {
    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new CompressorStream(out, this.createCompressor(), this.conf.getInt("io.file.buffer.size", 4096)) : new GzipOutputStream(out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return compressor != null ? new CompressorStream(out, compressor, this.conf.getInt("io.file.buffer.size", 4096)) : this.createOutputStream(out);
    }

    @Override
    public Compressor createCompressor() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new GzipZlibCompressor(this.conf) : null;
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? GzipZlibCompressor.class : null;
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, null);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (decompressor == null) {
            decompressor = this.createDecompressor();
        }
        return new DecompressorStream(in, decompressor, this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public Decompressor createDecompressor() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new GzipZlibDecompressor() : new BuiltInGzipDecompressor();
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? GzipZlibDecompressor.class : BuiltInGzipDecompressor.class;
    }

    @Override
    public String getDefaultExtension() {
        return ".gz";
    }

    static final class GzipZlibDecompressor
    extends ZlibDecompressor {
        public GzipZlibDecompressor() {
            super(ZlibDecompressor.CompressionHeader.AUTODETECT_GZIP_ZLIB, 65536);
        }
    }

    static final class GzipZlibCompressor
    extends ZlibCompressor {
        public GzipZlibCompressor() {
            super(ZlibCompressor.CompressionLevel.DEFAULT_COMPRESSION, ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY, ZlibCompressor.CompressionHeader.GZIP_FORMAT, 65536);
        }

        public GzipZlibCompressor(Configuration conf) {
            super(ZlibFactory.getCompressionLevel(conf), ZlibFactory.getCompressionStrategy(conf), ZlibCompressor.CompressionHeader.GZIP_FORMAT, 65536);
        }
    }

    protected static class GzipOutputStream
    extends CompressorStream {
        public GzipOutputStream(OutputStream out) throws IOException {
            super(new ResetableGZIPOutputStream(out));
        }

        protected GzipOutputStream(CompressorStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.out.write(data, offset, length);
        }

        @Override
        public void finish() throws IOException {
            ((ResetableGZIPOutputStream)this.out).finish();
        }

        @Override
        public void resetState() throws IOException {
            ((ResetableGZIPOutputStream)this.out).resetState();
        }

        private static class ResetableGZIPOutputStream
        extends GZIPOutputStream {
            private static final int TRAILER_SIZE = 8;
            public static final String JVMVendor = System.getProperty("java.vendor");
            public static final String JVMVersion = System.getProperty("java.version");
            private static final boolean HAS_BROKEN_FINISH = JVMVendor.contains("IBM") && JVMVersion.contains("1.6.0");

            public ResetableGZIPOutputStream(OutputStream out) throws IOException {
                super(out);
            }

            public void resetState() throws IOException {
                this.def.reset();
            }

            @Override
            public void finish() throws IOException {
                if (HAS_BROKEN_FINISH) {
                    if (!this.def.finished()) {
                        this.def.finish();
                        while (!this.def.finished()) {
                            int i = this.def.deflate(this.buf, 0, this.buf.length);
                            if (this.def.finished() && i <= this.buf.length - 8) {
                                this.writeTrailer(this.buf, i);
                                this.out.write(this.buf, 0, i += 8);
                                return;
                            }
                            if (i <= 0) continue;
                            this.out.write(this.buf, 0, i);
                        }
                        byte[] arrayOfByte = new byte[8];
                        this.writeTrailer(arrayOfByte, 0);
                        this.out.write(arrayOfByte);
                    }
                } else {
                    super.finish();
                }
            }

            private void writeTrailer(byte[] paramArrayOfByte, int paramInt) throws IOException {
                this.writeInt((int)this.crc.getValue(), paramArrayOfByte, paramInt);
                this.writeInt(this.def.getTotalIn(), paramArrayOfByte, paramInt + 4);
            }

            private void writeInt(int paramInt1, byte[] paramArrayOfByte, int paramInt2) throws IOException {
                this.writeShort(paramInt1 & 0xFFFF, paramArrayOfByte, paramInt2);
                this.writeShort(paramInt1 >> 16 & 0xFFFF, paramArrayOfByte, paramInt2 + 2);
            }

            private void writeShort(int paramInt1, byte[] paramArrayOfByte, int paramInt2) throws IOException {
                paramArrayOfByte[paramInt2] = (byte)(paramInt1 & 0xFF);
                paramArrayOfByte[paramInt2 + 1] = (byte)(paramInt1 >> 8 & 0xFF);
            }
        }
    }
}

