/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.zlib;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.util.NativeCodeLoader;
import org.mortbay.log.Log;

public class ZlibCompressor
implements Compressor {
    private static final int DEFAULT_DIRECT_BUFFER_SIZE = 65536;
    private static Class clazz = ZlibCompressor.class;
    private long stream;
    private CompressionLevel level;
    private CompressionStrategy strategy;
    private final CompressionHeader windowBits;
    private int directBufferSize;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private Buffer uncompressedDirectBuf = null;
    private int uncompressedDirectBufOff = 0;
    private int uncompressedDirectBufLen = 0;
    private Buffer compressedDirectBuf = null;
    private boolean finish;
    private boolean finished;
    private static boolean nativeZlibLoaded = false;

    static boolean isNativeZlibLoaded() {
        return nativeZlibLoaded;
    }

    protected final void construct(CompressionLevel level, CompressionStrategy strategy, CompressionHeader header, int directBufferSize) {
    }

    public ZlibCompressor() {
        this(CompressionLevel.DEFAULT_COMPRESSION, CompressionStrategy.DEFAULT_STRATEGY, CompressionHeader.DEFAULT_HEADER, 65536);
    }

    public ZlibCompressor(Configuration conf) {
        this(ZlibFactory.getCompressionLevel(conf), ZlibFactory.getCompressionStrategy(conf), CompressionHeader.DEFAULT_HEADER, 65536);
    }

    public ZlibCompressor(CompressionLevel level, CompressionStrategy strategy, CompressionHeader header, int directBufferSize) {
        this.level = level;
        this.strategy = strategy;
        this.windowBits = header;
        this.stream = ZlibCompressor.init(this.level.compressionLevel(), this.strategy.compressionStrategy(), this.windowBits.windowBits());
        this.directBufferSize = directBufferSize;
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf.position(directBufferSize);
    }

    @Override
    public synchronized void reinit(Configuration conf) {
        this.reset();
        if (conf == null) {
            return;
        }
        ZlibCompressor.end(this.stream);
        this.level = ZlibFactory.getCompressionLevel(conf);
        this.strategy = ZlibFactory.getCompressionStrategy(conf);
        this.stream = ZlibCompressor.init(this.level.compressionLevel(), this.strategy.compressionStrategy(), this.windowBits.windowBits());
        Log.debug("Reinit compressor with new compression configuration");
    }

    @Override
    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.setInputFromSavedData();
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
    }

    synchronized void setInputFromSavedData() {
        this.uncompressedDirectBufOff = 0;
        this.uncompressedDirectBufLen = this.userBufLen;
        if (this.uncompressedDirectBufLen > this.directBufferSize) {
            this.uncompressedDirectBufLen = this.directBufferSize;
        }
        this.uncompressedDirectBuf.rewind();
        ((ByteBuffer)this.uncompressedDirectBuf).put(this.userBuf, this.userBufOff, this.uncompressedDirectBufLen);
        this.userBufOff += this.uncompressedDirectBufLen;
        this.userBufLen -= this.uncompressedDirectBufLen;
    }

    @Override
    public synchronized void setDictionary(byte[] b, int off, int len) {
        if (this.stream == 0L || b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZlibCompressor.setDictionary(this.stream, b, off, len);
    }

    @Override
    public boolean needsInput() {
        if (this.compressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.uncompressedDirectBufLen <= 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
        }
        return false;
    }

    @Override
    public synchronized void finish() {
        this.finish = true;
    }

    @Override
    public synchronized boolean finished() {
        return this.finished && this.compressedDirectBuf.remaining() == 0;
    }

    @Override
    public synchronized int compress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = 0;
        n = this.compressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
            return n;
        }
        this.compressedDirectBuf.rewind();
        this.compressedDirectBuf.limit(this.directBufferSize);
        n = this.deflateBytesDirect();
        this.compressedDirectBuf.limit(n);
        n = Math.min(n, len);
        ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
        return n;
    }

    @Override
    public synchronized long getBytesWritten() {
        this.checkStream();
        return ZlibCompressor.getBytesWritten(this.stream);
    }

    @Override
    public synchronized long getBytesRead() {
        this.checkStream();
        return ZlibCompressor.getBytesRead(this.stream);
    }

    @Override
    public synchronized void reset() {
        this.checkStream();
        ZlibCompressor.reset(this.stream);
        this.finish = false;
        this.finished = false;
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBufLen = 0;
        this.uncompressedDirectBufOff = 0;
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
    }

    @Override
    public synchronized void end() {
        if (this.stream != 0L) {
            ZlibCompressor.end(this.stream);
            this.stream = 0L;
        }
    }

    private void checkStream() {
        if (this.stream == 0L) {
            throw new NullPointerException();
        }
    }

    private static native void initIDs();

    private static native long init(int var0, int var1, int var2);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int deflateBytesDirect();

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                ZlibCompressor.initIDs();
                nativeZlibLoaded = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static enum CompressionHeader {
        NO_HEADER(-15),
        DEFAULT_HEADER(15),
        GZIP_FORMAT(31);

        private final int windowBits;

        private CompressionHeader(int windowBits) {
            this.windowBits = windowBits;
        }

        public int windowBits() {
            return this.windowBits;
        }
    }

    public static enum CompressionStrategy {
        FILTERED(1),
        HUFFMAN_ONLY(2),
        RLE(3),
        FIXED(4),
        DEFAULT_STRATEGY(0);

        private final int compressionStrategy;

        private CompressionStrategy(int strategy) {
            this.compressionStrategy = strategy;
        }

        int compressionStrategy() {
            return this.compressionStrategy;
        }
    }

    public static enum CompressionLevel {
        NO_COMPRESSION(0),
        BEST_SPEED(1),
        BEST_COMPRESSION(9),
        DEFAULT_COMPRESSION(-1);

        private final int compressionLevel;

        private CompressionLevel(int level) {
            this.compressionLevel = level;
        }

        int compressionLevel() {
            return this.compressionLevel;
        }
    }
}

