/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.operations;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.PathComponent;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;

public class Variable
extends Expression
implements PathComponent {
    static final long serialVersionUID = -4334975375609297049L;
    private boolean m_fixUpWasCalled = false;
    protected QName m_qname;
    private boolean m_fromXPathAPI = false;
    protected int m_index;
    protected boolean m_isGlobal = false;
    private XPathVariableResolver m_variableResolver;
    static final String PSUEDOVARNAMESPACE = "http://xml.apache.org/xalan/psuedovar";

    public Variable(boolean bl) {
        this.m_fromXPathAPI = bl;
    }

    public Variable() {
        this(false);
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIsGlobal(boolean bl) {
        this.m_isGlobal = bl;
    }

    public boolean getGlobal() {
        return this.m_isGlobal;
    }

    public void setVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.m_variableResolver = xPathVariableResolver;
    }

    public XPathVariableResolver getVariableResolver() {
        return this.m_variableResolver;
    }

    @Override
    public void fixupVariables(Vector vector, int n) {
        Serializable serializable;
        this.m_fixUpWasCalled = true;
        int n2 = vector.size();
        for (int i = vector.size() - 1; i >= 0; --i) {
            serializable = (QName)vector.elementAt(i);
            if (!serializable.equals(this.m_qname)) continue;
            if (i < n) {
                this.m_isGlobal = true;
                this.m_index = i;
            } else {
                this.m_index = i - n;
            }
            return;
        }
        String string = XSLMessages.createXPATHMessage("ER_COULD_NOT_FIND_VAR", new Object[]{this.m_qname.toString()});
        serializable = new TransformerException(string, this);
        throw new WrappedRuntimeException((Exception)serializable);
    }

    public void setQName(QName qName) {
        this.m_qname = qName;
    }

    public QName getQName() {
        return this.m_qname;
    }

    @Override
    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XObject execute(XPathContext xPathContext, boolean bl) throws TransformerException {
        PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
        if (this.m_fromXPathAPI) {
            if (this.m_variableResolver != null) {
                javax.xml.namespace.QName qName;
                Object object;
                String string;
                String string2 = this.m_qname.getLocalName();
                String string3 = this.m_qname.getNamespaceURI();
                if (string3 == null) {
                    string3 = "";
                }
                if ((string = this.m_qname.getPrefix()) == null) {
                    string = "";
                }
                if ((object = this.m_variableResolver.resolveVariable(qName = new javax.xml.namespace.QName(string3, string2, string))) != null) {
                    return XObject.create(object, xPathContext);
                }
                XPathExpressionException xPathExpressionException = new XPathExpressionException(XPATHMessages.createXPATHMessage("ER_UNRESOLVED_VARIABLE", new Object[]{this.toString()}));
                throw new TransformerException(xPathExpressionException);
            }
            XPathExpressionException xPathExpressionException = new XPathExpressionException(XPATHMessages.createXPATHMessage("ER_UNDEFINED_VARIABLE_RESOLVER", new Object[]{this.toString()}));
            throw new TransformerException(xPathExpressionException);
        }
        if (this.m_fixUpWasCalled) {
            XObject xObject = this.m_isGlobal ? xPathContext.getVarStack().getGlobalVariable(xPathContext, this.m_index, bl) : xPathContext.getVarStack().getLocalVariable(xPathContext, this.m_index, bl);
            if (null == xObject) {
                this.warn(xPathContext, "WG_ILLEGAL_VARIABLE_REFERENCE", new Object[]{this.m_qname.getLocalPart()});
                xObject = new XNodeSet(xPathContext.getDTMManager());
            }
            return xObject;
        }
        Variable variable = this;
        synchronized (variable) {
            ElemVariable elemVariable = this.getElemVariable();
            if (null != elemVariable) {
                this.m_index = elemVariable.getIndex();
                this.m_isGlobal = elemVariable.getIsTopLevel();
                this.m_fixUpWasCalled = true;
                return this.execute(xPathContext);
            }
        }
        throw new TransformerException(XSLMessages.createXPATHMessage("ER_VAR_NOT_RESOLVABLE", new Object[]{this.m_qname.toString()}));
    }

    public ElemVariable getElemVariable() {
        ElemVariable elemVariable = null;
        ExpressionNode expressionNode = this.getExpressionOwner();
        if (null != expressionNode && expressionNode instanceof ElemTemplateElement) {
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)expressionNode;
            if (!(elemTemplateElement instanceof Stylesheet)) {
                while (elemTemplateElement != null && !(elemTemplateElement.getParentNode() instanceof Stylesheet)) {
                    ElemTemplateElement elemTemplateElement2 = elemTemplateElement;
                    while (null != (elemTemplateElement = elemTemplateElement.getPreviousSiblingElem())) {
                        if (!(elemTemplateElement instanceof ElemVariable)) continue;
                        elemVariable = (ElemVariable)elemTemplateElement;
                        if (elemVariable.getName().equals(this.m_qname)) {
                            return elemVariable;
                        }
                        elemVariable = null;
                    }
                    elemTemplateElement = elemTemplateElement2.getParentElem();
                }
            }
            if (elemTemplateElement != null) {
                elemVariable = elemTemplateElement.getStylesheetRoot().getVariableOrParamComposed(this.m_qname);
            }
        }
        return elemVariable;
    }

    @Override
    public boolean isStableNumber() {
        return true;
    }

    @Override
    public int getAnalysisBits() {
        Expression expression;
        XPath xPath;
        ElemVariable elemVariable = this.getElemVariable();
        if (null != elemVariable && null != (xPath = elemVariable.getSelect()) && null != (expression = xPath.getExpression()) && expression instanceof PathComponent) {
            return ((PathComponent)((Object)expression)).getAnalysisBits();
        }
        return 0x4000000;
    }

    @Override
    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitVariableRef(expressionOwner, this);
    }

    @Override
    public boolean deepEquals(Expression expression) {
        if (!this.isSameClass(expression)) {
            return false;
        }
        if (!this.m_qname.equals(((Variable)expression).m_qname)) {
            return false;
        }
        return this.getElemVariable() == ((Variable)expression).getElemVariable();
    }

    public boolean isPsuedoVarRef() {
        String string = this.m_qname.getNamespaceURI();
        return null != string && string.equals(PSUEDOVARNAMESPACE) && this.m_qname.getLocalName().startsWith("#");
    }

    public String toString() {
        String string = this.m_qname.getNamespaceURI();
        if (string != null) {
            return "{" + string + "}" + this.m_qname.getLocalName();
        }
        return this.m_qname.getLocalName();
    }
}

