/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.typechecker.v2;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.FunctionDecl;
import com.ibm.xtq.ast.nodes.FunctionDeclErrorStub;
import com.ibm.xtq.ast.nodes.Literal;
import com.ibm.xtq.ast.nodes.Message;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.Param;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.xml.types.AnyAtomicType;
import com.ibm.xtq.xml.types.BaseConstants;
import com.ibm.xtq.xml.types.ChoiceType;
import com.ibm.xtq.xml.types.ExtendedTypes;
import com.ibm.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeFactory;
import com.ibm.xtq.xml.types.XSequenceType;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xtq.xslt.translator.FunctionDeclaration;
import com.ibm.xtq.xslt.translator.PolymorphicFunctionDeclaration;
import com.ibm.xtq.xslt.translator.SimpleFunctionDeclaration;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xtq.xslt.typechecker.v2.TypeChecker2Base;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;

public abstract class Function2TypeChecker
extends TypeChecker2Base {
    protected static final String EXSLT_MATH = "http://exslt.org/math";
    protected static final String EXSLT_SETS = "http://exslt.org/sets";
    protected static final String EXSLT_DATETIME = "http://exslt.org/dates-and-times";
    protected static final String EXSLT_STRINGS = "http://exslt.org/strings";
    private static final Hashtable _extensionFunctionTable = new Hashtable();
    private static final Vector special_funcs = new Vector();

    public Function2TypeChecker(XPathCompiler xPathCompiler) {
        super(xPathCompiler);
    }

    @Override
    public Type visitFunction(FunctionCall functionCall) throws TypeCheckError {
        QName qName = functionCall.getFunctionQName();
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        if (this.isJAXPFunctionCall(functionCall)) {
            return this.jaxpFunctionCall(functionCall);
        }
        if (string2.equals(this._staticContext.getBuiltInNamespaceForFunction())) {
            if (!string.equals("collection")) {
                if (string.equals("concat")) {
                    return this.concatCall(functionCall);
                }
                if (string.equals("data")) {
                    return this.dataCall(functionCall);
                }
                if (string.equals("document")) {
                    return this.documentCall(functionCall);
                }
                if (string.equals("distinct-values")) {
                    return this.distinctValuesCall(functionCall);
                }
                if (string.equals("exactly-one")) {
                    return this.exactlyOneCall(functionCall);
                }
                if (string.equals("one-or-more")) {
                    return this.oneOrMoreCall(functionCall);
                }
                if (string.equals("sum")) {
                    return this.sumCall(functionCall);
                }
                if (string.equals("unordered")) {
                    return this.unorderedCall(functionCall);
                }
                if (string.equals("zero-or-one")) {
                    return this.zeroOrOneCall(functionCall);
                }
                if (string.equals("function-available")) {
                    return this.functionAvailable(functionCall);
                }
                return this.standardFunctionCall(functionCall);
            }
        } else {
            if (string2.equals("http://www.w3.org/2001/XMLSchema") || string2.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                return this.constructorCall(functionCall);
            }
            if (this.isStylesheetFunctionCall(functionCall)) {
                return this.stylesheetFunctionCall(functionCall);
            }
            if (string2.equals("http://xtqhp")) {
                if (string.equals("nodeIsInSequence")) {
                    return this.nodeIsInSequenceCall(functionCall);
                }
            } else if (this._staticContext.getInScopeTypeDefinition(qName) != null) {
                return this.constructorCall(functionCall);
            }
        }
        this._parser.reportError(4, new ASTMsg(new Throwable(this.funcNotFoundString(functionCall) + " May throw runtime error if executed!")));
        Type type = null;
        FunctionDeclErrorStub functionDeclErrorStub = new FunctionDeclErrorStub(32);
        functionDeclErrorStub.setQName(functionCall.getQName());
        functionDeclErrorStub.setTypeInference(type);
        for (int i = 0; i < functionCall.getOperandCount(); ++i) {
            Param param = new Param();
            param.setName("Constants.XTQHP_FUNCTIONS_URI", "dummy", "P" + i);
            param.setTypeInference(functionCall.getOperand(i).getTypeInference());
            functionDeclErrorStub.addParameter(param);
        }
        Message message = new Message(this.funcNotFoundString(functionCall), true);
        functionDeclErrorStub.jjtAddChild(null, message, 0);
        functionCall.getXTQProgram().jjtAppendChild(this._parser, functionDeclErrorStub);
        ASTDecorator2.setFunction(functionCall, functionDeclErrorStub);
        this._staticContext.addStylesheetFunction(functionDeclErrorStub);
        return type;
    }

    private String funcNotFoundString(FunctionCall functionCall) {
        QName qName = functionCall.getFunctionQName();
        return "Function " + qName.getPrefix() + ":" + qName.getLocalPart() + " with arity of " + functionCall.getOperandCount() + " not found!";
    }

    protected Type standardFunctionCall(FunctionCall functionCall) throws TypeCheckError {
        int n;
        QName qName = functionCall.getFunctionQName();
        String string = qName.getLocalPart();
        Object object = this._compiler.getFunctionDeclarationFromSignature(string, n = functionCall.getOperandCount());
        if (object == null) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_FUNCTION_NOT_DEFINED_ARITY", (Object)qName.toString(), (Object)new Integer(n));
            throw new StaticError(errorMsg);
        }
        if (object instanceof SimpleFunctionDeclaration) {
            return this.standardSimpleFunctionCall((SimpleFunctionDeclaration)object, functionCall);
        }
        return this.standardPolymorphicFunctionCall((PolymorphicFunctionDeclaration)object, functionCall, false);
    }

    protected Type standardSimpleFunctionCall(SimpleFunctionDeclaration simpleFunctionDeclaration, FunctionCall functionCall) throws TypeCheckError {
        boolean bl = simpleFunctionDeclaration.isEmptyReturnOnEmptyArgument();
        boolean bl2 = this.typeCheckArguments(simpleFunctionDeclaration, functionCall);
        XSequenceType xSequenceType = simpleFunctionDeclaration.getReturnType();
        String string = functionCall.getQName().getLocalPart();
        if (bl && !bl2 && !special_funcs.contains(string)) {
            xSequenceType = xSequenceType.getBaseType();
        }
        ASTDecorator2.setChosenFunctionDeclaration(functionCall, simpleFunctionDeclaration);
        ASTDecorator2.setType(functionCall, xSequenceType);
        return xSequenceType;
    }

    private boolean typeCheckArguments(FunctionCall functionCall) throws TypeCheckError {
        int n;
        QName qName = functionCall.getFunctionQName();
        String string = qName.getLocalPart();
        SimpleFunctionDeclaration simpleFunctionDeclaration = (SimpleFunctionDeclaration)this._compiler.getFunctionDeclarationFromSignature(string, n = functionCall.getOperandCount());
        if (simpleFunctionDeclaration == null) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_FUNCTION_NOT_DEFINED_ARITY", (Object)qName.toString(), (Object)new Integer(n));
            throw new StaticError(errorMsg);
        }
        ASTDecorator2.setChosenFunctionDeclaration(functionCall, simpleFunctionDeclaration);
        return this.typeCheckArguments(simpleFunctionDeclaration, functionCall);
    }

    private boolean typeCheckArguments(SimpleFunctionDeclaration simpleFunctionDeclaration, FunctionCall functionCall) throws TypeCheckError {
        int n = functionCall.getOperandCount();
        boolean bl = simpleFunctionDeclaration.isEmptyReturnOnEmptyArgument();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            int n2;
            Expr expr = functionCall.getOperand(i);
            Type type = this.visitExpression(expr);
            if (null == type) continue;
            XSequenceType xSequenceType = simpleFunctionDeclaration.getArgumentType(i);
            if (xSequenceType.getBaseType() instanceof AnyAtomicType) {
                type = type.getAtomizedType();
            }
            if ((n2 = type.typeMatchesWithPromotion(xSequenceType)) == 1 || n2 == 3 || !this._compiler.isStaticTyping() && n2 == 2) {
                if (!bl || bl2 || xSequenceType.getQuantifier() != OccurrenceIndicator.ZERO_OR_ONE || !type.getQuantifier().canBeEmpty()) continue;
                bl2 = true;
                continue;
            }
            QName qName = functionCall.getFunctionQName();
            ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_ARGUMENTS_UNMATCH_NAME", qName, expr.getXQueryString(true), String.valueOf(i + 1), xSequenceType);
            throw new StaticError(errorMsg);
        }
        return bl2;
    }

    protected Type standardPolymorphicFunctionCall(PolymorphicFunctionDeclaration polymorphicFunctionDeclaration, OperatorExpr operatorExpr, boolean bl) throws TypeCheckError {
        int n;
        BaseConstants baseConstants;
        int n2;
        Cloneable cloneable;
        int n3;
        int n4 = operatorExpr.getOperandCount();
        Type[] typeArray = null;
        if (n4 > 0) {
            typeArray = new Type[n4];
        }
        for (n3 = 0; n3 < n4; ++n3) {
            cloneable = operatorExpr.getOperand(n3);
            typeArray[n3] = !polymorphicFunctionDeclaration.hasNodeArguments() ? this.visitExpression((Expr)cloneable).getAtomizedType() : this.visitExpression((Expr)cloneable);
        }
        n3 = polymorphicFunctionDeclaration.getNumberOfDeclarations();
        cloneable = new ArrayList();
        for (n2 = 0; n2 < n3; ++n2) {
            baseConstants = polymorphicFunctionDeclaration.getDeclarationEntry(n2);
            int n5 = 1;
            n = 0;
            boolean bl2 = ((SimpleFunctionDeclaration)baseConstants).isEmptyReturnOnEmptyArgument();
            for (int i = 0; i < n4; ++i) {
                Type type = typeArray[i];
                if (null == type) continue;
                XSequenceType xSequenceType = ((SimpleFunctionDeclaration)baseConstants).getArgumentType(i);
                int n6 = type.typeMatchesWithPromotion(xSequenceType);
                if (bl2 && n == 0 && xSequenceType.getQuantifier() == OccurrenceIndicator.ZERO_OR_ONE && type.getQuantifier().canBeEmpty()) {
                    n = 1;
                }
                if (n6 == 1) continue;
                if (n6 == 3) {
                    if (n5 != 1) continue;
                    n5 = 3;
                    continue;
                }
                if (n6 == 0 || this._compiler.isStaticTyping() && n6 == 2) {
                    n5 = 0;
                    break;
                }
                n5 = 2;
            }
            if (n5 == 1 || n5 == 3 && ((ArrayList)cloneable).size() == 0) {
                ASTDecorator2.setChosenFunctionDeclaration(operatorExpr, (FunctionDeclaration)baseConstants);
                XSequenceType xSequenceType = ((SimpleFunctionDeclaration)baseConstants).getReturnType();
                if (bl2 && n == 0) {
                    xSequenceType = xSequenceType.getBaseType();
                }
                ASTDecorator2.setType(operatorExpr, xSequenceType);
                return xSequenceType;
            }
            if (n5 == 3) {
                ASTDecorator2.setChosenFunctionDeclaration(operatorExpr, polymorphicFunctionDeclaration);
                ChoiceType choiceType = Type.NUMERIC;
                ASTDecorator2.setType(operatorExpr, choiceType);
                return choiceType;
            }
            if (n5 != 2) continue;
            ((ArrayList)cloneable).add(baseConstants);
        }
        n2 = ((ArrayList)cloneable).size();
        if (n2 > 0) {
            if (n2 == 1) {
                if (bl) {
                    baseConstants = polymorphicFunctionDeclaration.getReturnType();
                    ASTDecorator2.setChosenFunctionDeclaration(operatorExpr, polymorphicFunctionDeclaration);
                } else {
                    SimpleFunctionDeclaration simpleFunctionDeclaration = (SimpleFunctionDeclaration)((ArrayList)cloneable).get(0);
                    baseConstants = simpleFunctionDeclaration.getReturnType();
                    ASTDecorator2.setChosenFunctionDeclaration(operatorExpr, simpleFunctionDeclaration);
                }
            } else if (n2 == n3) {
                baseConstants = polymorphicFunctionDeclaration.getReturnType();
                ASTDecorator2.setChosenFunctionDeclaration(operatorExpr, polymorphicFunctionDeclaration);
            } else {
                ChoiceType choiceType = new ChoiceType();
                for (n = 0; n < n2; ++n) {
                    SimpleFunctionDeclaration simpleFunctionDeclaration = (SimpleFunctionDeclaration)((ArrayList)cloneable).get(n);
                    choiceType.addType(simpleFunctionDeclaration.getReturnType());
                }
                baseConstants = choiceType;
                ASTDecorator2.setChosenFunctionDeclaration(operatorExpr, polymorphicFunctionDeclaration);
            }
            ASTDecorator2.setType(operatorExpr, (Type)baseConstants);
            return baseConstants;
        }
        ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_ARGUMENTS_UNMATCH");
        throw new StaticError(errorMsg);
    }

    protected Type concatCall(FunctionCall functionCall) throws TypeCheckError {
        int n = functionCall.getOperandCount();
        if (n < 2) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_ARGUMENTS_CONCAT");
            throw new StaticError(errorMsg);
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            Expr expr = functionCall.getOperand(i);
            Type type = this.visitExpression(expr);
            if (null == type || (n2 = (type = type.getAtomizedType()).typeMatchesWithPromotion(ExtendedTypes.ANY_ATOMIC_TYPE_OPTIONAL)) != 0 && (!this._compiler.isStaticTyping() || n2 != 2)) continue;
            ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_ARGUMENTS_UNMATCH");
            throw new StaticError(errorMsg);
        }
        AnyAtomicType anyAtomicType = Type.STRING;
        ASTDecorator2.setType(functionCall, anyAtomicType);
        return anyAtomicType;
    }

    protected Type dataCall(FunctionCall functionCall) throws TypeCheckError {
        Expr expr = functionCall.getOperand(0);
        Type type = this.visitExpression(expr);
        type = type.getAtomizedType();
        ASTDecorator2.setType(functionCall, type);
        return type;
    }

    protected Type distinctValuesCall(FunctionCall functionCall) throws TypeCheckError {
        Type type;
        int n;
        XSequenceType xSequenceType;
        int n2 = functionCall.getOperandCount();
        QName qName = functionCall.getFunctionQName();
        String string = qName.getLocalPart();
        SimpleFunctionDeclaration simpleFunctionDeclaration = (SimpleFunctionDeclaration)this._compiler.getFunctionDeclarationFromSignature(string, n2);
        if (simpleFunctionDeclaration == null) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_FUNCTION_NOT_DEFINED", qName.toString());
            throw new StaticError(errorMsg);
        }
        Expr expr = functionCall.getOperand(0);
        Type type2 = this.visitExpression(expr);
        if (type2 != null) {
            xSequenceType = simpleFunctionDeclaration.getArgumentType(0);
            n = (type2 = type2.getAtomizedType()).typeMatchesWithPromotion(xSequenceType);
            if (n == 0 || this._compiler.isStaticTyping() && n == 2) {
                ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_ARGUMENTS_UNMATCH");
                throw new StaticError(errorMsg);
            }
        }
        if (n2 == 2 && (type = this.visitExpression(expr = functionCall.getOperand(1))) != null) {
            xSequenceType = simpleFunctionDeclaration.getArgumentType(1);
            n = (type = type.getAtomizedType()).typeMatchesWithPromotion(xSequenceType);
            if (n == 0 || this._compiler.isStaticTyping() && n == 2) {
                ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_ARGUMENTS_UNMATCH");
                throw new StaticError(errorMsg);
            }
        }
        Type type3 = type2 != null ? type2.getApproximateType() : null;
        ASTDecorator2.setChosenFunctionDeclaration(functionCall, simpleFunctionDeclaration);
        ASTDecorator2.setType(functionCall, type3);
        return type3;
    }

    protected Type documentCall(FunctionCall functionCall) throws TypeCheckError {
        int n = functionCall.getOperandCount();
        QName qName = functionCall.getFunctionQName();
        String string = qName.getLocalPart();
        SimpleFunctionDeclaration simpleFunctionDeclaration = (SimpleFunctionDeclaration)this._compiler.getFunctionDeclarationFromSignature(string, n);
        boolean bl = simpleFunctionDeclaration.isEmptyReturnOnEmptyArgument();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            Expr expr = functionCall.getOperand(i);
            Type type = this.visitExpression(expr);
            type = type.getAtomizedType();
            int n2 = 1;
            ASTDecorator2.setTypeMatchesResult(expr, n2);
        }
        XSequenceType xSequenceType = simpleFunctionDeclaration.getReturnType();
        if (bl && !bl2) {
            xSequenceType = xSequenceType.getBaseType();
        }
        ASTDecorator2.setChosenFunctionDeclaration(functionCall, simpleFunctionDeclaration);
        ASTDecorator2.setType(functionCall, xSequenceType);
        return xSequenceType;
    }

    protected Type exactlyOneCall(FunctionCall functionCall) throws TypeCheckError {
        Expr expr = functionCall.getOperand(0);
        Type type = this.visitExpression(expr);
        if (type == Type.EMPTY || type.getQuantifier() == OccurrenceIndicator.TWO_OR_MORE) {
            ErrorMsg errorMsg = new ErrorMsg("ER_FUNCTION_TYPE_ERROR_EXACTLY_ONE");
            throw new StaticError(errorMsg);
        }
        Type type2 = type.getPrimeType();
        ASTDecorator2.setType(functionCall, type2);
        return type2;
    }

    protected Type oneOrMoreCall(FunctionCall functionCall) throws TypeCheckError {
        if (functionCall.getOperandCount() > 1) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_FUNCTION_NOT_DEFINED_ARITY", (Object)functionCall.getQName(), (Object)new Integer(functionCall.getOperandCount()));
            throw new StaticError(errorMsg);
        }
        Expr expr = functionCall.getOperand(0);
        Type type = this.visitExpression(expr);
        OccurrenceIndicator occurrenceIndicator = type.getQuantifier();
        Type type2 = occurrenceIndicator == OccurrenceIndicator.ZERO_OR_ONE || occurrenceIndicator == OccurrenceIndicator.ONE ? type.getPrimeType() : (occurrenceIndicator == OccurrenceIndicator.ZERO_OR_MORE ? TypeFactory.newType(type.getPrimeType(), OccurrenceIndicator.ONE_OR_MORE) : type);
        ASTDecorator2.setType(functionCall, type2);
        return type2;
    }

    protected Type sumCall(FunctionCall functionCall) throws TypeCheckError {
        int n;
        XSequenceType xSequenceType;
        int n2 = functionCall.getOperandCount();
        QName qName = functionCall.getFunctionQName();
        String string = qName.getLocalPart();
        SimpleFunctionDeclaration simpleFunctionDeclaration = (SimpleFunctionDeclaration)this._compiler.getFunctionDeclarationFromSignature(string, n2);
        Type type = null;
        Type type2 = null;
        Type type3 = null;
        Expr expr = functionCall.getOperand(0);
        type = this.visitExpression(expr);
        if (type == null) {
            xSequenceType = simpleFunctionDeclaration.getArgumentType(0);
            n = (type = type.getAtomizedType()).typeMatchesWithPromotion(xSequenceType);
            if (n == 0 || this._compiler.isStaticTyping() && n == 2) {
                ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_ARGUMENTS_UNMATCH");
                throw new StaticError(errorMsg);
            }
        }
        if (n2 == 2 && null == (type2 = this.visitExpression(expr = functionCall.getOperand(1)))) {
            xSequenceType = simpleFunctionDeclaration.getArgumentType(1);
            n = (type2 = type2.getAtomizedType()).typeMatchesWithPromotion(xSequenceType);
            if (n == 0 || this._compiler.isStaticTyping() && n == 2) {
                ErrorMsg errorMsg = new ErrorMsg("TYPE_ERR_ARGUMENTS_UNMATCH");
                throw new StaticError(errorMsg);
            }
        }
        if (null != type) {
            type3 = TypeFactory.newType(type.getPrimeType(), type.getQuantifier());
        }
        if (n2 == 2 && type != null && type2 != null) {
            type3 = TypeFactory.newChoiceType(type, type2);
        }
        ASTDecorator2.setChosenFunctionDeclaration(functionCall, simpleFunctionDeclaration);
        ASTDecorator2.setType(functionCall, type3);
        return type3;
    }

    protected Type unorderedCall(FunctionCall functionCall) throws TypeCheckError {
        Expr expr = functionCall.getOperand(0);
        Type type = this.visitExpression(expr);
        Type type2 = type.getApproximateType();
        ASTDecorator2.setType(functionCall, type2);
        return type;
    }

    protected Type zeroOrOneCall(FunctionCall functionCall) throws TypeCheckError {
        Type type;
        if (functionCall.getOperandCount() > 1) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_FUNCTION_NOT_DEFINED_ARITY", (Object)functionCall.getQName(), (Object)new Integer(functionCall.getOperandCount()));
            throw new StaticError(errorMsg);
        }
        Expr expr = functionCall.getOperand(0);
        Type type2 = this.visitExpression(expr);
        OccurrenceIndicator occurrenceIndicator = type2.getQuantifier();
        if (occurrenceIndicator == OccurrenceIndicator.ONE || occurrenceIndicator == OccurrenceIndicator.ZERO_OR_ONE) {
            type = type2;
        } else if (occurrenceIndicator == OccurrenceIndicator.ONE_OR_MORE) {
            type = type2.getPrimeType();
        } else if (occurrenceIndicator == OccurrenceIndicator.ZERO_OR_MORE) {
            type = TypeFactory.newType(type2.getPrimeType(), OccurrenceIndicator.ZERO_OR_ONE);
        } else {
            ErrorMsg errorMsg = new ErrorMsg("ER_FUNCTION_TYPE_ERROR_ZERO_OR_ONE");
            throw new StaticError(errorMsg);
        }
        ASTDecorator2.setType(functionCall, type);
        return type;
    }

    protected Type functionAvailable(FunctionCall functionCall) throws TypeCheckError {
        Expr expr = functionCall.getOperand(0);
        Type type = this.visitExpression(expr);
        ASTDecorator2.setType(expr, type);
        if (functionCall.getOperandCount() > 1) {
            Expr expr2 = functionCall.getOperand(1);
            Type type2 = this.visitExpression(expr);
            ASTDecorator2.setType(expr2, type2);
        }
        ASTDecorator2.setType(functionCall, Type.BOOLEAN);
        return Type.BOOLEAN;
    }

    protected Type elementAvailableCall(FunctionCall functionCall) {
        if (functionCall.getOperand(0) instanceof Literal) {
            return Type.BOOLEAN;
        }
        ErrorMsg errorMsg = new ErrorMsg("NEED_LITERAL_ERR", (Object)"element-available", (Object)this);
        throw new StaticError(errorMsg);
    }

    protected Type formatNumberCall(FunctionCall functionCall) {
        return Type.STRING;
    }

    protected Type functionAvailableCall(FunctionCall functionCall) {
        if (functionCall.getOperand(0) instanceof Literal) {
            boolean bl = XSLTCHelper.evaluateFunctionAvailableAtCompileTime(functionCall, this._compiler, this.getExtensionFunctionTable());
            ASTDecorator.setFunctionAvailable(functionCall, bl);
            return Type.BOOLEAN;
        }
        ErrorMsg errorMsg = new ErrorMsg("NEED_LITERAL_ERR", (Object)"function-available", (Object)this);
        throw new StaticError(errorMsg);
    }

    protected Type idCall(FunctionCall functionCall) throws TypeCheckError {
        this._compiler.setHasIdCall(true);
        return this.standardFunctionCall(functionCall);
    }

    protected Type keyCall(FunctionCall functionCall) throws TypeCheckError {
        Type type = this.standardFunctionCall(functionCall);
        Expr expr = functionCall.getOperand(0);
        Type type2 = this.visitExpression(expr);
        expr = functionCall.getOperand(1);
        type2 = this.visitExpression(expr);
        return type;
    }

    protected Type langCall(FunctionCall functionCall) throws TypeCheckError {
        Expr expr = functionCall.getOperand(0);
        Type type = this.visitExpression(expr);
        return Type.BOOLEAN;
    }

    protected Type trueFalseCall(FunctionCall functionCall) {
        if (functionCall.getOperandCount() != 0) {
            throw new StaticError(functionCall);
        }
        return Type.BOOLEAN;
    }

    protected boolean isExtensionFunction(FunctionCall functionCall) {
        String string = functionCall.getFunctionQName().getNamespaceURI();
        return string != null && string.length() > 0 && !string.equals("http://xml.apache.org/xalan/xsltc");
    }

    protected boolean isStylesheetFunctionCall(FunctionCall functionCall) {
        return XSLTCHelper.isStylesheetFunctionCall(functionCall, this._compiler);
    }

    protected Type stylesheetFunctionCall(FunctionCall functionCall) throws TypeCheckError {
        FunctionDecl functionDecl = XSLTCHelper.getStylesheetFunctionCall(functionCall, this._compiler);
        if (functionDecl == null) {
            throw new StaticError(functionCall);
        }
        ASTDecorator2.setFunction(functionCall, functionDecl);
        int n = functionCall.getOperandCount();
        for (int i = 0; i < n; ++i) {
            Expr expr = functionCall.getOperand(i);
            Type type = this.visitExpression(expr);
            if (null == type) continue;
            ASTDecorator2.setType(expr, type);
        }
        Type type = ASTDecorator2.getFunctionType(functionDecl);
        if (type != null) {
            ASTDecorator2.setType(functionCall, type);
        }
        return type;
    }

    protected boolean isJAXPFunctionCall(FunctionCall functionCall) {
        return XSLTCHelper.isJAXPFunctionCall(functionCall, this._compiler);
    }

    protected Type jaxpFunctionCall(FunctionCall functionCall) throws TypeCheckError {
        return Type.UNTYPEDATOMIC;
    }

    protected Hashtable getExtensionFunctionTable() {
        return _extensionFunctionTable;
    }

    protected Type defaultCollationCall(FunctionCall functionCall) {
        int n = functionCall.getOperandCount();
        if (n != 0) {
            throw new StaticError("ILLEGAL_ARG_ERR", functionCall.getFunctionQName().toString(), this);
        }
        return Type.STRING;
    }

    protected Type normalizeUnicodeCall(FunctionCall functionCall) throws TypeCheckError {
        Type type = null;
        Expr expr = null;
        int n = functionCall.getOperandCount();
        if (n != 1 && n != 2) {
            throw new StaticError("ILLEGAL_ARG_ERR", functionCall.getFunctionQName().toString(), this);
        }
        for (int i = 0; i < n; ++i) {
            expr = functionCall.getOperand(i);
            type = this.visitExpression(expr);
        }
        return Type.STRING;
    }

    protected Type regexGroupCall(FunctionCall functionCall) throws TypeCheckError {
        Expr expr = functionCall.getOperand(0);
        if (functionCall.getOperandCount() != 1) {
            throw new StaticError(functionCall);
        }
        Type type = this.visitExpression(expr);
        return Type.STRING;
    }

    protected Type constructorCall(FunctionCall functionCall) throws TypeCheckError {
        QName qName = functionCall.getFunctionQName();
        Type type = (Type)((Object)this.getCompiler().getTypeFactory().getTypeFromName(qName));
        Expr expr = functionCall.getOperand(0);
        Type type2 = this.visitExpression(expr);
        if (type == null) {
            throw new StaticError(functionCall);
        }
        if (!(type instanceof AnyAtomicType)) {
            throw new StaticError(functionCall);
        }
        if (type == Type.ANYATOMICTYPE) {
            throw new StaticError(functionCall);
        }
        XSequenceType xSequenceType = new XSequenceType((AnyAtomicType)type, OccurrenceIndicator.ZERO_OR_ONE);
        ASTDecorator2.setType(expr, type2);
        ASTDecorator2.setType(functionCall, xSequenceType);
        return type;
    }

    protected Type nodeIsInSequenceCall(FunctionCall functionCall) throws TypeCheckError {
        int n;
        QName qName = functionCall.getFunctionQName();
        String string = qName.getLocalPart();
        Object object = this._compiler.getFunctionDeclarationFromSignature(string, n = functionCall.getOperandCount());
        if (object == null) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_FUNCTION_NOT_DEFINED_ARITY", (Object)qName.toString(), (Object)new Integer(n));
            throw new StaticError(errorMsg);
        }
        return this.standardSimpleFunctionCall((SimpleFunctionDeclaration)object, functionCall);
    }

    static {
        special_funcs.add("timezone-from-dateTime");
        special_funcs.add("timezone-from-date");
        special_funcs.add("timezone-from-time");
        special_funcs.add("base-uri");
        special_funcs.add("document-uri");
        special_funcs.add("nilled");
        special_funcs.add("node-name");
    }
}

