/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.dtm.utils;

public class SuballocatedIntVector {
    protected int m_blocksize;
    protected int m_SHIFT = 0;
    protected int m_MASK;
    protected static final int NUMBLOCKS_DEFAULT = 32;
    protected int m_numblocks = 32;
    protected int[][] m_map;
    protected int m_firstFree = 0;
    protected int[] m_map0;
    protected int[] m_buildCache;
    protected int m_buildCacheStartIndex = 0;

    public SuballocatedIntVector() {
        this(2048);
    }

    public SuballocatedIntVector(int n, int n2) {
        while (0 != (n >>>= 1)) {
            ++this.m_SHIFT;
        }
        this.m_blocksize = 1 << this.m_SHIFT;
        this.m_MASK = this.m_blocksize - 1;
        this.m_numblocks = n2;
        this.m_map = new int[n2][];
        this.m_buildCache = new int[this.m_blocksize];
        this.m_map0 = this.m_buildCache;
        this.m_map[0] = this.m_buildCache;
        this.m_buildCacheStartIndex = 0;
    }

    public SuballocatedIntVector(int n) {
        this(n, 32);
    }

    public int size() {
        return this.m_firstFree;
    }

    public void setSize(int n) {
        if (this.m_firstFree > n) {
            this.m_firstFree = n;
        }
    }

    public void addElement(int n) {
        int n2 = this.m_firstFree - this.m_buildCacheStartIndex;
        if (n2 >= 0 && n2 < this.m_blocksize) {
            this.m_buildCache[n2] = n;
            ++this.m_firstFree;
        } else {
            Object object;
            int n3 = this.m_firstFree & this.m_MASK;
            int n4 = this.m_firstFree >>> this.m_SHIFT;
            if (n4 >= this.m_map.length) {
                object = new int[n4 + this.m_numblocks][];
                System.arraycopy(this.m_map, 0, object, 0, this.m_map.length);
                this.m_map = (int[][])object;
            }
            if (null == (object = this.m_map[n4])) {
                this.m_map[n4] = new int[this.m_blocksize];
                object = this.m_map[n4];
            }
            object[n3] = n;
            this.m_buildCache = object;
            this.m_buildCacheStartIndex = this.m_firstFree - n3;
            ++this.m_firstFree;
        }
    }

    private void addElements(int n, int n2) {
        if (this.m_firstFree + n2 < this.m_blocksize) {
            for (int i = 0; i < n2; ++i) {
                this.m_map0[this.m_firstFree++] = n;
            }
        } else {
            int n3 = this.m_firstFree >>> this.m_SHIFT;
            int n4 = this.m_firstFree & this.m_MASK;
            this.m_firstFree += n2;
            while (n2 > 0) {
                int[] nArray;
                if (n3 >= this.m_map.length) {
                    int n5 = n3 + this.m_numblocks;
                    int[][] nArrayArray = new int[n5][];
                    System.arraycopy(this.m_map, 0, nArrayArray, 0, this.m_map.length);
                    this.m_map = nArrayArray;
                }
                if (null == (nArray = this.m_map[n3])) {
                    this.m_map[n3] = new int[this.m_blocksize];
                    nArray = this.m_map[n3];
                }
                int n6 = this.m_blocksize - n4 < n2 ? this.m_blocksize - n4 : n2;
                n2 -= n6;
                while (n6-- > 0) {
                    nArray[n4++] = n;
                }
                ++n3;
                n4 = 0;
            }
        }
    }

    private void addElements(int n) {
        int n2 = this.m_firstFree + n;
        if (n2 > this.m_blocksize) {
            int n3 = this.m_firstFree >>> this.m_SHIFT;
            int n4 = this.m_firstFree + n >>> this.m_SHIFT;
            for (int i = n3 + 1; i <= n4; ++i) {
                this.m_map[i] = new int[this.m_blocksize];
            }
        }
        this.m_firstFree = n2;
    }

    private void insertElementAt(int n, int n2) {
        if (n2 == this.m_firstFree) {
            this.addElement(n);
        } else if (n2 > this.m_firstFree) {
            int[] nArray;
            int n3 = n2 >>> this.m_SHIFT;
            if (n3 >= this.m_map.length) {
                int n4 = n3 + this.m_numblocks;
                int[][] nArrayArray = new int[n4][];
                System.arraycopy(this.m_map, 0, nArrayArray, 0, this.m_map.length);
                this.m_map = nArrayArray;
            }
            if (null == (nArray = this.m_map[n3])) {
                this.m_map[n3] = new int[this.m_blocksize];
                nArray = this.m_map[n3];
            }
            int n5 = n2 & this.m_MASK;
            nArray[n5] = n;
            this.m_firstFree = n5 + 1;
        } else {
            int n6 = this.m_firstFree >>> this.m_SHIFT;
            ++this.m_firstFree;
            int n7 = n2 & this.m_MASK;
            for (int i = n2 >>> this.m_SHIFT; i <= n6; ++i) {
                int n8;
                int n9 = this.m_blocksize - n7 - 1;
                int[] nArray = this.m_map[i];
                if (null == nArray) {
                    n8 = 0;
                    this.m_map[i] = new int[this.m_blocksize];
                    nArray = this.m_map[i];
                } else {
                    n8 = nArray[this.m_blocksize - 1];
                    System.arraycopy(nArray, n7, nArray, n7 + 1, n9);
                }
                nArray[n7] = n;
                n = n8;
                n7 = 0;
            }
        }
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
        this.m_buildCache = this.m_map0;
        this.m_buildCacheStartIndex = 0;
    }

    private boolean removeElement(int n) {
        int n2 = this.indexOf(n, 0);
        if (n2 < 0) {
            return false;
        }
        this.removeElementAt(n2);
        return true;
    }

    public void removeElementAt(int n) {
        if (n < this.m_firstFree) {
            int n2 = this.m_firstFree >>> this.m_SHIFT;
            int n3 = n & this.m_MASK;
            for (int i = n >>> this.m_SHIFT; i <= n2; ++i) {
                int n4 = this.m_blocksize - n3 - 1;
                int[] nArray = this.m_map[i];
                if (null == nArray) {
                    this.m_map[i] = new int[this.m_blocksize];
                    nArray = this.m_map[i];
                } else {
                    System.arraycopy(nArray, n3 + 1, nArray, n3, n4);
                }
                if (i < n2) {
                    int[] nArray2 = this.m_map[i + 1];
                    if (nArray2 != null) {
                        nArray[this.m_blocksize - 1] = nArray2 != null ? nArray2[0] : 0;
                    }
                } else {
                    nArray[this.m_blocksize - 1] = 0;
                }
                n3 = 0;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(int n, int n2) {
        if (n2 < this.m_blocksize) {
            this.m_map0[n2] = n;
        } else {
            int[] nArray;
            int n3 = n2 >>> this.m_SHIFT;
            int n4 = n2 & this.m_MASK;
            if (n3 >= this.m_map.length) {
                int n5 = n3 + this.m_numblocks;
                int[][] nArrayArray = new int[n5][];
                System.arraycopy(this.m_map, 0, nArrayArray, 0, this.m_map.length);
                this.m_map = nArrayArray;
            }
            if (null == (nArray = this.m_map[n3])) {
                this.m_map[n3] = new int[this.m_blocksize];
                nArray = this.m_map[n3];
            }
            nArray[n4] = n;
        }
        if (n2 >= this.m_firstFree) {
            this.m_firstFree = n2 + 1;
        }
    }

    public int elementAt(int n) {
        if (n < this.m_blocksize) {
            return this.m_map0[n];
        }
        return this.m_map[n >>> this.m_SHIFT][n & this.m_MASK];
    }

    private boolean contains(int n) {
        return this.indexOf(n, 0) >= 0;
    }

    public int indexOf(int n, int n2) {
        int n3;
        int[] nArray;
        if (n2 >= this.m_firstFree) {
            return -1;
        }
        int n4 = n2 & this.m_MASK;
        int n5 = this.m_firstFree >>> this.m_SHIFT;
        for (int i = n2 >>> this.m_SHIFT; i < n5; ++i) {
            nArray = this.m_map[i];
            if (nArray != null) {
                for (n3 = n4; n3 < this.m_blocksize; ++n3) {
                    if (nArray[n3] != n) continue;
                    return n3 + i * this.m_blocksize;
                }
            }
            n4 = 0;
        }
        n3 = this.m_firstFree & this.m_MASK;
        nArray = this.m_map[n5];
        for (int i = n4; i < n3; ++i) {
            if (nArray[i] != n) continue;
            return i + n5 * this.m_blocksize;
        }
        return -1;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    private int lastIndexOf(int n) {
        int n2 = this.m_firstFree & this.m_MASK;
        for (int i = this.m_firstFree >>> this.m_SHIFT; i >= 0; --i) {
            int[] nArray = this.m_map[i];
            if (nArray != null) {
                for (int j = n2; j >= 0; --j) {
                    if (nArray[j] != n) continue;
                    return j + i * this.m_blocksize;
                }
            }
            n2 = 0;
        }
        return -1;
    }

    public final int[] getMap0() {
        return this.m_map0;
    }

    public final int[][] getMap() {
        return this.m_map;
    }
}

