/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.datatype;

import com.ibm.xml.jaxp.datatype.Duration2;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.Duration;
import org.apache.xerces.jaxp.datatype.AbstractDurationImpl;
import org.apache.xerces.jaxp.datatype.DateTimeUtil;
import org.apache.xerces.jaxp.datatype.SerializedDuration;
import org.apache.xerces.util.DatatypeMessageFormatter;

final class DurationImpl
extends AbstractDurationImpl
implements Serializable {
    private static final long serialVersionUID = -2650025807136350131L;
    private final int sign;
    private final BigInteger years;
    private final BigInteger months;
    private final BigInteger days;
    private final BigInteger hours;
    private final BigInteger minutes;
    private final BigDecimal seconds;

    public DurationImpl(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) {
        this.sign = n;
        if (bigInteger != null && bigInteger.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{bigInteger}));
        }
        this.years = bigInteger;
        if (bigInteger2 != null && bigInteger2.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{bigInteger2}));
        }
        this.months = bigInteger2;
        if (bigInteger3 != null && bigInteger3.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{bigInteger3}));
        }
        this.days = bigInteger3;
        if (bigInteger4 != null && bigInteger4.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{bigInteger4}));
        }
        this.hours = bigInteger4;
        if (bigInteger5 != null && bigInteger5.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{bigInteger5}));
        }
        this.minutes = bigInteger5;
        if (bigDecimal != null && bigDecimal.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{bigDecimal}));
        }
        this.seconds = bigDecimal;
    }

    public DurationImpl(long l) {
        boolean bl = false;
        if (l == 0L) {
            this.sign = 0;
            this.years = null;
            this.months = null;
            this.days = null;
            this.hours = null;
            this.minutes = null;
            this.seconds = null;
            return;
        }
        if (l < 0L) {
            this.sign = -1;
            if (l == Long.MIN_VALUE) {
                ++l;
                bl = true;
            }
            l *= -1L;
        } else {
            this.sign = 1;
        }
        this.years = null;
        this.months = null;
        long l2 = l / 86400000L;
        this.days = l2 != 0L ? BigInteger.valueOf(l2) : null;
        l -= l2 * 86400000L;
        l2 = l / 3600000L;
        this.hours = l2 != 0L ? BigInteger.valueOf(l2) : null;
        l -= l2 * 3600000L;
        l2 = l / 60000L;
        this.minutes = l2 != 0L ? BigInteger.valueOf(l2) : null;
        l -= l2 * 60000L;
        if (bl) {
            ++l;
        }
        this.seconds = BigDecimal.valueOf(l, 3);
    }

    public DurationImpl(boolean bl, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) throws UnsupportedOperationException, IllegalArgumentException {
        if (bigInteger != null && bigInteger.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{bigInteger}));
        }
        this.years = bigInteger;
        if (bigInteger2 != null && bigInteger2.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{bigInteger2}));
        }
        this.months = bigInteger2;
        if (bigInteger3 != null && bigInteger3.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{bigInteger3}));
        }
        this.days = bigInteger3;
        if (bigInteger4 != null && bigInteger4.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{bigInteger4}));
        }
        this.hours = bigInteger4;
        if (bigInteger5 != null && bigInteger5.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{bigInteger5}));
        }
        this.minutes = bigInteger5;
        if (bigDecimal != null && bigDecimal.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{bigDecimal}));
        }
        this.seconds = bigDecimal;
        this.sign = !(bigInteger != null && bigInteger.signum() != 0 || bigInteger2 != null && bigInteger2.signum() != 0 || bigInteger3 != null && bigInteger3.signum() != 0 || bigInteger4 != null && bigInteger4.signum() != 0 || bigInteger5 != null && bigInteger5.signum() != 0 || bigDecimal != null && bigDecimal.signum() != 0) ? 0 : (bl ? 1 : -1);
    }

    public DurationImpl(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal, boolean bl) throws UnsupportedOperationException, IllegalArgumentException {
        this.years = bigInteger;
        this.months = bigInteger2;
        this.days = bigInteger3;
        this.hours = bigInteger4;
        this.minutes = bigInteger5;
        this.seconds = bigDecimal;
        this.sign = !(bigInteger != null && bigInteger.signum() != 0 || bigInteger2 != null && bigInteger2.signum() != 0 || bigInteger3 != null && bigInteger3.signum() != 0 || bigInteger4 != null && bigInteger4.signum() != 0 || bigInteger5 != null && bigInteger5.signum() != 0 || bigDecimal != null && bigDecimal.signum() != 0) ? 0 : (bl ? 1 : -1);
    }

    public int getSign() {
        return this.sign;
    }

    BigInteger getYearsField() {
        return this.years;
    }

    BigInteger getMonthsField() {
        return this.months;
    }

    BigInteger getDaysField() {
        return this.days;
    }

    BigInteger getHoursField() {
        return this.hours;
    }

    BigInteger getMinutesField() {
        return this.minutes;
    }

    BigDecimal getSecondsField() {
        return this.seconds;
    }

    boolean isYearsSet() {
        return this.years != null;
    }

    boolean isMonthsSet() {
        return this.months != null;
    }

    boolean isDaysSet() {
        return this.days != null;
    }

    boolean isHoursSet() {
        return this.hours != null;
    }

    boolean isMinutesSet() {
        return this.minutes != null;
    }

    boolean isSecondsSet() {
        return this.seconds != null;
    }

    public Duration negate() {
        return new DurationImpl(-1 * this.sign, this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    public Duration normalizeWith(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, this.sign * this.getYears());
        calendar2.add(2, this.sign * this.getMonths());
        calendar2.add(5, this.sign * this.getDays());
        long l = calendar2.getTime().getTime() - calendar.getTime().getTime();
        int n = (int)(l / 86400000L);
        int n2 = 1;
        if (!(n != 0 || this.hours != null && this.hours.signum() != 0 || this.minutes != null && this.minutes.signum() != 0 || this.seconds != null && this.seconds.signum() != 0)) {
            n2 = 0;
        } else if (n < 0) {
            n2 = -1;
        }
        return new DurationImpl(n2, null, null, BigInteger.valueOf(n).abs(), this.hours, this.minutes, this.seconds);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.sign == -1) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (this.years != null) {
            stringBuffer.append(this.years);
            stringBuffer.append('Y');
        }
        if (this.months != null) {
            stringBuffer.append(this.months);
            stringBuffer.append('M');
        }
        if (this.days != null) {
            stringBuffer.append(this.days);
            stringBuffer.append('D');
        }
        if (this.hours != null || this.minutes != null || this.seconds != null) {
            stringBuffer.append('T');
            if (this.hours != null) {
                stringBuffer.append(this.hours);
                stringBuffer.append('H');
            }
            if (this.minutes != null) {
                stringBuffer.append(this.minutes);
                stringBuffer.append('M');
            }
            if (this.seconds != null) {
                stringBuffer.append(this.toString(this.seconds));
                stringBuffer.append('S');
            }
        }
        return stringBuffer.toString();
    }

    private String toString(BigDecimal bigDecimal) {
        StringBuffer stringBuffer;
        String string = bigDecimal.unscaledValue().toString();
        int n = bigDecimal.scale();
        if (n == 0) {
            return string;
        }
        int n2 = string.length() - n;
        if (n2 == 0) {
            return "0." + string;
        }
        if (n2 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n2, '.');
        } else {
            stringBuffer = new StringBuffer(3 - n2 + string.length());
            stringBuffer.append("0.");
            int n3 = 0;
            while (n3 < -n2) {
                stringBuffer.append('0');
                ++n3;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    BigDecimal[] createBigDecimalArray() {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this.years != null ? new BigDecimal(this.years) : AbstractDurationImpl.ZERO, this.months != null ? new BigDecimal(this.months) : AbstractDurationImpl.ZERO, this.days != null ? new BigDecimal(this.days) : AbstractDurationImpl.ZERO, this.hours != null ? new BigDecimal(this.hours) : AbstractDurationImpl.ZERO, this.minutes != null ? new BigDecimal(this.minutes) : AbstractDurationImpl.ZERO, this.seconds != null ? this.seconds : AbstractDurationImpl.ZERO};
        return bigDecimalArray;
    }

    private Object writeReplace() throws IOException {
        return new SerializedDuration(this.toString());
    }

    public boolean areFieldsPrimitive() {
        return false;
    }

    public boolean hasFractionalSeconds() {
        return this.seconds != null && this.toString(this.seconds).indexOf(46) != -1;
    }

    public Duration2 asDurationYearMonth() {
        if (!this.isYearsSet() && !this.isMonthsSet()) {
            return AbstractDurationImpl.ZERO_MONTHS;
        }
        if (!(this.isDaysSet() || this.isHoursSet() || this.isMinutesSet() || this.isSecondsSet())) {
            return this;
        }
        return new DurationImpl(this.sign >= 0, this.years, this.months, null, null, null, null);
    }

    public Duration2 asDurationDayTime() {
        if (!(this.isDaysSet() || this.isHoursSet() || this.isMinutesSet() || this.isSecondsSet())) {
            return AbstractDurationImpl.ZERO_SECONDS;
        }
        if (!this.isYearsSet() && !this.isMonthsSet()) {
            return this;
        }
        return new DurationImpl(this.sign >= 0, null, null, this.days, this.hours, this.minutes, this.seconds);
    }

    public String toFOFormat() {
        boolean bl;
        BigInteger bigInteger;
        int n;
        Object object;
        Object object2;
        BigInteger[] bigIntegerArray;
        Object object3;
        if (this.sign == 0) {
            return this.toZeroDurationFOStringFormat();
        }
        int n2 = 0;
        BigDecimal bigDecimal = AbstractDurationImpl.ZERO;
        BigInteger bigInteger2 = AbstractDurationImpl.I_ZERO;
        if (this.seconds != null) {
            BigInteger bigInteger3 = this.seconds.toBigInteger();
            bigDecimal = bigInteger3.compareTo(AbstractDurationImpl.I_ZERO) > 0 ? this.seconds.subtract(new BigDecimal(bigInteger3)) : this.seconds;
            object3 = bigInteger3.divideAndRemainder(AbstractDurationImpl.I_SIXTY);
            n2 = object3[1].intValue();
            bigInteger2 = object3[0];
        }
        int n3 = 0;
        object3 = AbstractDurationImpl.I_ZERO;
        if (this.minutes != null) {
            bigIntegerArray = this.minutes.add(bigInteger2).divideAndRemainder(AbstractDurationImpl.I_SIXTY);
            n3 = bigIntegerArray[1].intValue();
            object3 = bigIntegerArray[0];
        } else if (bigInteger2.compareTo(AbstractDurationImpl.I_ZERO) > 0) {
            bigIntegerArray = bigInteger2.divideAndRemainder(AbstractDurationImpl.I_SIXTY);
            n3 = bigIntegerArray[1].intValue();
            object3 = bigIntegerArray[0];
        }
        int n4 = 0;
        BigInteger bigInteger4 = AbstractDurationImpl.I_ZERO;
        if (this.hours != null) {
            object2 = this.hours.add((BigInteger)object3).divideAndRemainder(AbstractDurationImpl.TWENTY_FOUR);
            n4 = object2[1].intValue();
            bigInteger4 = object2[0];
        } else if (object3.compareTo(AbstractDurationImpl.I_ZERO) > 0) {
            object2 = object3.divideAndRemainder(AbstractDurationImpl.TWENTY_FOUR);
            n4 = object2[1].intValue();
            bigInteger4 = object2[0];
        }
        object2 = this.days != null ? this.days.add(bigInteger4) : bigInteger4;
        if (this.months != null) {
            object = this.months.divideAndRemainder(AbstractDurationImpl.TWELVE);
            n = object[1].intValue();
            bigInteger = object[0];
        } else {
            n = 0;
            bigInteger = AbstractDurationImpl.I_ZERO;
        }
        object = this.years != null ? this.years.add(bigInteger) : bigInteger;
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.sign == -1) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (((BigInteger)object).compareTo(AbstractDurationImpl.I_ZERO) > 0) {
            stringBuffer.append(object);
            stringBuffer.append('Y');
        }
        if (n > 0) {
            stringBuffer.append(n);
            stringBuffer.append('M');
        }
        if (((BigInteger)object2).compareTo(AbstractDurationImpl.I_ZERO) > 0) {
            stringBuffer.append(object2);
            stringBuffer.append('D');
        }
        boolean bl2 = bl = bigDecimal.compareTo(AbstractDurationImpl.ZERO) > 0;
        if (n4 > 0 || n3 > 0 || n2 > 0 || bl) {
            stringBuffer.append('T');
            if (n4 > 0) {
                stringBuffer.append(n4);
                stringBuffer.append('H');
            }
            if (n3 > 0) {
                stringBuffer.append(n3);
                stringBuffer.append('M');
            }
            if (n2 > 0) {
                stringBuffer.append(n2);
                if (bl) {
                    stringBuffer.append(DateTimeUtil.stripTrailingZeros(this.toString(bigDecimal).substring(1)));
                }
                stringBuffer.append('S');
            } else if (bl) {
                stringBuffer.append(DateTimeUtil.stripTrailingZeros(this.toString(bigDecimal)));
                stringBuffer.append('S');
            }
        }
        return stringBuffer.toString();
    }
}

