/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.translator.v1.TranslatorContext;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.types.SAXEventsLibrary;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.AndInstruction;
import com.ibm.xylem.instructions.AssertTypeInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xylem.instructions.NotInstruction;
import com.ibm.xylem.instructions.OrInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.TypeMatchInstruction;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SerializationHelper {
    private static final boolean s_debug = false;
    private static final boolean m_skipSpecialAttributeFix = false;
    static final Logger s_logger = Logger.getInstance(SerializationHelper.class);
    private static final int s_numbCounts = 11;
    private static final int[] s_guard_count = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] s_guard_not_removed_count = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] s_guard_removed_count = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static Type s_saxEventStreamType = SAXEventsLibrary.getSAXEventStream();
    private static Type s_saxEventType = SAXEventsLibrary.getSAXEvent();
    private static final String[] s_specialElementsArray = new String[]{"area", "button", "dir", "dl", "frame", "hr", "img", "input", "menu", "object", "ol", "optgroup", "option", "script", "select", "td", "textarea", "th", "ul"};
    private static final String[] s_specialAttributesArray = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"};
    private static Map specialElementAttributeMap = null;

    public static String getGuardCountDesc() {
        boolean bl = true;
        String string = "";
        string = string + s_guard_count[0] + "(+" + s_guard_not_removed_count[0] + ") (-" + s_guard_removed_count[0] + " * 0 - duplicate attr guard function\n";
        string = string + s_guard_count[1] + "(+" + s_guard_not_removed_count[1] + ") (-" + s_guard_removed_count[1] + " * 1 - unknown element - wrapping template call with fix-html-special-attributes\n";
        string = string + s_guard_count[2] + "(+" + s_guard_not_removed_count[2] + ") (-" + s_guard_removed_count[2] + " * 2 - known element - wrapping template call with fix-html-special-attributes\n";
        string = string + s_guard_count[3] + "(+" + s_guard_not_removed_count[3] + ") (-" + s_guard_removed_count[3] + " * 3 - unknown element, known attr - calling modifySpecialAttributeForElement\n";
        string = string + s_guard_count[4] + "(+" + s_guard_not_removed_count[4] + ") (-" + s_guard_removed_count[4] + " * 4 - unknown element, possibly unknown attr - calling modifySpecialAttributeForElement\n";
        string = string + s_guard_count[5] + "(+" + s_guard_not_removed_count[5] + ") (-" + s_guard_removed_count[5] + " * 5 - known element, unknown attribute - expanding to or-test\n";
        if (bl) {
            return " Not Removed: (" + s_guard_not_removed_count[0] + ", " + s_guard_not_removed_count[1] + ", " + s_guard_not_removed_count[2] + ", " + s_guard_not_removed_count[3] + ", " + s_guard_not_removed_count[4] + ", " + s_guard_not_removed_count[5] + ") " + " Added: (" + s_guard_count[0] + ", " + s_guard_count[1] + ", " + s_guard_count[2] + ", " + s_guard_count[3] + ", " + s_guard_count[4] + ", " + s_guard_count[5] + ")" + " Removed: (" + s_guard_removed_count[0] + ", " + s_guard_removed_count[1] + ", " + s_guard_removed_count[2] + ", " + s_guard_removed_count[3] + ", " + s_guard_removed_count[4] + ", " + s_guard_removed_count[5] + ")";
        }
        return string;
    }

    public static void bumpGuardCount(int n) {
    }

    public static void bumpGuardNotRemovedCount(int n) {
    }

    public static void bumpGuardRemovedCount(int n) {
    }

    private static Instruction fixupAttrsHelper(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        LinkedList linkedList = new LinkedList();
        int n = list.size();
        for (int i = n - 1; i >= 0; --i) {
            Attribute attribute = (Attribute)list.get(i);
            if (attribute.isString()) {
                if (hashSet.contains(attribute.m_nameString)) {
                    s_logger.info("Replacing duplicate attr " + attribute.m_nameString + ":\nIgnoring (" + attribute.m_valueArray + "), Using newer value");
                    continue;
                }
                hashSet.add(attribute.m_nameString);
                attribute.addAtBegining(linkedList);
                continue;
            }
            attribute.addAtBegining(linkedList);
        }
        return new StreamInstruction(s_saxEventType, linkedList);
    }

    private static boolean isAllUniqueNames(ArrayList arrayList) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)arrayList.get(i);
            if (!attribute.isString()) {
                return false;
            }
            if (hashSet.contains(attribute.m_nameString)) {
                return false;
            }
            hashSet.add(attribute.m_nameString);
        }
        return true;
    }

    private static Instruction defineAttrs(ArrayList arrayList, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n = arrayList.size();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Instruction> hashMap2 = new HashMap<String, Instruction>();
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<ChooseInstruction> linkedList2 = new LinkedList<ChooseInstruction>();
        boolean bl2 = SerializationHelper.isAllUniqueNames(arrayList);
        for (int i = 0; i < n; ++i) {
            Attribute object4 = (Attribute)arrayList.get(i);
            if (object4.isString()) {
                if (!(bl || !object4.isValueString() && object4.getCondition() == LiteralInstruction.booleanTrueLiteral() || bl2)) {
                    return null;
                }
                object3 = new StreamInstruction(s_saxEventType, new Instruction[]{object4.getBeginAttribute(), object4.getAttrText(), object4.getEndAttribute()});
                if (object4.isSpecial()) {
                    object3 = new StreamInstruction(s_saxEventType, new Instruction[]{object4.getBeginAttributeHTML()});
                }
                object2 = new ChooseInstruction.Case(object4.getCondition(), (Instruction)object3);
                if (hashMap.containsKey(object4.m_nameString)) {
                    object = (ArrayList)hashMap.get(object4.m_nameString);
                    if (object4.m_condition == LiteralInstruction.booleanTrueLiteral()) {
                        hashMap2.put(object4.m_nameString, LiteralInstruction.booleanTrueLiteral());
                    } else if (hashMap2.get(object4.m_nameString) != LiteralInstruction.booleanTrueLiteral()) {
                        hashMap2.put(object4.m_nameString, new OrInstruction((Instruction)hashMap2.get(object4.m_nameString), object4.m_condition));
                    }
                } else {
                    object = new ArrayList();
                    hashMap.put(object4.m_nameString, object);
                    linkedList.add(object4.m_nameString);
                    hashMap2.put(object4.m_nameString, object4.m_condition);
                }
            } else {
                if (!bl) {
                    return null;
                }
                return null;
            }
            ((ArrayList)object).add(0, object2);
        }
        for (String string : linkedList) {
            object3 = (ArrayList)hashMap.get(string);
            object2 = new ChooseInstruction.Case[((ArrayList)object3).size()];
            ((ArrayList)object3).toArray((T[])object2);
            object = (Instruction)hashMap2.get(string);
            ChooseInstruction chooseInstruction = new ChooseInstruction((ChooseInstruction.Case[])object2, new StreamInstruction(s_saxEventType));
            linkedList2.add(chooseInstruction);
        }
        return new StreamInstruction(s_saxEventType, linkedList2);
    }

    private static final boolean sameType(Type type, Type type2) {
        if (type == type2) {
            return true;
        }
        if (type instanceof NamedType && type2 instanceof NamedType) {
            return ((NamedType)type).getName().equals(((NamedType)type2).getName());
        }
        return false;
    }

    private static final boolean isSAXEventType(Type type) {
        return type instanceof NamedType && ((NamedType)type).getName().equals("SAXEvent");
    }

    private static final boolean isSAXEventStreamType(Type type) {
        if (!(type instanceof StreamType)) {
            return false;
        }
        Type type2 = ((StreamType)type).getElementType();
        return SerializationHelper.isSAXEventType(type2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final Instruction removeDuplicateAttributes(Instruction instruction, Bool bool, InstructionPointer instructionPointer, ArrayList arrayList, ArrayList arrayList2, Bool bool2, Instruction instruction2) {
        if (bool2.get()) {
            return null;
        }
        if (instruction instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)instruction;
            String string = constructorInstantiationInstruction.getConstructorName();
            if (bool.get()) {
                if (string.equals("addAttrText") || string.equals("addAttrTextNoEscaping") || string.equals("addText") || string.equals("addTextNoEscaping")) {
                    arrayList.add(constructorInstantiationInstruction);
                    return null;
                } else {
                    if (!string.equals("endAttribute")) throw new StaticError("ERR_SYSTEM", "Hit (" + string + ") which is not appropriate inside an attr.");
                    arrayList2.add(new Attribute(instructionPointer.get(), (ArrayList)arrayList.clone(), instruction2.cloneWithoutTypeInformation()));
                    instructionPointer.setNull();
                    arrayList.clear();
                    bool.set(false);
                }
                return null;
            } else if (string.equals("beginAttribute")) {
                bool.set(true);
                instructionPointer.set(constructorInstantiationInstruction.getOperands()[0]);
                arrayList.clear();
                return null;
            } else {
                if (string.equals("beginAttributeNS")) {
                    bool2.set(true);
                    return null;
                }
                if (string.equals("beginAttributeHTML")) {
                    Attribute attribute = new Attribute(constructorInstantiationInstruction.getOperands()[0], new ArrayList(), instruction2);
                    attribute.setSpecial();
                    arrayList2.add(attribute);
                    return null;
                } else {
                    if (string.equals("addAttrText")) throw new StaticError("ERR_SYSTEM", "Hit (" + string + ") while not in attr");
                    if (string.equals("addAttrTextNoEscaping")) throw new StaticError("ERR_SYSTEM", "Hit (" + string + ") while not in attr");
                    if (string.equals("endAttribute")) {
                        throw new StaticError("ERR_SYSTEM", "Hit (" + string + ") while not in attr");
                    }
                    if (string.equals("addText") || string.equals("addTextNoEscaping") || string.equals("beginElementNS") || string.equals("beginElement") || string.equals("addComment")) {
                        bool2.set(true);
                        return null;
                    }
                    bool2.set(true);
                    return null;
                }
            }
        }
        if (instruction instanceof CoerceInstruction || instruction instanceof AssertTypeInstruction) {
            Instruction instruction3;
            Type type;
            Object object;
            if (instruction instanceof CoerceInstruction) {
                object = (CoerceInstruction)instruction;
                type = ((CoerceInstruction)object).getType();
                instruction3 = ((UnaryPrimopInstruction)object).getOperand();
            } else {
                object = (AssertTypeInstruction)instruction;
                type = ((AssertTypeInstruction)object).getType();
                instruction3 = ((UnaryPrimopInstruction)object).getOperand();
            }
            if (type.equals(CharType.s_charType.getStreamType())) {
                bool2.set(true);
                return null;
            }
            if (!SerializationHelper.isSAXEventStreamType(type) && !(type instanceof TypeVariable)) {
                throw new StaticError("ERR_SYSTEM", "Should never happen:  attributes is a stream of bad type");
            }
            if (instruction3 instanceof StreamInstruction) {
                object = ((StreamInstruction)instruction3).getElementType();
                if (object.equals(CharType.s_charType)) {
                    bool2.set(true);
                    return null;
                }
                if (!SerializationHelper.isSAXEventType((Type)object)) throw new StaticError("ERR_SYSTEM", "Should never happen: attibutes is of a stream of unexpected type");
                Instruction instruction4 = SerializationHelper.removeDuplicateAttributes(instruction3, bool, instructionPointer, arrayList, arrayList2, bool2, instruction2);
                return null == instruction4 ? instruction3 : instruction4;
            }
            object = SerializationHelper.removeDuplicateAttributes(instruction3, bool, instructionPointer, arrayList, arrayList2, bool2, instruction2);
            if (null == object) {
                return null;
            }
            Instruction instruction5 = instruction.cloneWithoutTypeInformation();
            instruction5.setChildInstruction(0, (Instruction)object);
            return instruction5;
        }
        if (instruction instanceof ModuleFunctionCallInstruction) {
            ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction;
            if (!moduleFunctionCallInstruction.getModule().equals("xslt1")) return null;
            if (moduleFunctionCallInstruction.getFunction().startsWith("start-tag-event")) {
                if (bool.get()) {
                    throw new StaticError("ERR_SYSTEM", "Hit start tag while in an attribute.");
                }
                bool2.set(true);
                return null;
            }
            if (moduleFunctionCallInstruction.getFunction().equals("modifySpecialAttributeForElement")) {
                if (bool.get()) {
                    throw new StaticError("ERR_SYSTEM", "Hit new attribute while in an old attribute.");
                }
                ArrayList<Instruction> arrayList3 = new ArrayList<Instruction>();
                arrayList3.add(moduleFunctionCallInstruction.getParameters()[2]);
                arrayList2.add(new Attribute(moduleFunctionCallInstruction.getParameters()[1], Attribute.getUnknownValue(), instruction2.cloneWithoutTypeInformation()));
                return instruction.cloneWithoutTypeInformation();
            }
            if (moduleFunctionCallInstruction.getFunction().equals("xsl-copy")) {
                if (!bool.get()) return SerializationHelper.removeDuplicateAttributes(moduleFunctionCallInstruction.getParameters()[1], bool, instructionPointer, arrayList, arrayList2, bool2, instruction2);
                throw new StaticError("ERR_SYSTEM", "Hit new attribute while in an old attribute.");
            }
            if (moduleFunctionCallInstruction.getFunction().equals("fix-html-special-attributes")) {
                return instruction.cloneWithoutTypeInformation();
            }
            if (!moduleFunctionCallInstruction.getFunction().equals("resolve-namespaces")) throw new StaticError("ERR_SYSTEM", "oops 1 - code not written yet: " + moduleFunctionCallInstruction.getFunction());
            return null;
        }
        if (instruction instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
            if (functionCallInstruction.getFunction().indexOf("attribset-xsltc") > 0) {
                if (bool.get()) {
                    throw new StaticError("ERR_SYSTEM", "Hit new attribute while in an old attribute.");
                }
                arrayList2.add(new Attribute(functionCallInstruction.getParameters()[1], Attribute.getUnknownValue(), instruction2.cloneWithoutTypeInformation()));
                return instruction.cloneWithoutTypeInformation();
            }
            bool2.set(true);
            arrayList2.add(new Attribute((Instruction)null, Attribute.getUnknownValue(), null));
            return null;
        }
        if (instruction instanceof ChooseInstruction) {
            Instruction instruction6;
            void var14_40;
            Instruction instruction7;
            Object object;
            ArrayList arrayList4;
            Object object2;
            Object object3;
            int n;
            ChooseInstruction chooseInstruction = (ChooseInstruction)instruction;
            ChooseInstruction chooseInstruction2 = (ChooseInstruction)chooseInstruction.cloneWithoutTypeInformation();
            boolean bl = false;
            Bool bool3 = new Bool(bool.get());
            InstructionPointer instructionPointer2 = new InstructionPointer(instructionPointer.get());
            ArrayList arrayList5 = (ArrayList)arrayList.clone();
            Bool bool4 = new Bool(bool2.get());
            LiteralInstruction literalInstruction = LiteralInstruction.booleanFalseLiteral();
            Instruction instruction8 = chooseInstruction.getDefaultHandler();
            ChooseCaseData[] chooseCaseDataArray = new ChooseCaseData[chooseInstruction.m_cases.length + (null == instruction8 ? 0 : 1)];
            for (n = 0; n < chooseInstruction.m_cases.length; ++n) {
                object3 = new Bool(bool3.get());
                object2 = new InstructionPointer(instructionPointer2.get());
                arrayList4 = (ArrayList)arrayList5.clone();
                object = new ArrayList();
                Bool bool5 = new Bool(bool4.get());
                chooseCaseDataArray[n] = new ChooseCaseData();
                chooseCaseDataArray[n].setCondition(new AndInstruction(instruction2.cloneWithoutTypeInformation(), chooseInstruction.m_cases[n].getTest()));
                instruction7 = chooseCaseDataArray[n].getCondition();
                OrInstruction orInstruction = new OrInstruction((Instruction)var14_40, chooseInstruction.m_cases[n].getTest());
                instruction6 = SerializationHelper.removeDuplicateAttributes(chooseInstruction.m_cases[n].getHandler(), (Bool)object3, (InstructionPointer)object2, arrayList4, arrayList2, bool5, instruction7);
                if (null != instruction6) {
                    bl = true;
                }
                chooseCaseDataArray[n].setAllDone(bool5);
                chooseCaseDataArray[n].setAttrs((ArrayList)object);
                chooseInstruction2.m_cases[n].setHandler(null == instruction6 ? chooseInstruction.m_cases[n].getHandler() : instruction6);
            }
            NotInstruction notInstruction = new NotInstruction((Instruction)var14_40);
            if (instruction8 != null) {
                Bool bool6 = new Bool(bool3.get());
                object3 = new InstructionPointer(instructionPointer2.get());
                object2 = (ArrayList)arrayList5.clone();
                arrayList4 = new ArrayList();
                object = new Bool(bool4.get());
                int n2 = chooseInstruction.m_cases.length;
                chooseCaseDataArray[n2] = new ChooseCaseData();
                chooseCaseDataArray[n2].setCondition(new AndInstruction(instruction2.cloneWithoutTypeInformation(), notInstruction));
                instruction7 = chooseCaseDataArray[n2].getCondition();
                instruction6 = SerializationHelper.removeDuplicateAttributes(instruction8, bool6, (InstructionPointer)object3, (ArrayList)object2, arrayList2, (Bool)object, instruction7);
                if (null != instruction6) {
                    bl = true;
                }
                chooseCaseDataArray[n2].setAllDone((Bool)object);
                chooseCaseDataArray[n2].setAttrs(arrayList4);
                chooseInstruction2.setDefaultHandler(null == instruction6 ? instruction8 : instruction6);
            }
            if (chooseCaseDataArray.length == 0) {
                if (!bl) return null;
                ChooseInstruction chooseInstruction3 = chooseInstruction2;
                return chooseInstruction3;
            }
            n = 1;
            for (int i = 0; i < chooseCaseDataArray.length; ++i) {
                if (chooseCaseDataArray[i].getAllDone().get()) continue;
                n = 0;
            }
            bool2.set(n != 0);
            if (!bl) return null;
            ChooseInstruction chooseInstruction4 = chooseInstruction2;
            return chooseInstruction4;
        }
        if (instruction instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            if (!SerializationHelper.sameType(streamInstruction.getElementType(), s_saxEventType)) {
                throw new StaticError("ERR_SYSTEM", "Should never happen:  attributes is a stream of bad type");
            }
            ArrayList<Instruction> arrayList6 = new ArrayList<Instruction>();
            boolean bl = false;
            int n = streamInstruction.getChildInstructionCount();
            for (int i = 0; i < n; ++i) {
                void var14_44;
                Instruction instruction9 = streamInstruction.getChildInstruction(i);
                Instruction instruction10 = SerializationHelper.removeDuplicateAttributes(instruction9, bool, instructionPointer, arrayList, arrayList2, bool2, instruction2);
                if (null != instruction10) {
                    bl = true;
                }
                if (!bool2.get()) continue;
                if (!bl) {
                    return null;
                }
                arrayList6.add(null == instruction10 ? instruction9 : instruction10);
                int n3 = i + 1;
                while (var14_44 < n) {
                    arrayList6.add(streamInstruction.getChildInstruction((int)var14_44));
                    ++var14_44;
                }
                return new StreamInstruction(s_saxEventType, arrayList6);
            }
            if (!bool.get()) return new StreamInstruction(s_saxEventType);
            throw new StaticError("ERR_SYSTEM", "Finished data in an attr");
        }
        if (instruction instanceof LetInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction;
            if (letInstruction.getVariable().equals("__valueText__")) {
                System.out.println("here");
            }
            ArrayList<Instruction> arrayList7 = new ArrayList<Instruction>();
            boolean bl = false;
            Instruction instruction11 = letInstruction.getBody();
            Instruction instruction12 = SerializationHelper.removeDuplicateAttributes(instruction11, bool, instructionPointer, arrayList, arrayList2, bool2, instruction2);
            if (null != instruction12) {
                bl = true;
            }
            if (!bl) {
                return null;
            }
            arrayList7.add(null == instruction12 ? instruction11 : instruction12);
            LetInstruction letInstruction2 = (LetInstruction)letInstruction.cloneWithoutTypeInformation();
            letInstruction2.setBody(new StreamInstruction(s_saxEventType, arrayList7));
            return letInstruction2;
        }
        if (instruction instanceof TypeMatchInstruction) {
            bool2.set(true);
            arrayList2.add(new Attribute((Instruction)null, Attribute.getUnknownValue(), null));
            return null;
        }
        bool2.set(true);
        return null;
    }

    private static final Instruction modifyForHtml(Instruction instruction, String string, Instruction instruction2, boolean bl) {
        Object object;
        ArrayList arrayList = new ArrayList();
        Instruction instruction3 = SerializationHelper.removeDuplicateAttributes(instruction, new Bool(false), new InstructionPointer(), new ArrayList(), arrayList, new Bool(false), LiteralInstruction.booleanTrueLiteral());
        if (null == instruction3) {
            return instruction;
        }
        boolean bl2 = SerializationHelper.isAllUniqueNames(arrayList);
        if (!bl2) {
            object = SerializationHelper.defineAttrs(arrayList, false);
            if (null == object) {
                s_guard_count[0] = s_guard_count[0] + 1;
                instruction = new ModuleFunctionCallInstruction("xslt1", "attr-serializer-guard", new Instruction[]{instruction});
            } else {
                instruction = new StreamInstruction(s_saxEventType, new Instruction[]{object, instruction3});
            }
        }
        if (null != string) {
            if (!SerializationHelper.isSpecialElementForAttributes(string, bl)) {
                return instruction;
            }
            Object[] objectArray = SerializationHelper.getSpecialAttributesForElement(string, bl);
            object = arrayList.iterator();
            boolean bl3 = true;
            while (object.hasNext()) {
                Attribute attribute = (Attribute)object.next();
                String string2 = attribute.m_nameString;
                if (null == string2) {
                    bl3 = false;
                    continue;
                }
                if (Arrays.binarySearch(objectArray, string2.toLowerCase()) < 0) continue;
                bl3 = false;
            }
            if (bl3) {
                return instruction;
            }
        }
        return instruction;
    }

    public static final Instruction modifyForHtml(Instruction instruction, Instruction instruction2, boolean bl) {
        return SerializationHelper.modifyForHtml(instruction, null, instruction2, bl);
    }

    private static final synchronized void initialize_special_elements_data() {
        if (null != specialElementAttributeMap) {
            return;
        }
        specialElementAttributeMap = new HashMap();
        specialElementAttributeMap.put("area", new String[]{"nohref"});
        specialElementAttributeMap.put("button", new String[]{"disabled"});
        specialElementAttributeMap.put("dir", new String[]{"compact"});
        specialElementAttributeMap.put("dl", new String[]{"compact"});
        specialElementAttributeMap.put("frame", new String[]{"noresize"});
        specialElementAttributeMap.put("hr", new String[]{"noshade"});
        specialElementAttributeMap.put("img", new String[]{"ismap"});
        specialElementAttributeMap.put("input", new String[]{"checked", "disabled", "ismap", "readonly"});
        specialElementAttributeMap.put("menu", new String[]{"compact"});
        specialElementAttributeMap.put("object", new String[]{"declare"});
        specialElementAttributeMap.put("ol", new String[]{"compact"});
        specialElementAttributeMap.put("optgroup", new String[]{"disabled"});
        specialElementAttributeMap.put("option", new String[]{"selected", "disabled"});
        specialElementAttributeMap.put("script", new String[]{"defer"});
        specialElementAttributeMap.put("select", new String[]{"disabled", "multiple"});
        specialElementAttributeMap.put("td", new String[]{"nowrap"});
        specialElementAttributeMap.put("textarea", new String[]{"disabled", "readonly"});
        specialElementAttributeMap.put("th", new String[]{"nowrap"});
        specialElementAttributeMap.put("ul", new String[]{"compact"});
    }

    private static final boolean isSpecialElementForAttributes(String string, boolean bl) {
        if (!bl) {
            return false;
        }
        String string2 = string.toLowerCase();
        return Arrays.binarySearch(s_specialElementsArray, string2) >= 0;
    }

    public static final boolean isSpecialAttribute(String string) {
        String string2 = string.toLowerCase();
        return Arrays.binarySearch(s_specialAttributesArray, string2) >= 0;
    }

    public static final String[] getSpecialAttributesForElement(String string, boolean bl) {
        if (!bl) {
            return new String[0];
        }
        SerializationHelper.initialize_special_elements_data();
        String[] stringArray = (String[])specialElementAttributeMap.get(string.toLowerCase());
        if (null == stringArray) {
            return new String[0];
        }
        String[] stringArray2 = new String[stringArray.length];
        stringArray2 = (String[])stringArray.clone();
        return stringArray2;
    }

    public static final Instruction modifyForHtml(Instruction instruction, String string, boolean bl) {
        return SerializationHelper.modifyForHtml(instruction, string, null, bl);
    }

    public static void addStartTagForHtml(boolean bl, TranslatorContext translatorContext, Instruction instruction, String string, boolean bl2) {
        if (bl && bl2) {
            if (string != null) {
                translatorContext.addSAXEvents(new ModuleFunctionCallInstruction("xslt1", "start-tag-event-trace", new Instruction[]{instruction, StreamInstruction.charStreamLiteral(string)}));
            } else {
                translatorContext.addSAXEvents(new ModuleFunctionCallInstruction("xslt1", "start-tag-event", new Instruction[]{instruction}));
            }
        } else {
            if (string != null) {
                translatorContext.addSAXEvents(new ConstructorInstantiationInstruction("processingInstruction", new Instruction[]{StreamInstruction.charStreamLiteral("xylem_trace_source"), StreamInstruction.charStreamLiteral(string)}));
            }
            translatorContext.addSAXEvents(new ConstructorInstantiationInstruction("beginElement", new Instruction[]{instruction}));
        }
    }

    public static Instruction getEndTagForHtml(boolean bl, Instruction instruction, boolean bl2) {
        if (bl) {
            return new ModuleFunctionCallInstruction("xslt1", "end-tag-event", new Instruction[]{instruction, LiteralInstruction.booleanLiteral(bl2)});
        }
        return new ConstructorInstantiationInstruction("endElement", new Instruction[]{instruction});
    }

    private static class ChooseCaseData {
        Instruction m_condition = null;
        Bool m_allDone = null;
        ArrayList m_attrs = null;

        private ChooseCaseData() {
        }

        Instruction getCondition() {
            return this.m_condition;
        }

        void setCondition(Instruction instruction) {
            this.m_condition = instruction;
        }

        Bool getAllDone() {
            return this.m_allDone;
        }

        void setAllDone(Bool bool) {
            this.m_allDone = bool;
        }

        ArrayList getAttrs() {
            return this.m_attrs;
        }

        void setAttrs(ArrayList arrayList) {
            this.m_attrs = arrayList;
        }

        public String toString() {
            return "ChooseCaseData (" + this.m_condition + " " + this.m_allDone + " " + this.m_attrs + ")";
        }
    }

    private static class InstructionPointer {
        private Instruction m_instr = null;

        public InstructionPointer() {
            this.m_instr = null;
        }

        public InstructionPointer(Instruction instruction) {
            this.m_instr = instruction;
        }

        public Instruction get() {
            return this.m_instr;
        }

        public void set(Instruction instruction) {
            this.m_instr = instruction;
        }

        public void set(InstructionPointer instructionPointer) {
            this.m_instr = instructionPointer.get();
        }

        public void setNull() {
            this.m_instr = null;
        }

        public String toString() {
            return null != this.m_instr ? this.m_instr.toString() : "null";
        }
    }

    private static class Bool {
        private boolean m_bool = false;

        public Bool(boolean bl) {
            this.m_bool = bl;
        }

        public boolean get() {
            return this.m_bool;
        }

        public void set(boolean bl) {
            this.m_bool = bl;
        }

        public void set(Bool bool) {
            this.m_bool = bool.get();
        }

        public String toString() {
            return this.m_bool ? "true" : "false";
        }
    }

    private static class Attribute {
        String m_nameString;
        Instruction m_nameInstr;
        boolean m_isNameAString;
        String m_valueString;
        ArrayList m_valueArray;
        boolean m_isValueAString;
        Instruction m_condition;
        boolean m_isSpecial = false;

        public static ArrayList getUnknownValue() {
            ArrayList<ModuleFunctionCallInstruction> arrayList = new ArrayList<ModuleFunctionCallInstruction>();
            arrayList.add(new ModuleFunctionCallInstruction("blah", "foo", new Instruction[0]));
            return arrayList;
        }

        public boolean isUnknownValue() {
            ModuleFunctionCallInstruction moduleFunctionCallInstruction;
            return !this.m_isValueAString && 1 == this.m_valueArray.size() && this.m_valueArray.get(0) instanceof ModuleFunctionCallInstruction && (moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)this.m_valueArray.get(0)).getModule().equals("blah") && moduleFunctionCallInstruction.getFunction().equals("foo");
        }

        public String toString() {
            String string = "(Attribute ";
            string = string + (this.m_isNameAString ? this.m_nameString : (null == this.m_nameInstr ? "null" : this.m_nameInstr.toString()));
            string = string + " ";
            string = string + (this.m_isValueAString ? this.m_valueString : this.m_valueArray.toString());
            string = string + " (condition: " + (null == this.m_condition ? "null" : this.m_condition.toString()) + ")";
            string = string + (this.m_isSpecial ? " IS-SPECIAL" : " IS-NOT-SPECIAL");
            string = string + ")";
            return string;
        }

        public Attribute(String string, ArrayList arrayList, Instruction instruction) {
            this.m_nameString = string;
            this.m_isNameAString = true;
            this.setValue(arrayList);
            this.m_condition = instruction;
        }

        public Attribute(Instruction instruction, ArrayList arrayList, Instruction instruction2) {
            this.setName(instruction);
            this.setValue(arrayList);
            this.m_condition = instruction2;
        }

        public static String getStringFromInstruction(Instruction instruction) {
            if (instruction instanceof CoerceInstruction && ((CoerceInstruction)instruction).getType().equals(CharType.s_charType.getStreamType())) {
                return Attribute.getStringFromInstruction(((CoerceInstruction)instruction).getOperand());
            }
            if (instruction instanceof LetInstruction) {
                Instruction instruction2 = ((LetInstruction)instruction).getBody();
                if (instruction2 instanceof StreamInstruction) {
                    return ((StreamInstruction)instruction2).getStringContent();
                }
                return null;
            }
            String string = instruction instanceof StreamInstruction ? ((StreamInstruction)instruction).getStringContent() : null;
            return string;
        }

        private void setName(Instruction instruction) {
            String string = Attribute.getStringFromInstruction(instruction);
            if (null != string) {
                this.m_nameString = string;
                this.m_isNameAString = true;
            } else {
                this.m_nameInstr = instruction;
                this.m_isNameAString = false;
            }
        }

        private void setValue(ArrayList arrayList) {
            String string = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                Instruction instruction = (Instruction)arrayList.get(i);
                if (instruction instanceof StreamInstruction) {
                    String string2 = ((StreamInstruction)instruction).getStringContent();
                    if (null == string || null == string2) {
                        string = null;
                        continue;
                    }
                    string = string + string2;
                    continue;
                }
                string = null;
            }
            if (null != string) {
                this.m_valueString = string;
                this.m_isValueAString = true;
            } else {
                this.m_valueArray = arrayList;
                this.m_isValueAString = false;
            }
        }

        public void setSpecial() {
            this.m_isSpecial = true;
        }

        public boolean isString() {
            return this.m_isNameAString;
        }

        public boolean isValueString() {
            return this.m_isValueAString;
        }

        public Instruction getNameInstruction() {
            if (this.m_isNameAString) {
                return new StreamInstruction(this.m_nameString);
            }
            return this.m_nameInstr;
        }

        public Instruction getValueInstruction() {
            if (this.m_isValueAString) {
                return new StreamInstruction(this.m_valueString);
            }
            return new StreamInstruction(s_saxEventType, this.m_valueArray);
        }

        public Instruction getBeginAttribute() {
            return Attribute.startAttribute(this.getNameInstruction());
        }

        public Instruction getBeginAttributeHTML() {
            return Attribute.startAttributeHTML(this.getNameInstruction());
        }

        public Instruction getAttrText() {
            return this.getValueInstruction();
        }

        public Instruction getEndAttribute() {
            return Attribute.endAttribute();
        }

        public boolean isSpecial() {
            return this.m_isSpecial;
        }

        public Instruction getCondition() {
            return this.m_condition;
        }

        private static Instruction startAttribute(Instruction instruction) {
            return new ConstructorInstantiationInstruction("beginAttribute", new Instruction[]{instruction});
        }

        private static Instruction startAttributeHTML(Instruction instruction) {
            return new ConstructorInstantiationInstruction("beginAttributeHTML", new Instruction[]{instruction});
        }

        private static Instruction endAttribute() {
            return new ConstructorInstantiationInstruction("endAttribute", new Instruction[0]);
        }

        public void addAtBegining(LinkedList linkedList) {
            if (!this.m_isSpecial) {
                linkedList.add(0, Attribute.endAttribute());
                Iterator iterator = this.m_valueArray.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Instruction instruction = (Instruction)iterator.next();
                    linkedList.add(n, instruction);
                    ++n;
                }
            }
            if (this.m_isNameAString) {
                linkedList.add(0, Attribute.startAttribute(new StreamInstruction(this.m_nameString)));
            } else {
                linkedList.add(0, Attribute.startAttribute(this.m_nameInstr));
            }
        }

        public Instruction getHandler() {
            return new StreamInstruction(s_saxEventType, this.m_valueArray);
        }
    }
}

