/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.unicode.normalize;

import com.ibm.icu.text.Normalizer;
import com.ibm.xtq.xml.res.XMLMessages;

public final class XNormalizer {
    public static final String DEFAULT_FORM = "NFC";
    public static final String EMPTY_STRING = "";

    public static final String normalizeUnicode(String string) {
        return string.equals(EMPTY_STRING) ? EMPTY_STRING : XNormalizer.normalizeUnicode(string, XNormalizer.getNormalizerMode(DEFAULT_FORM));
    }

    public static final String normalizeUnicode(String string, String string2) {
        return string.equals(EMPTY_STRING) ? EMPTY_STRING : XNormalizer.normalizeUnicode(string, XNormalizer.getNormalizerMode(string2));
    }

    public static synchronized boolean alreadyNormalizedUnicode(String string) {
        return Normalizer.quickCheck((String)string, (Normalizer.Mode)XNormalizer.getNormalizerMode(DEFAULT_FORM)).equals(Normalizer.YES);
    }

    public static synchronized int normalizeUnicode(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        int n5 = Normalizer.normalize((char[])cArray, (int)n, (int)n2, (char[])cArray2, (int)n3, (int)n4, (Normalizer.Mode)XNormalizer.getNormalizerMode(DEFAULT_FORM), (int)0);
        return n5;
    }

    public static synchronized boolean alreadyNormalizedUnicode(char[] cArray, int n, int n2) {
        return Normalizer.quickCheck((char[])cArray, (int)n, (int)n2, (Normalizer.Mode)XNormalizer.getNormalizerMode(DEFAULT_FORM), (int)0).equals(Normalizer.YES);
    }

    private static final synchronized String normalizeUnicode(String string, Normalizer.Mode mode) {
        if (Normalizer.quickCheck((String)string, (Normalizer.Mode)mode).equals(Normalizer.YES)) {
            return string;
        }
        return Normalizer.normalize((String)string, (Normalizer.Mode)mode);
    }

    private static final Normalizer.Mode getNormalizerMode(String string) {
        String string2 = string.trim().toUpperCase();
        try {
            if (string2.equals(DEFAULT_FORM)) {
                return Normalizer.NFC;
            }
            if (string2.equals("NFD")) {
                return Normalizer.NFD;
            }
            if (string2.equals("NFKC")) {
                return Normalizer.NFKC;
            }
            if (string2.equals("NFKD")) {
                return Normalizer.NFKD;
            }
            if (string2.equals("FCD")) {
                return Normalizer.FCD;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new NoClassDefFoundError(XMLMessages.createXMLMessage("ER_NEEDS_ICU", new Object[]{"normalizeUnicode"}));
        }
        throw new RuntimeException(XMLMessages.createXMLMessage("ER_UNSUPPORTED_NORMALIZATION_FORM", new Object[]{string}));
    }
}

