/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.profile;

import java.util.Properties;
import java.util.function.UnaryOperator;
import org.keycloak.common.Profile;
import org.keycloak.common.profile.ProfileConfigResolver;
import org.keycloak.common.profile.ProfileException;

public class PropertiesProfileConfigResolver
implements ProfileConfigResolver {
    private UnaryOperator<String> getter;

    public PropertiesProfileConfigResolver(Properties properties) {
        this(properties::getProperty);
    }

    public PropertiesProfileConfigResolver(UnaryOperator<String> getter) {
        this.getter = getter;
    }

    @Override
    public Profile.ProfileName getProfileName() {
        String profile = (String)this.getter.apply("keycloak.profile");
        return profile != null ? Profile.ProfileName.valueOf(profile.toUpperCase()) : null;
    }

    @Override
    public ProfileConfigResolver.FeatureConfig getFeatureConfig(String feature) {
        String key = PropertiesProfileConfigResolver.getPropertyKey(feature);
        String config = (String)this.getter.apply(key);
        if (config != null) {
            switch (config) {
                case "enabled": {
                    return ProfileConfigResolver.FeatureConfig.ENABLED;
                }
                case "disabled": {
                    return ProfileConfigResolver.FeatureConfig.DISABLED;
                }
            }
            throw new ProfileException("Invalid config value '" + config + "' for feature key " + key);
        }
        return ProfileConfigResolver.FeatureConfig.UNCONFIGURED;
    }

    public static String getPropertyKey(Profile.Feature feature) {
        return PropertiesProfileConfigResolver.getPropertyKey(feature.getKey());
    }

    public static String getPropertyKey(String feature) {
        return "keycloak.profile.feature." + feature.replaceAll("-", "_");
    }
}

