/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.Collection;
import org.jboss.resteasy.core.StringParameterInjector;

public abstract class MultiValuedAbstractParamConverter {
    protected StringParameterInjector stringParameterInjector;
    protected ParamConverter paramConverter;
    protected RuntimeDelegate.HeaderDelegate headerDelegate;
    protected String separator;

    public MultiValuedAbstractParamConverter(StringParameterInjector stringParameterInjector, String separator) {
        this.stringParameterInjector = stringParameterInjector;
        this.paramConverter = stringParameterInjector.getParamConverter();
        this.headerDelegate = stringParameterInjector.getHeaderDelegate();
        this.separator = separator;
    }

    protected String stringify(Collection<?> value) {
        char separatorChar = this.getSeparatorChar();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object v : value) {
            if (first) {
                first = false;
            } else {
                sb.append(separatorChar);
            }
            if (v instanceof String) {
                sb.append(v);
                continue;
            }
            if (this.paramConverter != null) {
                sb.append(this.paramConverter.toString(v));
                continue;
            }
            if (this.headerDelegate != null) {
                sb.append(this.headerDelegate.toString(v));
                continue;
            }
            sb.append(v.toString());
        }
        return sb.toString();
    }

    protected char getSeparatorChar() {
        if (this.separator.charAt(0) == '[') {
            return this.separator.charAt(1);
        }
        return this.separator.charAt(0);
    }
}

