/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Objects;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.reactor.MonoKt;
import kotlinx.coroutines.reactor.ReactorFlowKt;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class CoroutinesUtils {
    private static final ReflectionUtils.MethodFilter boxImplFilter = method -> method.isSynthetic() && Modifier.isStatic(method.getModifiers()) && method.getName().equals("box-impl");

    public static <T> Mono<T> deferredToMono(Deferred<T> source) {
        return MonoKt.mono((CoroutineContext)Dispatchers.getUnconfined(), (scope, continuation) -> source.await(continuation));
    }

    public static <T> Deferred<T> monoToDeferred(Mono<T> source) {
        return BuildersKt.async((CoroutineScope)GlobalScope.INSTANCE, (CoroutineContext)Dispatchers.getUnconfined(), (CoroutineStart)CoroutineStart.DEFAULT, (scope, continuation) -> MonoKt.awaitSingleOrNull((Mono)source, (Continuation)continuation));
    }

    public static Publisher<?> invokeSuspendingFunction(Method method, Object target, Object ... args) {
        return CoroutinesUtils.invokeSuspendingFunction((CoroutineContext)Dispatchers.getUnconfined(), method, target, args);
    }

    public static Publisher<?> invokeSuspendingFunction(CoroutineContext context, Method method, Object target, Object ... args) {
        Assert.isTrue(KotlinDetector.isSuspendingFunction(method), "'method' must be a suspending function");
        KFunction function = Objects.requireNonNull(ReflectJvmMapping.getKotlinFunction((Method)method));
        if (method.isAccessible() && !KCallablesJvm.isAccessible((KCallable)function)) {
            KCallablesJvm.setAccessible((KCallable)function, (boolean)true);
        }
        Mono mono = MonoKt.mono((CoroutineContext)context, (scope, continuation) -> {
            HashMap<KParameter, Object> argMap = CollectionUtils.newHashMap(args.length + 1);
            int index = 0;
            for (KParameter parameter : function.getParameters()) {
                switch (parameter.getKind()) {
                    case INSTANCE: {
                        argMap.put(parameter, target);
                        break;
                    }
                    case VALUE: 
                    case EXTENSION_RECEIVER: {
                        if (!parameter.isOptional() || args[index] != null) {
                            KClass kClass;
                            KClassifier patt4981$temp = parameter.getType().getClassifier();
                            if (patt4981$temp instanceof KClass && (kClass = (KClass)patt4981$temp).isValue()) {
                                Class javaClass = JvmClassMappingKt.getJavaClass((KClass)kClass);
                                Method[] methods = ReflectionUtils.getUniqueDeclaredMethods(javaClass, boxImplFilter);
                                Assert.state(methods.length == 1, "Unable to find a single box-impl synthetic static method in " + javaClass.getName());
                                argMap.put(parameter, ReflectionUtils.invokeMethod(methods[0], null, args[index]));
                            } else {
                                argMap.put(parameter, args[index]);
                            }
                        }
                        ++index;
                    }
                }
            }
            return KCallables.callSuspendBy((KCallable)function, argMap, (Continuation)continuation);
        }).filter(result -> result != Unit.INSTANCE).onErrorMap(InvocationTargetException.class, InvocationTargetException::getTargetException);
        KClassifier returnType = function.getReturnType().getClassifier();
        if (returnType != null) {
            KClass kClass;
            if (returnType.equals(JvmClassMappingKt.getKotlinClass(Flow.class))) {
                return mono.flatMapMany(CoroutinesUtils::asFlux);
            }
            if (returnType.equals(JvmClassMappingKt.getKotlinClass(Mono.class))) {
                return mono.flatMap(o -> (Mono)o);
            }
            if (returnType instanceof KClass && Publisher.class.isAssignableFrom(JvmClassMappingKt.getJavaClass((KClass)(kClass = (KClass)returnType)))) {
                return mono.flatMapMany(o -> (Publisher)o);
            }
        }
        return mono;
    }

    private static Flux<?> asFlux(Object flow) {
        return ReactorFlowKt.asFlux((Flow)((Flow)flow));
    }
}

