/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.profile;

import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.custos.core.mapper.tenant.AttributeUpdateMetadataMapper;
import org.apache.custos.core.mapper.tenant.StatusUpdateMetadataMapper;
import org.apache.custos.core.mapper.tenant.TenantMapper;
import org.apache.custos.core.model.tenant.TenantStatusUpdateMetadata;
import org.apache.custos.core.repo.tenant.ContactRepository;
import org.apache.custos.core.repo.tenant.RedirectURIRepository;
import org.apache.custos.core.repo.tenant.TenantAttributeUpdateMetadataRepository;
import org.apache.custos.core.repo.tenant.TenantRepository;
import org.apache.custos.core.repo.tenant.TenantStatusUpdateMetadataRepository;
import org.apache.custos.core.tenant.profile.api.GetAllTenantsForUserRequest;
import org.apache.custos.core.tenant.profile.api.GetAllTenantsForUserResponse;
import org.apache.custos.core.tenant.profile.api.GetAllTenantsResponse;
import org.apache.custos.core.tenant.profile.api.GetAttributeUpdateAuditTrailResponse;
import org.apache.custos.core.tenant.profile.api.GetAuditTrailRequest;
import org.apache.custos.core.tenant.profile.api.GetStatusUpdateAuditTrailResponse;
import org.apache.custos.core.tenant.profile.api.GetTenantRequest;
import org.apache.custos.core.tenant.profile.api.GetTenantResponse;
import org.apache.custos.core.tenant.profile.api.GetTenantsRequest;
import org.apache.custos.core.tenant.profile.api.IsTenantExistRequest;
import org.apache.custos.core.tenant.profile.api.IsTenantExistResponse;
import org.apache.custos.core.tenant.profile.api.Tenant;
import org.apache.custos.core.tenant.profile.api.TenantAttributeUpdateMetadata;
import org.apache.custos.core.tenant.profile.api.TenantStatus;
import org.apache.custos.core.tenant.profile.api.UpdateStatusRequest;
import org.apache.custos.core.tenant.profile.api.UpdateStatusResponse;
import org.apache.custos.service.exceptions.AuthenticationException;
import org.apache.custos.service.exceptions.InternalServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TenantProfileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantProfileService.class);
    private final TenantRepository tenantRepository;
    private final TenantStatusUpdateMetadataRepository tenantStatusUpdateMetadataRepository;
    private final TenantAttributeUpdateMetadataRepository tenantAttributeUpdateMetadataRepository;
    private final ContactRepository contactRepository;
    private final RedirectURIRepository redirectURIRepository;

    public TenantProfileService(TenantRepository tenantRepository, TenantStatusUpdateMetadataRepository tenantStatusUpdateMetadataRepository, TenantAttributeUpdateMetadataRepository tenantAttributeUpdateMetadataRepository, ContactRepository contactRepository, RedirectURIRepository redirectURIRepository) {
        this.tenantRepository = tenantRepository;
        this.tenantStatusUpdateMetadataRepository = tenantStatusUpdateMetadataRepository;
        this.tenantAttributeUpdateMetadataRepository = tenantAttributeUpdateMetadataRepository;
        this.contactRepository = contactRepository;
        this.redirectURIRepository = redirectURIRepository;
    }

    public Tenant addTenant(Tenant request) {
        try {
            LOGGER.debug("Add tenant request received for tenant " + TenantMapper.getTenantInfoAsString((Tenant)request));
            org.apache.custos.core.model.tenant.Tenant tenant = TenantMapper.createTenantEntityFromTenant((Tenant)request);
            tenant.setStatus(TenantStatus.REQUESTED.name());
            Set metadataSet = StatusUpdateMetadataMapper.createStatusUpdateMetadataEntity((org.apache.custos.core.model.tenant.Tenant)tenant, (String)tenant.getRequesterEmail());
            tenant.setStatusUpdateMetadata(metadataSet);
            org.apache.custos.core.model.tenant.Tenant savedTenant = (org.apache.custos.core.model.tenant.Tenant)this.tenantRepository.save((Object)tenant);
            return request.toBuilder().setTenantId(savedTenant.getId().longValue()).build();
        }
        catch (Exception ex) {
            String msg = "Exception occurred while adding the tenant";
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Tenant updateTenant(Tenant tenant) {
        try {
            LOGGER.debug("Update tenant request received for tenant " + TenantMapper.getTenantInfoAsString((Tenant)tenant));
            String updatedBy = "Tenant Admin";
            Long tenantId = tenant.getTenantId();
            if (!this.isUpdatable(tenantId)) {
                String msg = "Tenant not exist";
                LOGGER.error(msg);
                throw new AuthenticationException(msg);
            }
            Optional opt = this.tenantRepository.findById((Object)tenantId);
            if (opt.isPresent()) {
                org.apache.custos.core.model.tenant.Tenant exTenant = (org.apache.custos.core.model.tenant.Tenant)opt.get();
                tenant = tenant.toBuilder().setParentTenantId(exTenant.getParentId()).build();
                org.apache.custos.core.model.tenant.Tenant tenantEntity = TenantMapper.createTenantEntityFromTenant((Tenant)tenant);
                tenantEntity.setCreatedAt(exTenant.getCreatedAt());
                Set metadata = AttributeUpdateMetadataMapper.createAttributeUpdateMetadataEntity((org.apache.custos.core.model.tenant.Tenant)exTenant, (org.apache.custos.core.model.tenant.Tenant)tenantEntity, (String)updatedBy);
                tenantEntity.setAttributeUpdateMetadata(metadata);
                this.contactRepository.deleteAllByTenantId(tenantId);
                this.redirectURIRepository.deleteAllByTenantId(tenantId);
                this.tenantRepository.save((Object)tenantEntity);
                return tenant;
            }
            LOGGER.error("No tenant found to update. Tenant Id: {}", (Object)tenantId);
            throw new EntityNotFoundException("No tenant found to update. Tenant Id: " + tenantId);
        }
        catch (Exception ex) {
            String msg = "Exception occurred while updating the tenant";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllTenantsResponse getAllTenants(GetTenantsRequest request) {
        try {
            LOGGER.debug("Get all tenants request received");
            String status = null;
            if (!request.getStatus().equals((Object)TenantStatus.UNKNOWN)) {
                status = request.getStatus().name();
            }
            int offset = request.getOffset();
            int limit = request.getLimit();
            long parentId = request.getParentId();
            String tenantType = request.getType().name();
            String requesterEmail = request.getRequesterEmail();
            List tenants = this.tenantRepository.searchTenants(requesterEmail, status, parentId, limit, offset, tenantType);
            List total_tenants = this.tenantRepository.searchTenants(requesterEmail, status, parentId, -1, -1, tenantType);
            ArrayList<Tenant> tenantList = new ArrayList<Tenant>();
            for (org.apache.custos.core.model.tenant.Tenant tenant : tenants) {
                Tenant t = TenantMapper.createTenantFromTenantEntity((org.apache.custos.core.model.tenant.Tenant)tenant);
                tenantList.add(t);
            }
            return GetAllTenantsResponse.newBuilder().setTotalNumOfTenants(total_tenants.size()).addAllTenant(tenantList).build();
        }
        catch (Exception ex) {
            String msg = "Exception occurred while retrieving tenants";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllTenantsForUserResponse getAllTenantsForUser(GetAllTenantsForUserRequest request) {
        try {
            LOGGER.debug("Get all tenants for user " + request.getRequesterEmail() + " received");
            String username = request.getRequesterEmail();
            List tenants = this.tenantRepository.findByRequesterEmail(username);
            ArrayList<Tenant> tenantList = new ArrayList<Tenant>();
            for (org.apache.custos.core.model.tenant.Tenant tenant : tenants) {
                Tenant t = TenantMapper.createTenantFromTenantEntity((org.apache.custos.core.model.tenant.Tenant)tenant);
                tenantList.add(t);
            }
            return GetAllTenantsForUserResponse.newBuilder().addAllTenant(tenantList).build();
        }
        catch (Exception ex) {
            String msg = "Exception occurred while retrieving tenants";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetTenantResponse getTenant(GetTenantRequest request) {
        try {
            LOGGER.debug("Get tenant with Id " + request.getTenantId() + " received");
            Long id = request.getTenantId();
            Optional tenant = this.tenantRepository.findById((Object)id);
            if (tenant.isPresent()) {
                Tenant t = TenantMapper.createTenantFromTenantEntity((org.apache.custos.core.model.tenant.Tenant)((org.apache.custos.core.model.tenant.Tenant)tenant.get()));
                return GetTenantResponse.newBuilder().setTenant(t).build();
            }
            String msg = "Cannot find the tenant with Id " + request.getTenantId();
            LOGGER.error(msg);
            throw new EntityNotFoundException(msg);
        }
        catch (Exception ex) {
            String msg = "Exception occurred while retrieving tenants";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAttributeUpdateAuditTrailResponse getTenantAttributeUpdateAuditTrail(GetAuditTrailRequest request) {
        try {
            LOGGER.debug("Get tenant attribute update audit trail for " + request.getTenantId());
            Long id = request.getTenantId();
            List tenantList = this.tenantAttributeUpdateMetadataRepository.findAllByTenantId(id);
            ArrayList<TenantAttributeUpdateMetadata> metadata = new ArrayList<TenantAttributeUpdateMetadata>();
            for (org.apache.custos.core.model.tenant.TenantAttributeUpdateMetadata attributeUpdateMetadata : tenantList) {
                TenantAttributeUpdateMetadata updatedMetadata = AttributeUpdateMetadataMapper.createAttributeUpdateMetadataFromEntity((org.apache.custos.core.model.tenant.TenantAttributeUpdateMetadata)attributeUpdateMetadata);
                metadata.add(updatedMetadata);
            }
            return GetAttributeUpdateAuditTrailResponse.newBuilder().addAllMetadata(metadata).build();
        }
        catch (Exception ex) {
            String msg = "Exception occurred while retrieving attribute status update metadata";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetStatusUpdateAuditTrailResponse getTenantStatusUpdateAuditTrail(GetAuditTrailRequest request) {
        try {
            LOGGER.debug("Get tenant attribute update audit trail for " + request.getTenantId());
            Long id = request.getTenantId();
            List tenantList = this.tenantStatusUpdateMetadataRepository.findAllByTenantId(id);
            ArrayList<org.apache.custos.core.tenant.profile.api.TenantStatusUpdateMetadata> metadata = new ArrayList<org.apache.custos.core.tenant.profile.api.TenantStatusUpdateMetadata>();
            for (TenantStatusUpdateMetadata statusUpdateMetadata : tenantList) {
                org.apache.custos.core.tenant.profile.api.TenantStatusUpdateMetadata updatedMetadata = StatusUpdateMetadataMapper.createTenantStatusMetadataFrom((TenantStatusUpdateMetadata)statusUpdateMetadata);
                metadata.add(updatedMetadata);
            }
            return GetStatusUpdateAuditTrailResponse.newBuilder().addAllMetadata(metadata).build();
        }
        catch (Exception ex) {
            String msg = "Exception occurred while retrieving status update metadata";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public IsTenantExistResponse isTenantExist(IsTenantExistRequest request) {
        try {
            LOGGER.debug("Is tenant exist " + request.getTenantId() + " received");
            Long id = request.getTenantId();
            Optional tenant = this.tenantRepository.findById((Object)id);
            return IsTenantExistResponse.newBuilder().setIsExist(tenant.isPresent()).build();
        }
        catch (Exception ex) {
            String msg = "Exception occurred while retrieving tenants";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public UpdateStatusResponse updateTenantStatus(UpdateStatusRequest request) {
        try {
            LOGGER.debug("Update tenant request status received for " + request.getTenantId() + " received");
            long id = request.getTenantId();
            String status = request.getStatus().name();
            String updatedBy = request.getUpdatedBy();
            Optional tenant = this.tenantRepository.findById((Object)id);
            if (tenant.isPresent()) {
                org.apache.custos.core.model.tenant.Tenant t = (org.apache.custos.core.model.tenant.Tenant)tenant.get();
                t.setStatus(status);
                Set metadata = StatusUpdateMetadataMapper.createStatusUpdateMetadataEntity((org.apache.custos.core.model.tenant.Tenant)t, (String)updatedBy);
                t.setStatusUpdateMetadata(metadata);
                this.tenantRepository.save((Object)t);
                return UpdateStatusResponse.newBuilder().setTenantId(id).setStatus(request.getStatus()).build();
            }
            LOGGER.error("Tenant is not found to update the tenant status, tenant Id: {}", (Object)id);
            throw new EntityNotFoundException("Tenant is not found to update the tenant status, tenant Id: {}" + id);
        }
        catch (Exception ex) {
            String msg = "Exception occurred while updating tenant status";
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    private boolean isUpdatable(Long tenantId) {
        Optional opt = this.tenantRepository.findById((Object)tenantId);
        return opt.isPresent();
    }
}

