/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.auth;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.KeyPair;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.custos.core.model.user.Group;
import org.apache.custos.core.model.user.GroupRole;
import org.apache.custos.core.user.profile.api.UserProfile;
import org.apache.custos.core.user.profile.api.UserProfileRequest;
import org.apache.custos.service.auth.KeyService;
import org.apache.custos.service.profile.UserProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenService.class);
    private final KeyService keyService;
    private final UserProfileService userProfileService;
    private final CacheManager cacheManager;

    @Autowired
    public TokenService(KeyService keyService, UserProfileService userProfileService, CacheManager cacheManager) {
        this.keyService = keyService;
        this.userProfileService = userProfileService;
        this.cacheManager = cacheManager;
    }

    public String generateWithCustomClaims(String token, long tenantId) throws Exception {
        KeyPair keyPair = this.keyService.getKeyPair();
        String keyID = this.keyService.getKeyID();
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        JWTClaimsSet oldClaims = signedJWT.getJWTClaimsSet();
        String email = String.valueOf(oldClaims.getClaim("email"));
        HashSet<String> existingScopes = new HashSet<String>(Arrays.asList(((String)oldClaims.getClaim("scope")).split(" ")));
        JWTClaimsSet newClaims = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)email)) {
                UserProfileRequest request = UserProfileRequest.newBuilder().setTenantId(tenantId).setProfile(UserProfile.newBuilder().setUsername(email).build()).build();
                List<Group> groups = this.userProfileService.getGroupsOfUser(request);
                List<String> groupIds = groups.stream().map(Group::getExternalId).toList();
                List<String> scopes = groups.stream().flatMap(group -> group.getGroupRole().stream()).map(GroupRole::getValue).distinct().toList();
                existingScopes.addAll(scopes);
                newClaims = new JWTClaimsSet.Builder(oldClaims).claim("groups", groupIds).claim("scope", (Object)String.join((CharSequence)" ", scopes)).claim("scopes", scopes).claim("iss", (Object)("https://" + tenantId + ".usecustos.org")).build();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while adding custom claims to the token belongs to: {}", (Object)email);
        }
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(keyID).type(JOSEObjectType.JWT).build();
        SignedJWT newSignedJWT = new SignedJWT(header, newClaims != null ? newClaims : oldClaims);
        RSASSASigner signer = new RSASSASigner(keyPair.getPrivate());
        newSignedJWT.sign((JWSSigner)signer);
        this.cacheToken(newClaims.getJWTID(), token);
        return newSignedJWT.serialize();
    }

    public String getKCToken(String customizedToken) throws ParseException {
        Cache.ValueWrapper valueWrapper;
        SignedJWT signedJWT = SignedJWT.parse((String)customizedToken);
        String jwtId = signedJWT.getJWTClaimsSet().getJWTID();
        Cache cache = this.cacheManager.getCache("KCTokenCache");
        if (cache != null && (valueWrapper = cache.get((Object)jwtId)) != null) {
            return (String)valueWrapper.get();
        }
        return null;
    }

    private void cacheToken(String jti, String token) {
        Cache cache = this.cacheManager.getCache("KCTokenCache");
        if (cache != null) {
            cache.put((Object)jti, (Object)token);
        }
    }
}

