/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.configuration;

import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.PropertyChangeListener;
import eu.unicore.util.configuration.PropertyGroupHelper;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.configuration.UpdateableConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class PropertiesHelper
implements Cloneable,
UpdateableConfiguration {
    private Set<String> warned = Collections.synchronizedSet(new HashSet());
    protected Logger log;
    protected Properties properties;
    protected String prefix;
    protected Map<String, PropertyMD> metadata;
    protected List<PropertyChangeListener> genericListeners = new ArrayList<PropertyChangeListener>();
    protected Map<String, List<PropertyChangeListener>> propertyFocusedListeners = new HashMap<String, List<PropertyChangeListener>>();
    protected Set<String> structuredPrefixes = new HashSet<String>();

    public PropertiesHelper(String prefix, Properties properties, Map<String, PropertyMD> propertiesMD, Logger log) throws ConfigurationException {
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
        this.prefix = prefix;
        this.log = log;
        this.metadata = propertiesMD;
        if (this.metadata == null) {
            this.metadata = Collections.emptyMap();
        }
        this.checkConstraints();
        this.findUnknown(properties);
    }

    @Override
    public synchronized void setProperties(Properties properties) throws ConfigurationException {
        this.checkConstraints(properties);
        this.findUnknown(properties);
        Set<String> changed = this.filterChanged(this.propertyFocusedListeners.keySet(), this.properties, properties);
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
        this.notifyGenericListeners();
        for (String changedP : changed) {
            this.notifyFocusedListeners(changedP);
        }
    }

    public synchronized void setProperty(String key, String value) {
        boolean change;
        Properties tmp = new Properties();
        tmp.putAll((Map<?, ?>)this.properties);
        if (value == null) {
            change = tmp.remove(this.prefix + key) != null;
        } else {
            change = !value.equals(this.properties.getProperty(this.prefix + key));
            tmp.setProperty(this.prefix + key, value);
        }
        this.checkConstraints(tmp);
        this.properties = tmp;
        this.warned.remove(key);
        this.notifyGenericListeners();
        if (change) {
            this.notifyFocusedListeners(key);
        }
    }

    private boolean canHaveSubkeys(String key) {
        PropertyMD meta = this.getMetadata(key);
        return meta != null && (meta.canHaveSubkeys() || meta.getType() == PropertyMD.Type.LIST) || meta.getType() == PropertyMD.Type.STRUCTURED_LIST;
    }

    protected Set<String> filterChanged(Set<String> toCheck, Properties orig, Properties updated) {
        HashSet<String> ret = new HashSet<String>();
        for (String p : toCheck) {
            Map<String, String> updatedGroup;
            boolean group = this.canHaveSubkeys(p);
            if (!group) {
                String origVal = orig.getProperty(this.prefix + p);
                String updatedVal = updated.getProperty(this.prefix + p);
                if (origVal == null || updatedVal == null) {
                    if (origVal == updatedVal) continue;
                    ret.add(p);
                    continue;
                }
                if (origVal.equals(updatedVal)) continue;
                ret.add(p);
                continue;
            }
            Map<String, String> origGroup = new PropertyGroupHelper((Map)orig, this.prefix + p).getFilteredMap();
            if (origGroup.equals(updatedGroup = new PropertyGroupHelper((Map)updated, this.prefix + p).getFilteredMap())) continue;
            ret.add(p);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFocusedListeners(String property) {
        List<PropertyChangeListener> list = this.genericListeners;
        synchronized (list) {
            for (String key : this.propertyFocusedListeners.keySet()) {
                if (key.equals(property)) {
                    this.notifyAllWithKey(key, property);
                    continue;
                }
                if (!property.startsWith(key) || !this.canHaveSubkeys(key)) continue;
                this.notifyAllWithKey(key, property);
            }
        }
    }

    protected void notifyAllWithKey(String key, String property) {
        List<PropertyChangeListener> listeners = this.propertyFocusedListeners.get(key);
        for (PropertyChangeListener listener : listeners) {
            listener.propertyChanged(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyGenericListeners() {
        List<PropertyChangeListener> list = this.genericListeners;
        synchronized (list) {
            for (PropertyChangeListener listener : this.genericListeners) {
                listener.propertyChanged(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.genericListeners;
        synchronized (list) {
            if (listener.getInterestingProperties() == null) {
                this.genericListeners.add(listener);
            } else {
                String[] interestingProps;
                for (String prop : interestingProps = listener.getInterestingProperties()) {
                    List<PropertyChangeListener> propListeners = this.propertyFocusedListeners.get(prop);
                    if (propListeners == null) {
                        propListeners = new ArrayList<PropertyChangeListener>();
                        this.propertyFocusedListeners.put(prop, propListeners);
                    }
                    propListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.genericListeners;
        synchronized (list) {
            this.genericListeners.remove(listener);
            for (String key : this.propertyFocusedListeners.keySet()) {
                this.propertyFocusedListeners.get(key).remove(listener);
            }
        }
    }

    protected void checkConstraints(Properties properties) throws ConfigurationException {
        new PropertiesHelper(this.prefix, properties, this.metadata, this.log);
    }

    protected void checkConstraints() throws ConfigurationException {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, PropertyMD> o : this.metadata.entrySet()) {
            PropertyMD meta = o.getValue();
            try {
                this.checkPropertyConstraints(meta, o.getKey());
            }
            catch (ConfigurationException e) {
                builder.append(e.getMessage() + "\n");
            }
        }
        String warns = builder.toString().trim();
        if (warns.length() > 0) {
            throw new ConfigurationException("The following problems were found in the configuration:\n" + warns);
        }
    }

    protected void checkPropertyConstraints(PropertyMD meta, String key) throws ConfigurationException {
        if (meta.isStructuredListEntry() && !key.startsWith(meta.getStructuredListEntryId())) {
            return;
        }
        if (meta.isMandatory() && !this.isSet(key) && meta.getType() != PropertyMD.Type.LIST && meta.getType() != PropertyMD.Type.STRUCTURED_LIST && !meta.canHaveSubkeys()) {
            throw new ConfigurationException("The property " + this.getKeyDescription(key) + " is mandatory");
        }
        String value = this.getValue(key);
        if (value == null && meta.getType() != PropertyMD.Type.LIST && meta.getType() != PropertyMD.Type.STRUCTURED_LIST) {
            return;
        }
        switch (meta.getType()) {
            case PATH: {
                try {
                    new File(value).getCanonicalPath();
                    break;
                }
                catch (IOException e1) {
                    throw new ConfigurationException("The property" + this.getKeyDescription(key) + " must be a filesystem path, but is not: " + e1.getMessage());
                }
            }
            case INT: {
                this.getIntValue(key);
                break;
            }
            case LONG: {
                this.getLongValue(key);
                break;
            }
            case FLOAT: {
                break;
            }
            case BOOLEAN: {
                this.getBooleanValue(key);
                break;
            }
            case ENUM: {
                this.getEnumValue(key, meta.getEnumTypeInstance().getDeclaringClass());
                break;
            }
            case LIST: {
                Set<String> listKeys = this.getSortedStringKeys(this.prefix + key, false);
                if (meta.isMandatory() && listKeys.size() == 0) {
                    throw new ConfigurationException("The property " + this.getKeyDescription(key) + " is mandatory");
                }
                if (!meta.numericalListKeys()) break;
                int l = (this.prefix + key).length();
                for (String k : listKeys) {
                    try {
                        Integer.parseInt(k.substring(l));
                    }
                    catch (NumberFormatException e) {
                        throw new ConfigurationException("For the " + this.prefix + key + " list property only the numerical subkeys are allowed, and " + k + " doesn't end with a numerical value.");
                    }
                }
                break;
            }
            case CLASS: {
                this.getClassValue(key, meta.getBaseClass());
            }
            case STRING: {
                break;
            }
            case STRUCTURED_LIST: {
                this.checkStructuredListConstraints(meta, key);
            }
        }
    }

    private void checkStructuredListConstraints(PropertyMD meta, String key) {
        this.structuredPrefixes.add(key);
        if (meta.numericalListKeys()) {
            Set<String> listKeys2 = this.getSortedStringKeys(this.prefix + key, true);
            int l = (this.prefix + key).length();
            for (String k : listKeys2) {
                k = k.substring(l);
                try {
                    Integer.parseInt(k);
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException("For the " + this.prefix + key + " structurd list property only the numerical subkeys are allowed, and " + k + " isn't a numerical subkey.");
                }
            }
        }
        HashSet<String> mandatoryElements = new HashSet<String>();
        for (Map.Entry<String, PropertyMD> o : this.metadata.entrySet()) {
            PropertyMD m = o.getValue();
            if (!m.isStructuredListEntry() || !key.equals(m.getStructuredListEntryId()) || !m.isMandatory()) continue;
            mandatoryElements.add(o.getKey());
        }
        Set<String> elements = this.getStructuredListKeys(key);
        if (meta.isMandatory() && elements.size() == 0) {
            throw new ConfigurationException("The list " + this.getKeyDescription(key) + " must have elements");
        }
        for (String element : elements) {
            HashSet<String> presentMandatory = new HashSet<String>();
            PropertyGroupHelper helper = new PropertyGroupHelper((Map)this.properties, this.prefix + element);
            Iterator<String> keys = helper.keys();
            while (keys.hasNext()) {
                String entryKey = keys.next();
                PropertyMD eMeta = this.getMetadata(entryKey = entryKey.substring(this.prefix.length()));
                if (eMeta == null) continue;
                String realKey = this.getMetadataKey(entryKey);
                if ((eMeta.canHaveSubkeys() || eMeta.getType() == PropertyMD.Type.LIST) && entryKey.endsWith(realKey)) {
                    throw new ConfigurationException("The entry with key " + this.prefix + entryKey + " is illegal, should have a subkey");
                }
                if (eMeta.canHaveSubkeys() || eMeta.getType() == PropertyMD.Type.LIST) {
                    entryKey = entryKey.substring(0, entryKey.indexOf(realKey)) + realKey;
                }
                this.checkPropertyConstraints(eMeta, entryKey);
                if (!eMeta.isMandatory()) continue;
                presentMandatory.add(realKey);
            }
            if (mandatoryElements.equals(presentMandatory)) continue;
            mandatoryElements.removeAll(presentMandatory);
            throw new ConfigurationException("The following properties must be defined for the list entry with key " + element + ": " + mandatoryElements);
        }
    }

    protected void findUnknown(Properties properties) {
        Set<Object> keys = properties.keySet();
        StringBuilder sb = new StringBuilder();
        for (Object keyO : keys) {
            String noPfxKey;
            String key = (String)keyO;
            if (!key.startsWith(this.prefix) || this.getMetadata(noPfxKey = key.substring(this.prefix.length())) != null) continue;
            boolean done = false;
            while (noPfxKey.contains(".")) {
                PropertyMD md = this.getMetadata(noPfxKey = noPfxKey.substring(0, noPfxKey.lastIndexOf(46)));
                if (md == null) continue;
                if (!md.canHaveSubkeys() && md.getType() != PropertyMD.Type.LIST) {
                    sb.append(" ").append(key);
                }
                done = true;
                break;
            }
            if (done) continue;
            sb.append(" ").append(key);
        }
        if (sb.length() > 0) {
            throw new ConfigurationException("The following properties are not known:" + sb.toString() + ". Remove them or use correct property names if there are mistakes.");
        }
    }

    protected String getMetadataKey(String propertyKey) {
        if (this.metadata.containsKey(propertyKey)) {
            return propertyKey;
        }
        String realKey = propertyKey;
        for (String structuredPrefix : this.structuredPrefixes) {
            if (!propertyKey.startsWith(structuredPrefix)) continue;
            realKey = propertyKey.substring(structuredPrefix.length());
            int dot = realKey.indexOf(46);
            PropertyMD md = this.metadata.get(realKey = realKey.substring(dot + 1));
            if (md == null) break;
            return realKey;
        }
        Set<Map.Entry<String, PropertyMD>> entries = this.metadata.entrySet();
        for (Map.Entry<String, PropertyMD> entry : entries) {
            if (!realKey.startsWith(entry.getKey()) || entry.getValue().getType() != PropertyMD.Type.LIST && !entry.getValue().canHaveSubkeys()) continue;
            return entry.getKey();
        }
        return null;
    }

    protected PropertyMD getMetadata(String key) {
        String realKey = this.getMetadataKey(key);
        return realKey == null ? null : this.metadata.get(realKey);
    }

    public String getKeyDescription(String key) {
        PropertyMD meta = this.getMetadata(key);
        if (meta == null) {
            return this.prefix + key;
        }
        String description = meta.getDescription();
        if (description != null && description.length() > 0) {
            String shortDesc = description.length() < 40 ? description : description.substring(0, 37) + "...";
            return this.prefix + key + " (" + shortDesc + ")";
        }
        return this.prefix + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String name) {
        boolean doLog;
        String val;
        PropertiesHelper propertiesHelper = this;
        synchronized (propertiesHelper) {
            val = this.properties.getProperty(this.prefix + name);
        }
        boolean bl = doLog = !this.warned.contains(name);
        if (val == null) {
            boolean hasDefault;
            PropertyMD meta = this.getMetadata(name);
            boolean bl2 = hasDefault = meta != null ? meta.hasDefault() : false;
            if (hasDefault) {
                String defaultVal = meta.getDefault();
                if (doLog) {
                    this.log.debug("Parameter " + this.getKeyDescription(name) + " value is not set, using default value: " + (defaultVal == null ? "--BY DEFAULT NOT SET--" : defaultVal));
                    this.warned.add(name);
                }
                val = defaultVal;
            }
        } else {
            val = val.trim();
            if (doLog) {
                this.logValue(name, val);
            }
        }
        return val;
    }

    protected Long getLongValueNoCheck(String name) throws ConfigurationException {
        String val = this.getValue(name);
        if (val == null) {
            return null;
        }
        try {
            return Long.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Value " + val + " is not allowed for " + this.getKeyDescription(name) + ", must be an integer number");
        }
    }

    protected Integer getIntValueNoCheck(String name) throws ConfigurationException {
        String val = this.getValue(name);
        if (val == null) {
            return null;
        }
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Value " + val + " is not allowed for " + this.getKeyDescription(name) + ", must be an integer number");
        }
    }

    protected Double getDoubleValueNoCheck(String name) throws ConfigurationException {
        String val = this.getValue(name);
        if (val == null) {
            return null;
        }
        try {
            return Double.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Value " + val + " is not allowed for " + this.getKeyDescription(name) + ", must be a floating point (rational) number");
        }
    }

    protected <T extends Number> T checkBounds(String name, T current) throws ConfigurationException {
        if (current == null) {
            return current;
        }
        PropertyMD meta = this.getMetadata(name);
        if (meta == null) {
            return current;
        }
        if (current instanceof Float || current instanceof Double) {
            if (current.doubleValue() < meta.getMinFloat()) {
                throw new ConfigurationException(this.getKeyDescription(name) + " parameter value " + "is too small, minimum is " + meta.getMin());
            }
            if (current.doubleValue() > meta.getMaxFloat()) {
                throw new ConfigurationException(this.getKeyDescription(name) + " parameter value " + "is too big, maximum is " + meta.getMax());
            }
        } else {
            if (current.longValue() < meta.getMin()) {
                throw new ConfigurationException(this.getKeyDescription(name) + " parameter value " + "is too small, minimum is " + meta.getMin());
            }
            if (current.longValue() > meta.getMax()) {
                throw new ConfigurationException(this.getKeyDescription(name) + " parameter value " + "is too big, maximum is " + meta.getMax());
            }
        }
        return current;
    }

    public Long getLongValue(String name) throws ConfigurationException {
        Long retVal = this.getLongValueNoCheck(name);
        return this.checkBounds(name, retVal);
    }

    public Integer getIntValue(String name) throws ConfigurationException {
        Integer retVal = this.getIntValueNoCheck(name);
        return this.checkBounds(name, retVal);
    }

    public Double getDoubleValue(String name) throws ConfigurationException {
        Double retVal = this.getDoubleValueNoCheck(name);
        return this.checkBounds(name, retVal);
    }

    public Boolean getBooleanValue(String name) throws ConfigurationException {
        String val = this.getValue(name);
        if (val == null) {
            return null;
        }
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes")) {
            return true;
        }
        if (val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no")) {
            return false;
        }
        throw new ConfigurationException("Value " + val + " is not allowed for " + this.getKeyDescription(name) + ", must be one of yes|true|no|false");
    }

    public <T> Class<? extends T> getClassValue(String name, Class<T> desiredBase) throws ConfigurationException {
        String val = this.getValue(name);
        if (val == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(val);
            if (!desiredBase.isAssignableFrom(cls)) {
                throw new ConfigurationException("Value " + val + " is not allowed for " + this.getKeyDescription(name) + ", must be class extending " + desiredBase);
            }
            return cls;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Value " + val + " is not allowed for " + this.getKeyDescription(name) + ", must be a class name");
        }
    }

    public <T extends Enum<T>> T getEnumValue(String name, Class<T> type) throws ConfigurationException {
        String val = this.getValue(name);
        if (val == null) {
            return null;
        }
        Enum[] constants = (Enum[])type.getEnumConstants();
        StringBuilder allowed = new StringBuilder();
        for (Enum label : constants) {
            if (val.equalsIgnoreCase(label.name())) {
                return (T)label;
            }
            allowed.append(label.name() + " ");
        }
        throw new ConfigurationException("Value " + val + " is not allowed for " + this.getKeyDescription(name) + ", must be one of " + allowed);
    }

    public String getFileValueAsString(String name, boolean isDirectory) throws ConfigurationException {
        File f = this.getFileValue(name, isDirectory);
        if (f == null) {
            return null;
        }
        return f.toString();
    }

    public File getFileValue(String name, boolean isDirectory) throws ConfigurationException {
        String val = this.getValue(name);
        if (val == null) {
            return null;
        }
        File f = new File(val);
        if (!f.exists() || !f.canRead()) {
            throw new ConfigurationException("The value of " + this.getKeyDescription(name) + "= '" + val + "', must represent an EXISTING and READABLE filesystem path.");
        }
        if (!f.isDirectory() && isDirectory) {
            throw new ConfigurationException("Value of " + this.getKeyDescription(name) + "= '" + val + "', must be a path of a directory, not a file.");
        }
        if (!f.isFile() && !isDirectory) {
            throw new ConfigurationException("Value of " + this.getKeyDescription(name) + "= '" + val + "', must be a path of an ordinary file.");
        }
        return f;
    }

    public String getSubkeyValue(String key, String subKey) {
        String perServiceKey = key + "." + subKey;
        if (this.isSet(perServiceKey)) {
            return this.getValue(perServiceKey);
        }
        return this.getValue(key);
    }

    public Boolean getSubkeyBooleanValue(String key, String subKey) {
        String perServiceKey = key + "." + subKey;
        if (this.isSet(perServiceKey)) {
            return this.getBooleanValue(perServiceKey);
        }
        return this.getBooleanValue(key);
    }

    public Integer getSubkeyIntValue(String key, String subKey) {
        String perServiceKey = key + "." + subKey;
        if (this.isSet(perServiceKey)) {
            return this.getIntValue(perServiceKey);
        }
        return this.getIntValue(key);
    }

    public Long getSubkeyLongValue(String key, String subKey) {
        String perServiceKey = key + "." + subKey;
        if (this.isSet(perServiceKey)) {
            return this.getLongValue(perServiceKey);
        }
        return this.getLongValue(key);
    }

    public <T extends Enum<T>> T getSubkeyEnumValue(String key, String subKey, Class<T> type) {
        String perServiceKey = key + "." + subKey;
        if (this.isSet(perServiceKey)) {
            return this.getEnumValue(perServiceKey, type);
        }
        return this.getEnumValue(key, type);
    }

    public synchronized List<String> getListOfValues(String prefix2) {
        String base = this.prefix + prefix2;
        PropertyMD meta = this.metadata.get(prefix2);
        boolean numericalKeys = meta == null ? false : meta.numericalListKeys();
        Set<String> keys = numericalKeys ? this.getSortedNumKeys(base, false) : this.getSortedStringKeys(base, false);
        ArrayList<String> ret = new ArrayList<String>();
        for (String keyO : keys) {
            String key = keyO.toString();
            String v = this.properties.getProperty(key);
            if (!this.warned.contains(key)) {
                this.logValue(key.substring(this.prefix.length()), v);
            }
            ret.add(v);
        }
        return ret;
    }

    private synchronized Set<String> getSortedNumKeys(String base, boolean allowListSubKeys) {
        TreeSet<Integer> keys = new TreeSet<Integer>();
        Set<Object> allKeys = this.properties.keySet();
        for (Object keyO : allKeys) {
            String key = (String)keyO;
            if (!key.startsWith(base)) continue;
            String post = key.substring(base.length());
            int dot = post.indexOf(46);
            if (dot != -1 && allowListSubKeys) {
                post = post.substring(0, dot);
            }
            try {
                int i = Integer.parseInt(post);
                keys.add(i);
            }
            catch (NumberFormatException e) {
                this.log.warn("Property list key '" + key + "' should end with integer number, but is ended with '" + post + "'. Ignoring.");
            }
        }
        LinkedHashSet<String> ret = new LinkedHashSet<String>(keys.size());
        for (Integer suffix : keys) {
            ret.add(base + suffix);
        }
        return ret;
    }

    private synchronized Set<String> getSortedStringKeys(String base, boolean allowListSubKeys) {
        TreeSet<String> keys = new TreeSet<String>();
        Set<Object> allKeys = this.properties.keySet();
        for (Object keyO : allKeys) {
            String key = (String)keyO;
            if (!key.startsWith(base)) continue;
            String post = key.substring(base.length());
            int dot = post.indexOf(46);
            if (dot != -1 && allowListSubKeys) {
                post = post.substring(0, dot);
            } else if (dot != -1 && !allowListSubKeys) {
                this.log.warn("Property list key '" + key + "' should not posses a dot: '" + post + "'. Ignoring.");
                continue;
            }
            keys.add(base + post);
        }
        return keys;
    }

    public synchronized Set<String> getStructuredListKeys(String listKey) {
        PropertyMD listMeta = this.metadata.get(listKey);
        if (listMeta == null || listMeta.getType() != PropertyMD.Type.STRUCTURED_LIST) {
            throw new IllegalArgumentException("The " + listKey + " is not a structured list property");
        }
        Set<String> keys = listMeta.numericalListKeys() ? this.getSortedNumKeys(this.prefix + listKey, true) : this.getSortedStringKeys(this.prefix + listKey, true);
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        int prefixLen = this.prefix.length();
        for (String key : keys) {
            key = key.substring(prefixLen);
            ret.add(key + '.');
        }
        return ret;
    }

    protected void logValue(String name, String val) {
        this.warned.add(name);
        PropertyMD meta = this.getMetadata(name);
        boolean hideValue = false;
        if (meta != null && meta.isSecret()) {
            hideValue = true;
        }
        if (val == null) {
            this.log.debug("Parameter " + this.getKeyDescription(name) + " value is not set");
        } else {
            this.log.debug("Parameter " + this.getKeyDescription(name) + " value is: " + (hideValue ? "--SECRET--" : val));
        }
    }

    public synchronized boolean isSet(String name) {
        return this.properties.containsKey(this.prefix + name);
    }

    public synchronized String getRawProperty(String key) {
        return this.properties.getProperty(key);
    }

    Logger getLoger() {
        return this.log;
    }

    public PropertiesHelper clone() {
        PropertiesHelper ret = new PropertiesHelper(this.prefix, this.properties, this.metadata, this.log);
        this.cloneTo(ret);
        return ret;
    }

    protected void cloneTo(PropertiesHelper to) {
        to.warned.addAll(this.warned);
        to.genericListeners.addAll(this.genericListeners);
        to.propertyFocusedListeners.putAll(this.propertyFocusedListeners);
    }
}

