/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.unicore.security.SecurityTokens;

public class SecuritySession {
    private final String sessionID;
    private final SecurityTokens tokens;
    private final long expires;
    private long lastAccessed;
    private String userKey;

    public SecuritySession(String sessionID, SecurityTokens tokens, long lifetime) {
        this.sessionID = sessionID;
        this.tokens = tokens;
        this.expires = System.currentTimeMillis() + lifetime;
        this.lastAccessed = System.currentTimeMillis();
    }

    public SecurityTokens getTokens() {
        this.lastAccessed = System.currentTimeMillis();
        try {
            return this.tokens.clone();
        }
        catch (CloneNotSupportedException cne) {
            return this.tokens;
        }
    }

    public boolean isExpired() {
        return this.expires < System.currentTimeMillis();
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public long getLifetime() {
        long lt = this.expires - System.currentTimeMillis();
        return lt > 0L ? lt : 0L;
    }
}

