/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.canl;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.util.Log;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class LoggingX509TrustManager
implements X509TrustManager {
    private static final Logger log = Log.getLogger("unicore.security", LoggingX509TrustManager.class);
    private X509TrustManager defaultTrustManager = null;
    private String info;

    public LoggingX509TrustManager(X509TrustManager defaultTrustManager, String info) {
        if (defaultTrustManager == null) {
            throw new IllegalArgumentException("Trust manager may not be null");
        }
        this.info = info;
        this.defaultTrustManager = defaultTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String s) throws CertificateException {
        this.logCerts("Checking client's certificate:\n", certificates);
        try {
            this.defaultTrustManager.checkClientTrusted(certificates, s);
            this.logSuccessfulVerification("client", certificates);
        }
        catch (CertificateException e) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            this.logFailedVerification("client", e);
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String s) throws CertificateException {
        this.logCerts("Checking server's certificate:\n", certificates);
        try {
            this.defaultTrustManager.checkServerTrusted(certificates, s);
            this.logSuccessfulVerification("server", certificates);
        }
        catch (CertificateException e) {
            this.logFailedVerification("server", e);
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    private void logCerts(String type, X509Certificate[] certificates) {
        if (log.isDebugEnabled() && certificates != null) {
            String info = CertificateUtils.format((X509Certificate[])certificates, (FormatMode)FormatMode.FULL);
            log.debug("[" + this.info + "] " + type + info);
        }
    }

    private void logFailedVerification(String type, CertificateException e) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug("[" + this.info + "] Verification of the " + type + " certificate failed. " + e.getMessage());
    }

    private void logSuccessfulVerification(String type, X509Certificate[] certificates) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug("[" + this.info + "] Verification of the " + type + " certificate with subject DN " + X500NameUtils.getReadableForm((X500Principal)certificates[0].getSubjectX500Principal()) + " was successful");
    }
}

