/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.trust;

import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.DsigSamlTrustCheckerBase;
import eu.unicore.security.dsig.IdAttribute;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.w3.x2000.x09.xmldsig.SignatureType;

public class SimpleTrustChecker
extends DsigSamlTrustCheckerBase {
    private X509Certificate issuerCert;
    private boolean signatureOptional;

    public SimpleTrustChecker(X509Certificate issuerCertificate, boolean signatureOptional) {
        this.issuerCert = issuerCertificate;
        this.signatureOptional = signatureOptional;
    }

    @Override
    protected PublicKey establishKey(NameIDType issuer, SignatureType signature) throws SAMLValidationException {
        return this.issuerCert.getPublicKey();
    }

    @Override
    protected void isCorrectlySigned(Document doc, PublicKey key, SignatureType signature, List<Element> shallBeSigned, IdAttribute idAttribute) throws SAMLValidationException {
        if (this.signatureOptional && (signature == null || signature.isNil())) {
            return;
        }
        super.isCorrectlySigned(doc, key, signature, shallBeSigned, idAttribute);
    }
}

