/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.assertion;

import eu.unicore.samly2.SAMLUtils;
import eu.unicore.security.dsig.Utils;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.ConditionsType;
import xmlbeans.org.oasis.saml2.assertion.KeyInfoConfirmationDataType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;
import xmlbeans.org.w3.x2000.x09.xmldsig.KeyInfoType;
import xmlbeans.org.w3.x2000.x09.xmldsig.X509DataType;

public class AssertionParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected AssertionDocument assertionDoc;

    protected AssertionParser() {
    }

    public AssertionParser(AssertionDocument doc) {
        this.assertionDoc = doc;
    }

    public AssertionParser(AssertionType assertion) {
        this.assertionDoc = AssertionDocument.Factory.newInstance();
        this.assertionDoc.setAssertion(assertion);
    }

    @Deprecated
    public String getIssuerDN() {
        return this.assertionDoc.getAssertion().getIssuer().getStringValue();
    }

    public String getIssuerName() {
        return this.assertionDoc.getAssertion().getIssuer().getStringValue();
    }

    @Deprecated
    public String getSubjectDN() {
        return this.getSubjectName();
    }

    public String getSubjectName() {
        return this.assertionDoc.getAssertion().getSubject().getNameID().getStringValue();
    }

    public String getIssuerNameFormat() {
        return this.assertionDoc.getAssertion().getIssuer().getFormat();
    }

    public String getSubjectNameFormat() {
        return this.assertionDoc.getAssertion().getSubject().getNameID().getFormat();
    }

    public boolean isSigned() {
        return this.assertionDoc.getAssertion().getSignature() != null && !this.assertionDoc.getAssertion().getSignature().isNil();
    }

    public X509Certificate[] getIssuerFromSignature() {
        return SAMLUtils.getIssuerFromSignature(this.assertionDoc.getAssertion().getSignature());
    }

    public X509Certificate[] getSubjectFromConfirmation() {
        KeyInfoConfirmationDataType confirData;
        SubjectType subject = this.assertionDoc.getAssertion().getSubject();
        if (subject == null) {
            return null;
        }
        SubjectConfirmationType[] tt = subject.getSubjectConfirmationArray();
        if (tt == null || tt.length == 0) {
            return null;
        }
        SubjectConfirmationType confirmation = tt[0];
        if (confirmation == null) {
            return null;
        }
        try {
            confirData = (KeyInfoConfirmationDataType)confirmation.getSubjectConfirmationData();
        }
        catch (ClassCastException e) {
            return null;
        }
        if (confirData == null) {
            return null;
        }
        KeyInfoType ki = confirData.getKeyInfoArray(0);
        if (ki == null) {
            return null;
        }
        X509DataType[] x509Data = ki.getX509DataArray();
        if (x509Data == null) {
            return null;
        }
        for (int i = 0; i < x509Data.length; ++i) {
            if (x509Data[i].getX509CertificateArray().length <= 0) continue;
            return Utils.deserializeCertificateChain(x509Data[i].getX509CertificateArray());
        }
        return null;
    }

    public AssertionDocument getXMLBeanDoc() {
        return this.assertionDoc;
    }

    public AssertionType getXMLBean() {
        return this.assertionDoc.getAssertion();
    }

    public int getProxyRestriction() {
        ConditionsType conditions = this.assertionDoc.getAssertion().getConditions();
        if (conditions == null || conditions.sizeOfProxyRestrictionArray() == 0) {
            return -1;
        }
        return conditions.getProxyRestrictionArray(0).getCount().intValue();
    }

    public Date getNotBefore() {
        ConditionsType conditions = this.assertionDoc.getAssertion().getConditions();
        Calendar c = conditions.getNotBefore();
        return c == null ? null : c.getTime();
    }

    public Date getNotOnOrAfter() {
        ConditionsType conditions = this.assertionDoc.getAssertion().getConditions();
        Calendar c = conditions.getNotOnOrAfter();
        return c == null ? null : c.getTime();
    }
}

