/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.rft;

import de.fzj.unicore.uas.client.ReliableFileTransferClient;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class AbstractStoreImpl
implements ReliableFileTransferClient.Store {
    protected final long totalLength;
    protected final String target;
    protected final String partsDir;
    protected final String propertiesPath;
    protected final Properties properties = new Properties();
    protected final int chunkLength;
    protected boolean append = false;
    public static int minChunkLength = 0xA00000;
    public static final String suffix = ".unicore_rft.parts";

    public AbstractStoreImpl(String target, long totalLength) {
        this.totalLength = totalLength;
        this.target = target;
        this.partsDir = target + suffix;
        this.propertiesPath = this.partsDir + "/properties";
        this.chunkLength = AbstractStoreImpl.computeChunkLength(totalLength);
    }

    public static int computeChunkLength(long totalLength) {
        int length = minChunkLength;
        int total = minChunkLength * 100;
        if ((long)total < totalLength) {
            length = (int)((long)length + (totalLength - (long)total) / 99L);
        }
        return length;
    }

    @Override
    public List<ReliableFileTransferClient.Chunk> getChunks() throws Exception {
        List<ReliableFileTransferClient.Chunk> result = this.allChunks();
        Iterator<ReliableFileTransferClient.Chunk> iterator = result.iterator();
        while (iterator.hasNext()) {
            if (this.needToDownload(iterator.next())) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public void ack(ReliableFileTransferClient.Chunk chunk) throws Exception {
        boolean ok = this.checkOK(chunk);
        if (ok) {
            this.properties.setProperty("chunk." + this.format(chunk.getIndex()) + ".status", "done");
            this.writeProperties();
        } else {
            this.properties.setProperty("chunk." + this.format(chunk.getIndex()) + ".status", "partial");
            this.writeProperties();
        }
    }

    protected abstract boolean checkOK(ReliableFileTransferClient.Chunk var1) throws Exception;

    protected String buildFileList() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.getFileNameList()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    protected List<String> getFileNameList() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        long pos = 0L;
        while (pos < this.totalLength) {
            result.add("p_" + this.format(i));
            pos += (long)this.chunkLength;
            ++i;
        }
        return result;
    }

    public boolean needToDownload(ReliableFileTransferClient.Chunk chunk) {
        String status = this.properties.getProperty("chunk." + this.format(chunk.getIndex()) + ".status", null);
        if (status == null) {
            return true;
        }
        if ("done".equals(status)) {
            return false;
        }
        if ("partial".equals(status)) {
            try {
                long actualSize = this.getActualFileSize(chunk);
                if (actualSize > 0L) {
                    chunk.setOffset(actualSize);
                    chunk.setLength(chunk.getLength() - actualSize);
                    chunk.setAppend(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    protected abstract long getActualFileSize(ReliableFileTransferClient.Chunk var1) throws Exception;

    protected String format(int index) {
        return String.format("%04d", index);
    }

    protected void init() throws Exception {
        this.createPartsDirIfNotExists();
        this.loadPropertiesFileIfExists();
    }

    protected List<ReliableFileTransferClient.Chunk> allChunks() throws Exception {
        this.init();
        ArrayList<ReliableFileTransferClient.Chunk> result = new ArrayList<ReliableFileTransferClient.Chunk>();
        int i = 0;
        long pos = 0L;
        while (pos < this.totalLength) {
            long length = Math.min((long)this.chunkLength, this.totalLength - pos);
            String path = this.partsDir + "/" + "p_" + this.format(i);
            ReliableFileTransferClient.Chunk c = this.createChunk(i, path, pos, length);
            result.add(c);
            pos += (long)this.chunkLength;
            ++i;
        }
        return result;
    }

    protected abstract ReliableFileTransferClient.Chunk createChunk(int var1, String var2, long var3, long var5);

    protected abstract void createPartsDirIfNotExists() throws Exception;

    protected abstract void loadPropertiesFileIfExists() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeProperties() throws Exception {
        OutputStream os = this.getOutputStream(this.propertiesPath, false);
        try {
            this.properties.store(os, "auto-generated, DO NOT EDIT");
        }
        finally {
            os.close();
        }
    }

    protected abstract OutputStream getOutputStream(String var1, boolean var2) throws IOException;
}

