/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.api;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ProfileConfiguration {
    private String profileName = null;
    private String dialectName = null;
    private List<String> hiddenClaims = new CopyOnWriteArrayList<String>();
    private List<String> overriddenClaims = new CopyOnWriteArrayList<String>();
    private List<String> inheritedClaims = new CopyOnWriteArrayList<String>();

    public ProfileConfiguration() {
    }

    public ProfileConfiguration(String profileName, List<String> hiddenClaims, List<String> overriddenClaims, List<String> inheritedClaims) {
        this.profileName = profileName;
        this.hiddenClaims = new CopyOnWriteArrayList<String>(hiddenClaims);
        this.overriddenClaims = new CopyOnWriteArrayList<String>(overriddenClaims);
        this.inheritedClaims = new CopyOnWriteArrayList<String>(inheritedClaims);
    }

    public ProfileConfiguration(String profileName, String dialect, List<String> hiddenClaims, List<String> overriddenClaims, List<String> inheritedClaims) {
        this.profileName = profileName;
        this.dialectName = dialect;
        this.hiddenClaims = new CopyOnWriteArrayList<String>(hiddenClaims);
        this.overriddenClaims = new CopyOnWriteArrayList<String>(overriddenClaims);
        this.inheritedClaims = new CopyOnWriteArrayList<String>(inheritedClaims);
    }

    public List<String> getInheritedClaims() {
        return this.inheritedClaims;
    }

    public void setInheritedClaims(List<String> inheritedClaims) {
        this.inheritedClaims = new CopyOnWriteArrayList<String>(inheritedClaims);
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public List<String> getHiddenClaims() {
        return this.hiddenClaims;
    }

    public void setHiddenClaims(List<String> hiddenClaims) {
        this.hiddenClaims = new CopyOnWriteArrayList<String>(hiddenClaims);
    }

    public List<String> getOverriddenClaims() {
        return this.overriddenClaims;
    }

    public void setOverriddenClaims(List<String> overriddenClaims) {
        this.overriddenClaims = new CopyOnWriteArrayList<String>(overriddenClaims);
    }

    public String getDialectName() {
        return this.dialectName;
    }

    public void setDialectName(String dialectName) {
        this.dialectName = dialectName;
    }

    public void addInheritedClaim(String claimUri) {
        this.inheritedClaims.add(claimUri);
    }

    public void addHiddenClaim(String claimUri) {
        this.hiddenClaims.add(claimUri);
    }

    public void addOverriddenClaim(String claimUri) {
        this.overriddenClaims.add(claimUri);
    }
}

