/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.StatPathable;
import org.apache.curator.framework.api.TempGetDataBuilder;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.zookeeper.data.Stat;

class TempGetDataBuilderImpl
implements TempGetDataBuilder {
    private final CuratorFrameworkImpl client;
    private Stat responseStat;
    private boolean decompress;

    TempGetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.responseStat = null;
        this.decompress = false;
    }

    @Override
    public StatPathable<byte[]> decompressed() {
        this.decompress = true;
        return this;
    }

    @Override
    public Pathable<byte[]> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return this;
    }

    @Override
    public byte[] forPath(String path) throws Exception {
        final String localPath = this.client.fixForNamespace(path);
        TimeTrace trace = this.client.getZookeeperClient().startTracer("GetDataBuilderImpl-Foreground");
        byte[] responseData = (byte[])RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return TempGetDataBuilderImpl.this.client.getZooKeeper().getData(localPath, false, TempGetDataBuilderImpl.this.responseStat);
            }
        });
        trace.commit();
        return this.decompress ? this.client.getCompressionProvider().decompress(path, responseData) : responseData;
    }
}

