/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.config;

import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.SubmissionAddressing;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.feature.ServerConfigurator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.ServerConfiguratorRegistry;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingConfigurator
implements ServerConfigurator {
    private static Log log = LogFactory.getLog(AddressingConfigurator.class);

    public void configure(EndpointDescription endpointDescription) {
        boolean w3cAddressingEnabled;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start configure");
        }
        Addressing addressing = (Addressing)((EndpointDescriptionJava)((Object)endpointDescription)).getAnnoFeature("http://www.w3.org/2005/08/addressing/module");
        SubmissionAddressing submissionAddressing = (SubmissionAddressing)((EndpointDescriptionJava)((Object)endpointDescription)).getAnnoFeature("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        Parameter namespace = new Parameter("WSAddressingVersion", null);
        Parameter disabled = new Parameter("disableAddressingForInMessages", "false");
        Parameter required = new Parameter("addressingRequirementParameter", "unspecified");
        Parameter responses = null;
        if (addressing != null && submissionAddressing != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Both Addressing and SubmissionAddressing are specified");
            }
            w3cAddressingEnabled = addressing.enabled();
            boolean submissionAddressingEnabled = submissionAddressing.enabled();
            if (w3cAddressingEnabled && submissionAddressingEnabled) {
                namespace.setValue(null);
                boolean w3cAddressingRequired = addressing.required();
                boolean submissionAddressingRequired = submissionAddressing.required();
                if (w3cAddressingRequired || submissionAddressingRequired) {
                    required.setValue("required");
                }
            } else if (w3cAddressingEnabled) {
                namespace.setValue("http://www.w3.org/2005/08/addressing");
                if (addressing.required()) {
                    required.setValue("required");
                }
            } else if (submissionAddressingEnabled) {
                namespace.setValue("http://schemas.xmlsoap.org/ws/2004/08/addressing");
                if (submissionAddressing.required()) {
                    required.setValue("required");
                }
            } else {
                disabled.setValue("true");
            }
        } else if (addressing != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Only Addressing is specified.  SubmissionAddressing is not specified");
            }
            if (w3cAddressingEnabled = addressing.enabled()) {
                namespace.setValue("http://www.w3.org/2005/08/addressing");
                if (addressing.required()) {
                    required.setValue("required");
                }
            } else {
                namespace.setValue("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            }
        } else if (submissionAddressing != null) {
            boolean submissionAddressingEnabled;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Only SubmssionAddressing is specified.  Addressing is not specified");
            }
            if (submissionAddressingEnabled = submissionAddressing.enabled()) {
                namespace.setValue("http://schemas.xmlsoap.org/ws/2004/08/addressing");
                if (submissionAddressing.required()) {
                    required.setValue("required");
                }
            } else {
                namespace.setValue("http://www.w3.org/2005/08/addressing");
            }
        } else {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("NoWSAddressingFeatures"));
        }
        if (addressing != null) {
            responses = new Parameter("wsamInvocationPattern", AddressingConfigurator.mapResponseAttributeToAddressing(addressing.responses()));
        }
        try {
            ServiceDescription sd;
            AxisConfiguration axisConfig;
            String value;
            AxisService service = endpointDescription.getAxisService();
            service.addParameter(namespace);
            service.addParameter(disabled);
            service.addParameter(required);
            if (responses != null) {
                service.addParameter(responses);
            }
            if (JavaUtils.isFalseExplicitly(value = Utils.getParameterValue(disabled)) && !(axisConfig = (sd = endpointDescription.getServiceDescription()).getAxisConfigContext().getAxisConfiguration()).isEngaged("addressing")) {
                axisConfig.engageModule("addressing");
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unexpected Exception occurred:", (Throwable)e);
            }
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("AddressingEngagementError", e.toString()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End configure");
        }
    }

    public static String mapResponseAttributeToAddressing(AddressingFeature.Responses responses) {
        String addressingType = null;
        switch (responses) {
            case ALL: {
                addressingType = "both";
                break;
            }
            case ANONYMOUS: {
                addressingType = "synchronous";
                break;
            }
            case NON_ANONYMOUS: {
                addressingType = "asynchronous";
            }
        }
        return addressingType;
    }

    public boolean supports(String bindingId) {
        return ServerConfiguratorRegistry.isSOAPBinding(bindingId);
    }
}

