/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.jws.WebParam;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.Element;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.marshaller.impl.alt.PDElement;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.axis2.jaxws.wrapper.impl.JAXBWrapperToolImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLitWrappedPlusMethodMarshaller
implements MethodMarshaller {
    private static Log log = LogFactory.getLog(DocLitWrappedPlusMethodMarshaller.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object demarshalResponse(Message message, Object[] signatureArgs, OperationDescription operationDesc) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Calling DocLitWrapperPlusMethodMarshaller.demarshalResponse");
            log.debug((Object)"  The DocLitWrapped Plus marshaller is used when the web service method deviates from the normal doc/lit rules.");
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            JAXBBlockFactory factory;
            Block block;
            Object wrapperObject;
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            String packagesKey = marshalDesc.getPackagesKey();
            Object returnValue = null;
            Class returnType = operationDesc.getResultActualType();
            boolean isChildReturn = !operationDesc.isJAXWSAsyncClientMethod() && operationDesc.getResultPartName() != null;
            boolean isNoReturn = returnType == Void.TYPE;
            JAXBBlockContext blockContext = new JAXBBlockContext(packages, packagesKey);
            blockContext.setWebServiceNamespace(ed.getTargetNamespace());
            if (!this.isResponseWrapperAnXmlRootElement(operationDesc, marshalDesc, endpointDesc)) {
                String clsName = marshalDesc.getResponseWrapperClassName(operationDesc);
                Class cls = this.loadClass(clsName, endpointDesc);
                blockContext.setProcessType(cls);
            }
            if ((wrapperObject = (block = message.getBodyBlock(blockContext, factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class))).getBusinessObject(true)) instanceof JAXBElement) {
                wrapperObject = ((JAXBElement)wrapperObject).getValue();
            }
            JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<ParameterDescription> pdList = new ArrayList<ParameterDescription>();
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                if (pd.getMode() != WebParam.Mode.OUT && pd.getMode() != WebParam.Mode.INOUT) continue;
                if (!pd.isHeader()) {
                    names.add(pd.getParameterName());
                }
                pdList.add(pd);
            }
            if (!operationDesc.isResultHeader() && isChildReturn && !isNoReturn) {
                names.add(operationDesc.getResultPartName());
            }
            Object[] objects = wrapperTool.unWrap(wrapperObject, names, marshalDesc.getPropertyDescriptorMap(wrapperObject.getClass()));
            ArrayList<PDElement> pvList = new ArrayList<PDElement>();
            int bodyIndex = 0;
            for (int i = 0; i < pdList.size(); ++i) {
                Class actualType;
                ParameterDescription pd = (ParameterDescription)pdList.get(i);
                if (!pd.isHeader()) {
                    Object value = objects[bodyIndex];
                    QName qName = new QName(pd.getTargetNamespace(), pd.getPartName());
                    Element element = null;
                    element = !marshalDesc.getAnnotationDesc(pd.getParameterActualType()).hasXmlRootElement() ? new Element(value, qName, pd.getParameterActualType()) : new Element(value, qName);
                    pvList.add(new PDElement(pd, element, null));
                    ++bodyIndex;
                    continue;
                }
                String localName = pd.getParameterName();
                JAXBBlockContext blkContext = new JAXBBlockContext(packages, packagesKey);
                if (blkContext.getConstructionType() != JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH && MethodMarshallerUtils.isNotJAXBRootElement(actualType = pd.getParameterActualType(), marshalDesc)) {
                    blkContext.setProcessType(actualType);
                    blkContext.setIsxmlList(pd.isListType());
                }
                block = message.getHeaderBlock(pd.getTargetNamespace(), localName, blkContext, factory);
                Object value = block.getBusinessObject(true);
                Element element = new Element(value, new QName(pd.getTargetNamespace(), localName));
                pvList.add(new PDElement(pd, element, blkContext.getProcessType()));
            }
            MethodMarshallerUtils.updateResponseSignatureArgs(pds, pvList, signatureArgs);
            if (isNoReturn) {
                return null;
            }
            if (!isChildReturn) return wrapperObject;
            if (!operationDesc.isResultHeader()) {
                returnValue = objects[objects.length - 1];
            } else {
                Element returnElement = MethodMarshallerUtils.getReturnElement(packages, message, null, false, true, operationDesc.getResultTargetNamespace(), operationDesc.getResultPartName(), false);
                returnValue = returnElement.getTypeValue();
            }
            if (ConvertUtils.isConvertable(returnValue, returnType)) {
                return ConvertUtils.convert(returnValue, returnType);
            }
            String objectClass = returnValue == null ? "null" : returnValue.getClass().getName();
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("convertProblem", objectClass, returnType.getName()));
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public Object[] demarshalRequest(Message message, OperationDescription operationDesc) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Calling DocLitWrapperPlusMethodMarshaller.demarshalRequest");
            log.debug((Object)"  The DocLitWrapped Plus marshaller is used when the web service method deviates from the normal doc/lit rules.");
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            JAXBBlockFactory factory;
            Block block;
            Object wrapperObject;
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            String packagesKey = marshalDesc.getPackagesKey();
            JAXBBlockContext blockContext = new JAXBBlockContext(packages, packagesKey);
            blockContext.setWebServiceNamespace(ed.getTargetNamespace());
            if (!this.isRequestWrapperAnXmlRootElement(operationDesc, marshalDesc, endpointDesc)) {
                String clsName = marshalDesc.getRequestWrapperClassName(operationDesc);
                Class cls = this.loadClass(clsName, endpointDesc);
                blockContext.setProcessType(cls);
            }
            if ((wrapperObject = (block = message.getBodyBlock(blockContext, factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class))).getBusinessObject(true)) instanceof JAXBElement) {
                wrapperObject = ((JAXBElement)wrapperObject).getValue();
            }
            JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
            ArrayList<String> xmlNames = new ArrayList<String>();
            ArrayList<ParameterDescription> pdList = new ArrayList<ParameterDescription>();
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                if (pd.getMode() != WebParam.Mode.IN && pd.getMode() != WebParam.Mode.INOUT) continue;
                if (!pd.isHeader()) {
                    xmlNames.add(pd.getParameterName());
                }
                pdList.add(pd);
            }
            Object[] objects = wrapperTool.unWrap(wrapperObject, xmlNames, marshalDesc.getPropertyDescriptorMap(wrapperObject.getClass()));
            ArrayList<PDElement> pvList = new ArrayList<PDElement>();
            int bodyIndex = 0;
            for (int i = 0; i < pdList.size(); ++i) {
                ParameterDescription pd = (ParameterDescription)pdList.get(i);
                if (!pd.isHeader()) {
                    Object value = objects[bodyIndex];
                    QName qName = new QName(pd.getTargetNamespace(), pd.getPartName());
                    Element element = null;
                    element = !marshalDesc.getAnnotationDesc(pd.getParameterActualType()).hasXmlRootElement() ? new Element(value, qName, pd.getParameterActualType()) : new Element(value, qName);
                    pvList.add(new PDElement(pd, element, null));
                    ++bodyIndex;
                    continue;
                }
                String localName = pd.getParameterName();
                JAXBBlockContext blkContext = new JAXBBlockContext(packages, marshalDesc.getPackagesKey());
                if (blkContext.getConstructionType() != JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                    Class actualType = pd.getParameterActualType();
                    if (MethodMarshallerUtils.isNotJAXBRootElement(actualType, marshalDesc)) {
                        blkContext.setProcessType(actualType);
                    } else {
                        Annotation[] annos = actualType.getAnnotations();
                        if (annos == null || annos.length == 0) {
                            blkContext.setProcessType(actualType);
                            blkContext.setIsxmlList(pd.isListType());
                        }
                    }
                }
                block = message.getHeaderBlock(pd.getTargetNamespace(), localName, blkContext, factory);
                Object value = block.getBusinessObject(true);
                Element element = new Element(value, new QName(pd.getTargetNamespace(), localName));
                pvList.add(new PDElement(pd, element, blkContext.getProcessType()));
            }
            Object[] sigArguments = MethodMarshallerUtils.createRequestSignatureArgs(pds, pvList);
            return sigArguments;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public Message marshalResponse(Object returnObject, Object[] signatureArgs, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Calling DocLitWrapperPlusMethodMarshaller.marshalResponse");
            log.debug((Object)"  The DocLitWrapped Plus marshaller is used when the web service method deviates from the normal doc/lit rules.");
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            String name;
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            String packagesKey = marshalDesc.getPackagesKey();
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArgs, false, true, false);
            ArrayList<String> nameList = new ArrayList<String>();
            HashMap<String, Object> objectList = new HashMap<String, Object>();
            HashMap<String, Class> declaredClassMap = new HashMap<String, Class>();
            ArrayList<PDElement> headerPDEList = new ArrayList<PDElement>();
            Iterator<PDElement> it = pdeList.iterator();
            while (it.hasNext()) {
                PDElement pde = it.next();
                name = pde.getParam().getParameterName();
                if (!pde.getParam().isHeader()) {
                    Object value = pde.getElement().getTypeValue();
                    Class dclClass = pde.getParam().getParameterActualType();
                    nameList.add(name);
                    objectList.put(name, value);
                    declaredClassMap.put(name, dclClass);
                    continue;
                }
                it.remove();
                headerPDEList.add(pde);
            }
            Class returnType = operationDesc.getResultActualType();
            if (!operationDesc.isResultHeader()) {
                if (returnType != Void.TYPE) {
                    name = operationDesc.getResultName();
                    Class dclClass = operationDesc.getResultActualType();
                    nameList.add(name);
                    objectList.put(name, returnObject);
                    declaredClassMap.put(name, dclClass);
                }
            } else if (returnType != Void.TYPE) {
                Element returnElement = null;
                QName returnQName = new QName(operationDesc.getResultTargetNamespace(), operationDesc.getResultName());
                returnElement = marshalDesc.getAnnotationDesc(returnType).hasXmlRootElement() ? new Element(returnObject, returnQName) : new Element(returnObject, returnQName, returnType);
                Class byJavaType = MethodMarshallerUtils.isNotJAXBRootElement(returnType, marshalDesc) ? returnType : null;
                MethodMarshallerUtils.toMessage(returnElement, returnType, operationDesc.isListType(), marshalDesc, m, byJavaType, true);
            }
            String wrapperName = marshalDesc.getResponseWrapperClassName(operationDesc);
            Class cls = this.loadClass(wrapperName, endpointDesc);
            JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
            Object object = wrapperTool.wrap(cls, nameList, objectList, declaredClassMap, marshalDesc.getPropertyDescriptorMap(cls));
            QName wrapperQName = new QName(operationDesc.getResponseWrapperTargetNamespace(), operationDesc.getResponseWrapperLocalName());
            if (!marshalDesc.getAnnotationDesc(cls).hasXmlRootElement()) {
                object = new JAXBElement(wrapperQName, cls, object);
            }
            JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
            JAXBBlockContext blockContext = new JAXBBlockContext(packages, packagesKey);
            blockContext.setWebServiceNamespace(ed.getTargetNamespace());
            Block block = factory.createFrom(object, (Object)blockContext, wrapperQName);
            m.setBodyBlock(block);
            if (headerPDEList.size() > 0) {
                for (PDElement pde : headerPDEList) {
                    Class actualType = pde.getParam().getParameterActualType();
                    if (!MethodMarshallerUtils.isNotJAXBRootElement(actualType, marshalDesc)) continue;
                    pde.setByJavaTypeClass(actualType);
                }
                MethodMarshallerUtils.toMessage(headerPDEList, m, packages, null);
            }
            if (operationDesc.hasResponseSwaRefAttachments()) {
                m.setDoingSWA(true);
            }
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public Message marshalRequest(Object[] signatureArguments, OperationDescription operationDesc, Map<String, Object> requestContext) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Calling DocLitWrapperPlusMethodMarshaller.marshalRequest");
            log.debug((Object)"  The DocLitWrapped Plus marshaller is used when the web service method deviates from the normal doc/lit rules.");
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        Protocol protocol = Protocol.getProtocolForBinding(endpointDesc.getClientBindingID());
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        TreeSet<String> packages = marshalDesc.getPackages();
        String packagesKey = marshalDesc.getPackagesKey();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArguments, true, true, false);
            ArrayList<String> nameList = new ArrayList<String>();
            HashMap<String, Object> objectList = new HashMap<String, Object>();
            HashMap<String, Class> declardClassMap = new HashMap<String, Class>();
            ArrayList<PDElement> headerPDEList = new ArrayList<PDElement>();
            Iterator<PDElement> it = pdeList.iterator();
            while (it.hasNext()) {
                PDElement pde = it.next();
                String name = pde.getParam().getParameterName();
                if (!pde.getParam().isHeader()) {
                    Object value = pde.getElement().getTypeValue();
                    Class dclClass = pde.getParam().getParameterActualType();
                    nameList.add(name);
                    objectList.put(name, value);
                    declardClassMap.put(name, dclClass);
                    continue;
                }
                it.remove();
                headerPDEList.add(pde);
            }
            String wrapperName = marshalDesc.getRequestWrapperClassName(operationDesc);
            Class cls = this.loadClass(wrapperName, endpointDesc);
            JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
            Object object = wrapperTool.wrap(cls, nameList, objectList, declardClassMap, marshalDesc.getPropertyDescriptorMap(cls));
            QName wrapperQName = new QName(operationDesc.getRequestWrapperTargetNamespace(), operationDesc.getRequestWrapperLocalName());
            if (!marshalDesc.getAnnotationDesc(cls).hasXmlRootElement()) {
                object = new JAXBElement(wrapperQName, cls, object);
            }
            JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
            JAXBBlockContext blockContext = new JAXBBlockContext(packages, packagesKey);
            blockContext.setWebServiceNamespace(ed.getTargetNamespace());
            Block block = factory.createFrom(object, (Object)blockContext, wrapperQName);
            m.setBodyBlock(block);
            if (headerPDEList.size() > 0) {
                for (PDElement pde : headerPDEList) {
                    Class actualType = pde.getParam().getParameterActualType();
                    if (!MethodMarshallerUtils.isNotJAXBRootElement(actualType, marshalDesc)) continue;
                    pde.setByJavaTypeClass(actualType);
                }
                MethodMarshallerUtils.toMessage(headerPDEList, m, packages, requestContext);
            }
            if (operationDesc.hasRequestSwaRefAttachments()) {
                m.setDoingSWA(true);
            }
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public Message marshalFaultResponse(Throwable throwable, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Calling DocLitWrapperPlusMethodMarshaller.marshalFaultResponse");
            log.debug((Object)"  The DocLitWrapped Plus marshaller is used when the web service method deviates from the normal doc/lit rules.");
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        TreeSet<String> packages = marshalDesc.getPackages();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            MethodMarshallerUtils.marshalFaultResponse(throwable, marshalDesc, operationDesc, m);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public Throwable demarshalFaultResponse(Message message, OperationDescription operationDesc) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Calling DocLitWrapperPlusMethodMarshaller.demarshalFaultResponse");
            log.debug((Object)"  The DocLitWrapped Plus marshaller is used when the web service method deviates from the normal doc/lit rules.");
        }
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        try {
            Throwable t = MethodMarshallerUtils.demarshalFaultResponse(operationDesc, marshalDesc, message);
            return t;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    boolean isRequestWrapperAnXmlRootElement(OperationDescription opDesc, MarshalServiceRuntimeDescription msrd, EndpointDescription endpointDesc) {
        boolean isRootElement;
        block4: {
            isRootElement = false;
            String wrapperClassName = msrd.getRequestWrapperClassName(opDesc);
            try {
                if (wrapperClassName != null) {
                    AnnotationDesc aDesc = msrd.getAnnotationDesc(wrapperClassName);
                    if (aDesc == null) {
                        Class cls = this.loadClass(wrapperClassName, endpointDesc);
                        aDesc = msrd.getAnnotationDesc(cls);
                    }
                    isRootElement = aDesc.hasXmlRootElement();
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("An error occurred while processing class " + wrapperClassName + " exception is " + t));
                log.debug((Object)"The error is ignored and processing continues.");
            }
        }
        return isRootElement;
    }

    boolean isResponseWrapperAnXmlRootElement(OperationDescription opDesc, MarshalServiceRuntimeDescription msrd, EndpointDescription endpointDesc) {
        boolean isRootElement;
        block4: {
            isRootElement = false;
            String wrapperClassName = msrd.getResponseWrapperClassName(opDesc);
            try {
                if (wrapperClassName != null) {
                    AnnotationDesc aDesc = msrd.getAnnotationDesc(wrapperClassName);
                    if (aDesc == null) {
                        Class cls = this.loadClass(wrapperClassName, endpointDesc);
                        aDesc = msrd.getAnnotationDesc(cls);
                    }
                    isRootElement = aDesc.hasXmlRootElement();
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("An error occurred while processing class " + wrapperClassName + " exception is " + t));
                log.debug((Object)"The error is ignored and processing continues.");
            }
        }
        return isRootElement;
    }

    Class loadClass(String clsName, EndpointDescription endpointDesc) throws ClassNotFoundException {
        Class cls = null;
        try {
            cls = MethodMarshallerUtils.loadClass(clsName);
        }
        catch (ClassNotFoundException e) {
            cls = MethodMarshallerUtils.loadClass(clsName, endpointDesc.getAxisService().getClassLoader());
        }
        return cls;
    }
}

