/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class WorkflowModel
implements TBase<WorkflowModel, _Fields>,
Serializable,
Cloneable,
Comparable<WorkflowModel> {
    private static final TStruct STRUCT_DESC = new TStruct("WorkflowModel");
    private static final TField TEMPLATE_ID_FIELD_DESC = new TField("templateId", 11, 1);
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 2);
    private static final TField GRAPH_FIELD_DESC = new TField("graph", 11, 3);
    private static final TField GATEWAY_ID_FIELD_DESC = new TField("gatewayId", 11, 4);
    private static final TField CREATED_USER_FIELD_DESC = new TField("createdUser", 11, 5);
    private static final TField IMAGE_FIELD_DESC = new TField("image", 11, 6);
    private static final TField WORKFLOW_INPUTS_FIELD_DESC = new TField("workflowInputs", 15, 7);
    private static final TField WORKFLOW_OUTPUTS_FIELD_DESC = new TField("workflowOutputs", 15, 8);
    private static final TField CREATION_TIME_FIELD_DESC = new TField("creationTime", 10, 9);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String templateId;
    private String name;
    private String graph;
    private String gatewayId;
    private String createdUser;
    private ByteBuffer image;
    private List<InputDataObjectType> workflowInputs;
    private List<OutputDataObjectType> workflowOutputs;
    private long creationTime;
    private static final int __CREATIONTIME_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public WorkflowModel() {
        this.templateId = "DO_NOT_SET_AT_CLIENTS";
    }

    public WorkflowModel(String templateId, String name, String graph, String gatewayId, String createdUser) {
        this();
        this.templateId = templateId;
        this.name = name;
        this.graph = graph;
        this.gatewayId = gatewayId;
        this.createdUser = createdUser;
    }

    public WorkflowModel(WorkflowModel other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetTemplateId()) {
            this.templateId = other.templateId;
        }
        if (other.isSetName()) {
            this.name = other.name;
        }
        if (other.isSetGraph()) {
            this.graph = other.graph;
        }
        if (other.isSetGatewayId()) {
            this.gatewayId = other.gatewayId;
        }
        if (other.isSetCreatedUser()) {
            this.createdUser = other.createdUser;
        }
        if (other.isSetImage()) {
            this.image = TBaseHelper.copyBinary((ByteBuffer)other.image);
        }
        if (other.isSetWorkflowInputs()) {
            ArrayList<InputDataObjectType> __this__workflowInputs = new ArrayList<InputDataObjectType>(other.workflowInputs.size());
            for (InputDataObjectType inputDataObjectType : other.workflowInputs) {
                __this__workflowInputs.add(new InputDataObjectType(inputDataObjectType));
            }
            this.workflowInputs = __this__workflowInputs;
        }
        if (other.isSetWorkflowOutputs()) {
            ArrayList<OutputDataObjectType> __this__workflowOutputs = new ArrayList<OutputDataObjectType>(other.workflowOutputs.size());
            for (OutputDataObjectType outputDataObjectType : other.workflowOutputs) {
                __this__workflowOutputs.add(new OutputDataObjectType(outputDataObjectType));
            }
            this.workflowOutputs = __this__workflowOutputs;
        }
        this.creationTime = other.creationTime;
    }

    public WorkflowModel deepCopy() {
        return new WorkflowModel(this);
    }

    public void clear() {
        this.templateId = "DO_NOT_SET_AT_CLIENTS";
        this.name = null;
        this.graph = null;
        this.gatewayId = null;
        this.createdUser = null;
        this.image = null;
        this.workflowInputs = null;
        this.workflowOutputs = null;
        this.setCreationTimeIsSet(false);
        this.creationTime = 0L;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void unsetTemplateId() {
        this.templateId = null;
    }

    public boolean isSetTemplateId() {
        return this.templateId != null;
    }

    public void setTemplateIdIsSet(boolean value) {
        if (!value) {
            this.templateId = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public String getGraph() {
        return this.graph;
    }

    public void setGraph(String graph) {
        this.graph = graph;
    }

    public void unsetGraph() {
        this.graph = null;
    }

    public boolean isSetGraph() {
        return this.graph != null;
    }

    public void setGraphIsSet(boolean value) {
        if (!value) {
            this.graph = null;
        }
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public void unsetGatewayId() {
        this.gatewayId = null;
    }

    public boolean isSetGatewayId() {
        return this.gatewayId != null;
    }

    public void setGatewayIdIsSet(boolean value) {
        if (!value) {
            this.gatewayId = null;
        }
    }

    public String getCreatedUser() {
        return this.createdUser;
    }

    public void setCreatedUser(String createdUser) {
        this.createdUser = createdUser;
    }

    public void unsetCreatedUser() {
        this.createdUser = null;
    }

    public boolean isSetCreatedUser() {
        return this.createdUser != null;
    }

    public void setCreatedUserIsSet(boolean value) {
        if (!value) {
            this.createdUser = null;
        }
    }

    public byte[] getImage() {
        this.setImage(TBaseHelper.rightSize((ByteBuffer)this.image));
        return this.image == null ? null : this.image.array();
    }

    public ByteBuffer bufferForImage() {
        return TBaseHelper.copyBinary((ByteBuffer)this.image);
    }

    public void setImage(byte[] image) {
        this.image = image == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(image, image.length));
    }

    public void setImage(ByteBuffer image) {
        this.image = TBaseHelper.copyBinary((ByteBuffer)image);
    }

    public void unsetImage() {
        this.image = null;
    }

    public boolean isSetImage() {
        return this.image != null;
    }

    public void setImageIsSet(boolean value) {
        if (!value) {
            this.image = null;
        }
    }

    public int getWorkflowInputsSize() {
        return this.workflowInputs == null ? 0 : this.workflowInputs.size();
    }

    public Iterator<InputDataObjectType> getWorkflowInputsIterator() {
        return this.workflowInputs == null ? null : this.workflowInputs.iterator();
    }

    public void addToWorkflowInputs(InputDataObjectType elem) {
        if (this.workflowInputs == null) {
            this.workflowInputs = new ArrayList<InputDataObjectType>();
        }
        this.workflowInputs.add(elem);
    }

    public List<InputDataObjectType> getWorkflowInputs() {
        return this.workflowInputs;
    }

    public void setWorkflowInputs(List<InputDataObjectType> workflowInputs) {
        this.workflowInputs = workflowInputs;
    }

    public void unsetWorkflowInputs() {
        this.workflowInputs = null;
    }

    public boolean isSetWorkflowInputs() {
        return this.workflowInputs != null;
    }

    public void setWorkflowInputsIsSet(boolean value) {
        if (!value) {
            this.workflowInputs = null;
        }
    }

    public int getWorkflowOutputsSize() {
        return this.workflowOutputs == null ? 0 : this.workflowOutputs.size();
    }

    public Iterator<OutputDataObjectType> getWorkflowOutputsIterator() {
        return this.workflowOutputs == null ? null : this.workflowOutputs.iterator();
    }

    public void addToWorkflowOutputs(OutputDataObjectType elem) {
        if (this.workflowOutputs == null) {
            this.workflowOutputs = new ArrayList<OutputDataObjectType>();
        }
        this.workflowOutputs.add(elem);
    }

    public List<OutputDataObjectType> getWorkflowOutputs() {
        return this.workflowOutputs;
    }

    public void setWorkflowOutputs(List<OutputDataObjectType> workflowOutputs) {
        this.workflowOutputs = workflowOutputs;
    }

    public void unsetWorkflowOutputs() {
        this.workflowOutputs = null;
    }

    public boolean isSetWorkflowOutputs() {
        return this.workflowOutputs != null;
    }

    public void setWorkflowOutputsIsSet(boolean value) {
        if (!value) {
            this.workflowOutputs = null;
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        this.setCreationTimeIsSet(true);
    }

    public void unsetCreationTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetCreationTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setCreationTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TEMPLATE_ID: {
                if (value == null) {
                    this.unsetTemplateId();
                    break;
                }
                this.setTemplateId((String)value);
                break;
            }
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case GRAPH: {
                if (value == null) {
                    this.unsetGraph();
                    break;
                }
                this.setGraph((String)value);
                break;
            }
            case GATEWAY_ID: {
                if (value == null) {
                    this.unsetGatewayId();
                    break;
                }
                this.setGatewayId((String)value);
                break;
            }
            case CREATED_USER: {
                if (value == null) {
                    this.unsetCreatedUser();
                    break;
                }
                this.setCreatedUser((String)value);
                break;
            }
            case IMAGE: {
                if (value == null) {
                    this.unsetImage();
                    break;
                }
                this.setImage((ByteBuffer)value);
                break;
            }
            case WORKFLOW_INPUTS: {
                if (value == null) {
                    this.unsetWorkflowInputs();
                    break;
                }
                this.setWorkflowInputs((List)value);
                break;
            }
            case WORKFLOW_OUTPUTS: {
                if (value == null) {
                    this.unsetWorkflowOutputs();
                    break;
                }
                this.setWorkflowOutputs((List)value);
                break;
            }
            case CREATION_TIME: {
                if (value == null) {
                    this.unsetCreationTime();
                    break;
                }
                this.setCreationTime((Long)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TEMPLATE_ID: {
                return this.getTemplateId();
            }
            case NAME: {
                return this.getName();
            }
            case GRAPH: {
                return this.getGraph();
            }
            case GATEWAY_ID: {
                return this.getGatewayId();
            }
            case CREATED_USER: {
                return this.getCreatedUser();
            }
            case IMAGE: {
                return this.getImage();
            }
            case WORKFLOW_INPUTS: {
                return this.getWorkflowInputs();
            }
            case WORKFLOW_OUTPUTS: {
                return this.getWorkflowOutputs();
            }
            case CREATION_TIME: {
                return this.getCreationTime();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TEMPLATE_ID: {
                return this.isSetTemplateId();
            }
            case NAME: {
                return this.isSetName();
            }
            case GRAPH: {
                return this.isSetGraph();
            }
            case GATEWAY_ID: {
                return this.isSetGatewayId();
            }
            case CREATED_USER: {
                return this.isSetCreatedUser();
            }
            case IMAGE: {
                return this.isSetImage();
            }
            case WORKFLOW_INPUTS: {
                return this.isSetWorkflowInputs();
            }
            case WORKFLOW_OUTPUTS: {
                return this.isSetWorkflowOutputs();
            }
            case CREATION_TIME: {
                return this.isSetCreationTime();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof WorkflowModel) {
            return this.equals((WorkflowModel)that);
        }
        return false;
    }

    public boolean equals(WorkflowModel that) {
        if (that == null) {
            return false;
        }
        boolean this_present_templateId = this.isSetTemplateId();
        boolean that_present_templateId = that.isSetTemplateId();
        if (this_present_templateId || that_present_templateId) {
            if (!this_present_templateId || !that_present_templateId) {
                return false;
            }
            if (!this.templateId.equals(that.templateId)) {
                return false;
            }
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_graph = this.isSetGraph();
        boolean that_present_graph = that.isSetGraph();
        if (this_present_graph || that_present_graph) {
            if (!this_present_graph || !that_present_graph) {
                return false;
            }
            if (!this.graph.equals(that.graph)) {
                return false;
            }
        }
        boolean this_present_gatewayId = this.isSetGatewayId();
        boolean that_present_gatewayId = that.isSetGatewayId();
        if (this_present_gatewayId || that_present_gatewayId) {
            if (!this_present_gatewayId || !that_present_gatewayId) {
                return false;
            }
            if (!this.gatewayId.equals(that.gatewayId)) {
                return false;
            }
        }
        boolean this_present_createdUser = this.isSetCreatedUser();
        boolean that_present_createdUser = that.isSetCreatedUser();
        if (this_present_createdUser || that_present_createdUser) {
            if (!this_present_createdUser || !that_present_createdUser) {
                return false;
            }
            if (!this.createdUser.equals(that.createdUser)) {
                return false;
            }
        }
        boolean this_present_image = this.isSetImage();
        boolean that_present_image = that.isSetImage();
        if (this_present_image || that_present_image) {
            if (!this_present_image || !that_present_image) {
                return false;
            }
            if (!this.image.equals(that.image)) {
                return false;
            }
        }
        boolean this_present_workflowInputs = this.isSetWorkflowInputs();
        boolean that_present_workflowInputs = that.isSetWorkflowInputs();
        if (this_present_workflowInputs || that_present_workflowInputs) {
            if (!this_present_workflowInputs || !that_present_workflowInputs) {
                return false;
            }
            if (!this.workflowInputs.equals(that.workflowInputs)) {
                return false;
            }
        }
        boolean this_present_workflowOutputs = this.isSetWorkflowOutputs();
        boolean that_present_workflowOutputs = that.isSetWorkflowOutputs();
        if (this_present_workflowOutputs || that_present_workflowOutputs) {
            if (!this_present_workflowOutputs || !that_present_workflowOutputs) {
                return false;
            }
            if (!this.workflowOutputs.equals(that.workflowOutputs)) {
                return false;
            }
        }
        boolean this_present_creationTime = this.isSetCreationTime();
        boolean that_present_creationTime = that.isSetCreationTime();
        if (this_present_creationTime || that_present_creationTime) {
            if (!this_present_creationTime || !that_present_creationTime) {
                return false;
            }
            if (this.creationTime != that.creationTime) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_templateId = this.isSetTemplateId();
        list.add(present_templateId);
        if (present_templateId) {
            list.add(this.templateId);
        }
        boolean present_name = this.isSetName();
        list.add(present_name);
        if (present_name) {
            list.add(this.name);
        }
        boolean present_graph = this.isSetGraph();
        list.add(present_graph);
        if (present_graph) {
            list.add(this.graph);
        }
        boolean present_gatewayId = this.isSetGatewayId();
        list.add(present_gatewayId);
        if (present_gatewayId) {
            list.add(this.gatewayId);
        }
        boolean present_createdUser = this.isSetCreatedUser();
        list.add(present_createdUser);
        if (present_createdUser) {
            list.add(this.createdUser);
        }
        boolean present_image = this.isSetImage();
        list.add(present_image);
        if (present_image) {
            list.add(this.image);
        }
        boolean present_workflowInputs = this.isSetWorkflowInputs();
        list.add(present_workflowInputs);
        if (present_workflowInputs) {
            list.add(this.workflowInputs);
        }
        boolean present_workflowOutputs = this.isSetWorkflowOutputs();
        list.add(present_workflowOutputs);
        if (present_workflowOutputs) {
            list.add(this.workflowOutputs);
        }
        boolean present_creationTime = this.isSetCreationTime();
        list.add(present_creationTime);
        if (present_creationTime) {
            list.add(this.creationTime);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(WorkflowModel other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTemplateId()).compareTo(other.isSetTemplateId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTemplateId() && (lastComparison = TBaseHelper.compareTo((String)this.templateId, (String)other.templateId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetName()).compareTo(other.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo((String)this.name, (String)other.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGraph()).compareTo(other.isSetGraph());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGraph() && (lastComparison = TBaseHelper.compareTo((String)this.graph, (String)other.graph)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGatewayId()).compareTo(other.isSetGatewayId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGatewayId() && (lastComparison = TBaseHelper.compareTo((String)this.gatewayId, (String)other.gatewayId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreatedUser()).compareTo(other.isSetCreatedUser());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreatedUser() && (lastComparison = TBaseHelper.compareTo((String)this.createdUser, (String)other.createdUser)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetImage()).compareTo(other.isSetImage());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetImage() && (lastComparison = TBaseHelper.compareTo((Comparable)this.image, (Comparable)other.image)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetWorkflowInputs()).compareTo(other.isSetWorkflowInputs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWorkflowInputs() && (lastComparison = TBaseHelper.compareTo(this.workflowInputs, other.workflowInputs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetWorkflowOutputs()).compareTo(other.isSetWorkflowOutputs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWorkflowOutputs() && (lastComparison = TBaseHelper.compareTo(this.workflowOutputs, other.workflowOutputs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreationTime()).compareTo(other.isSetCreationTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreationTime() && (lastComparison = TBaseHelper.compareTo((long)this.creationTime, (long)other.creationTime)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkflowModel(");
        boolean first = true;
        sb.append("templateId:");
        if (this.templateId == null) {
            sb.append("null");
        } else {
            sb.append(this.templateId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("graph:");
        if (this.graph == null) {
            sb.append("null");
        } else {
            sb.append(this.graph);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("gatewayId:");
        if (this.gatewayId == null) {
            sb.append("null");
        } else {
            sb.append(this.gatewayId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("createdUser:");
        if (this.createdUser == null) {
            sb.append("null");
        } else {
            sb.append(this.createdUser);
        }
        first = false;
        if (this.isSetImage()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("image:");
            if (this.image == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.image, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetWorkflowInputs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("workflowInputs:");
            if (this.workflowInputs == null) {
                sb.append("null");
            } else {
                sb.append(this.workflowInputs);
            }
            first = false;
        }
        if (this.isSetWorkflowOutputs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("workflowOutputs:");
            if (this.workflowOutputs == null) {
                sb.append("null");
            } else {
                sb.append(this.workflowOutputs);
            }
            first = false;
        }
        if (this.isSetCreationTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("creationTime:");
            sb.append(this.creationTime);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetTemplateId()) {
            throw new TProtocolException("Required field 'templateId' is unset! Struct:" + this.toString());
        }
        if (!this.isSetName()) {
            throw new TProtocolException("Required field 'name' is unset! Struct:" + this.toString());
        }
        if (!this.isSetGraph()) {
            throw new TProtocolException("Required field 'graph' is unset! Struct:" + this.toString());
        }
        if (!this.isSetGatewayId()) {
            throw new TProtocolException("Required field 'gatewayId' is unset! Struct:" + this.toString());
        }
        if (!this.isSetCreatedUser()) {
            throw new TProtocolException("Required field 'createdUser' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new WorkflowModelStandardSchemeFactory());
        schemes.put(TupleScheme.class, new WorkflowModelTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.IMAGE, _Fields.WORKFLOW_INPUTS, _Fields.WORKFLOW_OUTPUTS, _Fields.CREATION_TIME};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TEMPLATE_ID, new FieldMetaData("templateId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.GRAPH, new FieldMetaData("graph", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.GATEWAY_ID, new FieldMetaData("gatewayId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATED_USER, new FieldMetaData("createdUser", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.IMAGE, new FieldMetaData("image", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.WORKFLOW_INPUTS, new FieldMetaData("workflowInputs", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, InputDataObjectType.class))));
        tmpMap.put(_Fields.WORKFLOW_OUTPUTS, new FieldMetaData("workflowOutputs", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, OutputDataObjectType.class))));
        tmpMap.put(_Fields.CREATION_TIME, new FieldMetaData("creationTime", 2, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(WorkflowModel.class, metaDataMap);
    }

    private static class WorkflowModelTupleScheme
    extends TupleScheme<WorkflowModel> {
        private WorkflowModelTupleScheme() {
        }

        public void write(TProtocol prot, WorkflowModel struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.templateId);
            oprot.writeString(struct.name);
            oprot.writeString(struct.graph);
            oprot.writeString(struct.gatewayId);
            oprot.writeString(struct.createdUser);
            BitSet optionals = new BitSet();
            if (struct.isSetImage()) {
                optionals.set(0);
            }
            if (struct.isSetWorkflowInputs()) {
                optionals.set(1);
            }
            if (struct.isSetWorkflowOutputs()) {
                optionals.set(2);
            }
            if (struct.isSetCreationTime()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetImage()) {
                oprot.writeBinary(struct.image);
            }
            if (struct.isSetWorkflowInputs()) {
                oprot.writeI32(struct.workflowInputs.size());
                for (InputDataObjectType _iter8 : struct.workflowInputs) {
                    _iter8.write((TProtocol)oprot);
                }
            }
            if (struct.isSetWorkflowOutputs()) {
                oprot.writeI32(struct.workflowOutputs.size());
                for (OutputDataObjectType _iter9 : struct.workflowOutputs) {
                    _iter9.write((TProtocol)oprot);
                }
            }
            if (struct.isSetCreationTime()) {
                oprot.writeI64(struct.creationTime);
            }
        }

        public void read(TProtocol prot, WorkflowModel struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.templateId = iprot.readString();
            struct.setTemplateIdIsSet(true);
            struct.name = iprot.readString();
            struct.setNameIsSet(true);
            struct.graph = iprot.readString();
            struct.setGraphIsSet(true);
            struct.gatewayId = iprot.readString();
            struct.setGatewayIdIsSet(true);
            struct.createdUser = iprot.readString();
            struct.setCreatedUserIsSet(true);
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.image = iprot.readBinary();
                struct.setImageIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list10 = new TList(12, iprot.readI32());
                struct.workflowInputs = new ArrayList(_list10.size);
                for (int _i12 = 0; _i12 < _list10.size; ++_i12) {
                    InputDataObjectType _elem11 = new InputDataObjectType();
                    _elem11.read((TProtocol)iprot);
                    struct.workflowInputs.add(_elem11);
                }
                struct.setWorkflowInputsIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list13 = new TList(12, iprot.readI32());
                struct.workflowOutputs = new ArrayList(_list13.size);
                for (int _i15 = 0; _i15 < _list13.size; ++_i15) {
                    OutputDataObjectType _elem14 = new OutputDataObjectType();
                    _elem14.read((TProtocol)iprot);
                    struct.workflowOutputs.add(_elem14);
                }
                struct.setWorkflowOutputsIsSet(true);
            }
            if (incoming.get(3)) {
                struct.creationTime = iprot.readI64();
                struct.setCreationTimeIsSet(true);
            }
        }
    }

    private static class WorkflowModelTupleSchemeFactory
    implements SchemeFactory {
        private WorkflowModelTupleSchemeFactory() {
        }

        public WorkflowModelTupleScheme getScheme() {
            return new WorkflowModelTupleScheme();
        }
    }

    private static class WorkflowModelStandardScheme
    extends StandardScheme<WorkflowModel> {
        private WorkflowModelStandardScheme() {
        }

        public void read(TProtocol iprot, WorkflowModel struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.templateId = iprot.readString();
                            struct.setTemplateIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.name = iprot.readString();
                            struct.setNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.graph = iprot.readString();
                            struct.setGraphIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.gatewayId = iprot.readString();
                            struct.setGatewayIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.createdUser = iprot.readString();
                            struct.setCreatedUserIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.image = iprot.readBinary();
                            struct.setImageIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.workflowInputs = new ArrayList(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                InputDataObjectType _elem1 = new InputDataObjectType();
                                _elem1.read(iprot);
                                struct.workflowInputs.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setWorkflowInputsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 15) {
                            TList _list3 = iprot.readListBegin();
                            struct.workflowOutputs = new ArrayList(_list3.size);
                            for (int _i5 = 0; _i5 < _list3.size; ++_i5) {
                                OutputDataObjectType _elem4 = new OutputDataObjectType();
                                _elem4.read(iprot);
                                struct.workflowOutputs.add(_elem4);
                            }
                            iprot.readListEnd();
                            struct.setWorkflowOutputsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.creationTime = iprot.readI64();
                            struct.setCreationTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, WorkflowModel struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.templateId != null) {
                oprot.writeFieldBegin(TEMPLATE_ID_FIELD_DESC);
                oprot.writeString(struct.templateId);
                oprot.writeFieldEnd();
            }
            if (struct.name != null) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                oprot.writeString(struct.name);
                oprot.writeFieldEnd();
            }
            if (struct.graph != null) {
                oprot.writeFieldBegin(GRAPH_FIELD_DESC);
                oprot.writeString(struct.graph);
                oprot.writeFieldEnd();
            }
            if (struct.gatewayId != null) {
                oprot.writeFieldBegin(GATEWAY_ID_FIELD_DESC);
                oprot.writeString(struct.gatewayId);
                oprot.writeFieldEnd();
            }
            if (struct.createdUser != null) {
                oprot.writeFieldBegin(CREATED_USER_FIELD_DESC);
                oprot.writeString(struct.createdUser);
                oprot.writeFieldEnd();
            }
            if (struct.image != null && struct.isSetImage()) {
                oprot.writeFieldBegin(IMAGE_FIELD_DESC);
                oprot.writeBinary(struct.image);
                oprot.writeFieldEnd();
            }
            if (struct.workflowInputs != null && struct.isSetWorkflowInputs()) {
                oprot.writeFieldBegin(WORKFLOW_INPUTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.workflowInputs.size()));
                for (InputDataObjectType _iter6 : struct.workflowInputs) {
                    _iter6.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.workflowOutputs != null && struct.isSetWorkflowOutputs()) {
                oprot.writeFieldBegin(WORKFLOW_OUTPUTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.workflowOutputs.size()));
                for (OutputDataObjectType _iter7 : struct.workflowOutputs) {
                    _iter7.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetCreationTime()) {
                oprot.writeFieldBegin(CREATION_TIME_FIELD_DESC);
                oprot.writeI64(struct.creationTime);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class WorkflowModelStandardSchemeFactory
    implements SchemeFactory {
        private WorkflowModelStandardSchemeFactory() {
        }

        public WorkflowModelStandardScheme getScheme() {
            return new WorkflowModelStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TEMPLATE_ID(1, "templateId"),
        NAME(2, "name"),
        GRAPH(3, "graph"),
        GATEWAY_ID(4, "gatewayId"),
        CREATED_USER(5, "createdUser"),
        IMAGE(6, "image"),
        WORKFLOW_INPUTS(7, "workflowInputs"),
        WORKFLOW_OUTPUTS(8, "workflowOutputs"),
        CREATION_TIME(9, "creationTime");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TEMPLATE_ID;
                }
                case 2: {
                    return NAME;
                }
                case 3: {
                    return GRAPH;
                }
                case 4: {
                    return GATEWAY_ID;
                }
                case 5: {
                    return CREATED_USER;
                }
                case 6: {
                    return IMAGE;
                }
                case 7: {
                    return WORKFLOW_INPUTS;
                }
                case 8: {
                    return WORKFLOW_OUTPUTS;
                }
                case 9: {
                    return CREATION_TIME;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

