/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.dao.LogsDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.pagination.PaginationConstants;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.LogRecord;

public class JDBCLogsDAO
implements LogsDAO {
    private static final Log log = LogFactory.getLog(JDBCLogsDAO.class);
    private String enableApiPagination = PaginationConstants.ENABLE_API_PAGINATE;

    @Override
    public void saveLogBatch(LogRecord[] logRecords) throws RegistryException {
        Statement s = null;
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            String sql = "INSERT INTO REG_LOG (REG_PATH, REG_USER_ID, REG_LOGGED_TIME, REG_ACTION, REG_ACTION_DATA, REG_TENANT_ID) VALUES (?, ?, ?, ?, ?, ?)";
            s = conn.prepareStatement(sql);
            for (LogRecord logRecord : logRecords) {
                s.clearParameters();
                s.setString(1, logRecord.getResourcePath());
                s.setString(2, logRecord.getUserName());
                s.setTimestamp(3, new Timestamp(logRecord.getTimestamp().getTime()));
                s.setInt(4, logRecord.getAction());
                s.setString(5, logRecord.getActionData());
                s.setInt(6, logRecord.getTenantId());
                s.addBatch();
            }
            int[] status = s.executeBatch();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully added " + status.length + " log records."));
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                log.error((Object)"Failed to rollback log insertion.", (Throwable)e);
            }
            String msg = "Failed to update log batch records . " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    private Connection getDBConnection() throws SQLException, RegistryException {
        DataAccessManager dataAccessManager = CurrentSession.getUserRegistry() != null && CurrentSession.getUserRegistry().getRegistryContext() != null ? CurrentSession.getUserRegistry().getRegistryContext().getDataAccessManager() : RegistryContext.getBaseInstance().getDataAccessManager();
        if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
            String msg = "Failed to get logs. Invalid data access manager.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        DataSource dataSource = ((JDBCDataAccessManager)dataAccessManager).getDataSource();
        Connection conn = dataSource.getConnection();
        if (conn.getTransactionIsolation() != 2) {
            conn.setTransactionIsolation(2);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getLogs(String resourcePath, int action, String userName, Date from, Date to, boolean descending) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        try {
            String dbName = conn.getMetaData().getDatabaseProductName();
            if (dbName.contains("Microsoft") || dbName.equals("Oracle")) {
                this.enableApiPagination = "false";
            }
        }
        catch (SQLException e) {
            throw new RegistryException("Failed to get Database product name ", e);
        }
        if (conn == null) {
            log.fatal((Object)"Failed to get Logs. Communications link failure. The connection to the database could not be acquired.");
            throw new RegistryException("Failed to get Logs. Communications link failure. The connection to the database could not be acquired.");
        }
        PreparedStatement s = null;
        ResultSet results = null;
        boolean paginated = false;
        int start = 0;
        int count = 0;
        String sortOrder = "";
        String sortBy = "";
        MessageContext messageContext = null;
        if ((this.enableApiPagination == null || this.enableApiPagination.equals("true")) && (messageContext = MessageContext.getCurrentMessageContext()) != null && PaginationUtils.isPaginationHeadersExist(messageContext)) {
            PaginationContext paginationContext = PaginationUtils.initPaginationContext(messageContext);
            start = paginationContext.getStart();
            count = paginationContext.getCount();
            if (start == 0) {
                start = 1;
            }
            sortBy = paginationContext.getSortBy();
            sortOrder = paginationContext.getSortOrder();
            paginated = true;
        }
        String sql = "SELECT REG_PATH, REG_USER_ID, REG_LOGGED_TIME, REG_ACTION, REG_ACTION_DATA FROM REG_LOG";
        boolean queryStarted = false;
        sql = this.addWherePart(resourcePath, queryStarted, sql, userName, from, to, action);
        if (descending) {
            sql = sql + " ORDER BY REG_LOGGED_TIME DESC";
        }
        try {
            s = this.enableApiPagination == null || this.enableApiPagination.equals("true") ? conn.prepareStatement(sql, 1004, 1008) : conn.prepareStatement(sql);
            int paramNumber = 1;
            if (resourcePath != null) {
                s.setString(paramNumber, resourcePath);
                ++paramNumber;
            }
            if (userName != null) {
                s.setString(paramNumber, userName);
                ++paramNumber;
            }
            if (from != null) {
                s.setTimestamp(paramNumber, new Timestamp(from.getTime()));
                ++paramNumber;
            }
            if (to != null) {
                s.setTimestamp(paramNumber, new Timestamp(to.getTime()));
                ++paramNumber;
            }
            if (action != -1) {
                s.setInt(paramNumber, action);
                ++paramNumber;
            }
            s.setInt(paramNumber, CurrentSession.getTenantId());
            results = s.executeQuery();
            List<Object> resultList = new ArrayList<LogEntry>();
            if (paginated) {
                if (results.relative(start)) {
                    results.previous();
                    for (int i = 0; results.next() && i < count; ++i) {
                        resultList.add((Object)this.getLogEntry(results));
                    }
                } else {
                    log.debug((Object)"start index doesn't exist in the result set");
                }
                if (results.last()) {
                    log.debug((Object)"cursor move to the last index of result set");
                } else {
                    log.debug((Object)"cursor doesn't move to the last index of result set");
                }
                PaginationUtils.setRowCount(messageContext, Integer.toString(results.getRow()));
            } else {
                while (results.next()) {
                    resultList.add((Object)this.getLogEntry(results));
                }
                LogEntry[] logEntries = JDBCLogsDAO.getPaginatedLogs(resultList.toArray(new LogEntry[resultList.size()]));
                resultList = Arrays.asList(logEntries);
            }
            List<Object> list = resultList;
            return list;
        }
        catch (SQLException e) {
            String msg = "Failed to get logs. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogEntry[] getPaginatedLogs(LogEntry[] logEntries) {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null && PaginationUtils.isPaginationHeadersExist(messageContext)) {
            int rowCount = logEntries.length;
            try {
                LogEntry[] paginatedResult;
                PaginationUtils.setRowCount(messageContext, Integer.toString(rowCount));
                PaginationContext paginationContext = PaginationUtils.initPaginationContext(messageContext);
                int start = paginationContext.getStart();
                int count = paginationContext.getCount();
                int startIndex = start == 1 ? 0 : start;
                if (rowCount < start + count) {
                    paginatedResult = new LogEntry[rowCount - startIndex];
                    System.arraycopy(logEntries, startIndex, paginatedResult, 0, rowCount - startIndex);
                } else {
                    paginatedResult = new LogEntry[count];
                    System.arraycopy(logEntries, startIndex, paginatedResult, 0, count);
                }
                LogEntry[] logEntryArray = paginatedResult;
                return logEntryArray;
            }
            finally {
                PaginationContext.destroy();
            }
        }
        return logEntries;
    }

    private LogEntry getLogEntry(ResultSet results) throws SQLException {
        LogEntry logEntry = new LogEntry();
        logEntry.setResourcePath(results.getString("REG_PATH"));
        logEntry.setUserName(results.getString("REG_USER_ID"));
        logEntry.setDate(new Date(results.getTimestamp("REG_LOGGED_TIME").getTime()));
        logEntry.setAction(results.getInt("REG_ACTION"));
        logEntry.setActionData(results.getString("REG_ACTION_DATA"));
        return logEntry;
    }

    private String addWherePart(String resourcePath, boolean queryStarted, String sql, String userName, Date from, Date to, int action) {
        if (resourcePath != null) {
            if (queryStarted) {
                sql = sql + " AND REG_PATH=?";
            } else {
                sql = sql + " WHERE REG_PATH=?";
                queryStarted = true;
            }
        }
        if (userName != null) {
            if (queryStarted) {
                sql = sql + "  AND REG_USER_ID=?";
            } else {
                sql = sql + "  WHERE REG_USER_ID=?";
                queryStarted = true;
            }
        }
        if (from != null) {
            if (queryStarted) {
                sql = sql + " AND REG_LOGGED_TIME>?";
            } else {
                sql = sql + " WHERE REG_LOGGED_TIME>?";
                queryStarted = true;
            }
        }
        if (to != null) {
            if (queryStarted) {
                sql = sql + " AND REG_LOGGED_TIME<?";
            } else {
                sql = sql + " WHERE REG_LOGGED_TIME<?";
                queryStarted = true;
            }
        }
        if (action != -1) {
            if (queryStarted) {
                sql = sql + " AND REG_ACTION=?";
            } else {
                sql = sql + " WHERE REG_ACTION=?";
                queryStarted = true;
            }
        }
        sql = queryStarted ? sql + " AND REG_TENANT_ID=?" : sql + " WHERE REG_TENANT_ID=?";
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry[] getLogs(String resourcePath, int action, String userName, Date from, Date to, boolean descending, int start, int pageLen, DataAccessManager dataAccessManager) throws RegistryException {
        String sql = "SELECT REG_PATH, REG_USER_ID, REG_LOGGED_TIME, REG_ACTION, REG_ACTION_DATA FROM REG_LOG";
        boolean queryStarted = false;
        sql = this.addWherePart(resourcePath, queryStarted, sql, userName, from, to, action);
        if (descending) {
            sql = sql + " ORDER BY REG_LOGGED_TIME DESC";
        }
        Connection conn = null;
        PreparedStatement s = null;
        ResultSet results = null;
        if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
            String msg = "Failed to get logs. Invalid data access manager.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        DataSource dataSource = ((JDBCDataAccessManager)dataAccessManager).getDataSource();
        try {
            conn = dataSource.getConnection();
            s = conn.prepareStatement(sql);
            int paramNumber = 1;
            if (resourcePath != null) {
                s.setString(paramNumber, resourcePath);
                ++paramNumber;
            }
            if (userName != null) {
                s.setString(paramNumber, userName);
                ++paramNumber;
            }
            if (from != null) {
                s.setTimestamp(paramNumber, new Timestamp(from.getTime()));
                ++paramNumber;
            }
            if (to != null) {
                s.setTimestamp(paramNumber, new Timestamp(to.getTime()));
                ++paramNumber;
            }
            if (action != -1) {
                s.setInt(paramNumber, action);
                ++paramNumber;
            }
            s.setInt(paramNumber, CurrentSession.getTenantId());
            results = s.executeQuery();
            ArrayList<LogEntry> resultList = new ArrayList<LogEntry>();
            int current = 0;
            while (results.next()) {
                if (current >= start && (pageLen == -1 || current < start + pageLen)) {
                    LogEntry logEntry = new LogEntry();
                    logEntry.setResourcePath(results.getString("REG_PATH"));
                    logEntry.setUserName(results.getString("REG_USER_ID"));
                    logEntry.setDate(new Date(results.getTimestamp("REG_LOGGED_TIME").getTime()));
                    logEntry.setAction(results.getInt("REG_ACTION"));
                    logEntry.setActionData(results.getString("REG_ACTION_DATA"));
                    resultList.add(logEntry);
                }
                ++current;
            }
            LogEntry[] logEntryArray = resultList.toArray(new LogEntry[resultList.size()]);
            return logEntryArray;
        }
        catch (SQLException e) {
            String msg = "Failed to get logs. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry[] getLogs(String resourcePath, int action, String userName, Date from, Date to, boolean descending, DataAccessManager dataAccessManager) throws RegistryException {
        String sql = "SELECT REG_PATH, REG_USER_ID, REG_LOGGED_TIME, REG_ACTION, REG_ACTION_DATA FROM REG_LOG";
        boolean queryStarted = false;
        sql = this.addWherePart(resourcePath, queryStarted, sql, userName, from, to, action);
        if (descending) {
            sql = sql + " ORDER BY REG_LOGGED_TIME DESC";
        }
        PreparedStatement s = null;
        ResultSet results = null;
        Connection conn = null;
        if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
            String msg = "Failed to get logs. Invalid data access manager.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        DataSource dataSource = ((JDBCDataAccessManager)dataAccessManager).getDataSource();
        try {
            conn = dataSource.getConnection();
            s = conn.prepareStatement(sql);
            int paramNumber = 1;
            if (resourcePath != null) {
                s.setString(paramNumber, resourcePath);
                ++paramNumber;
            }
            if (userName != null) {
                s.setString(paramNumber, userName);
                ++paramNumber;
            }
            if (from != null) {
                s.setTimestamp(paramNumber, new Timestamp(from.getTime()));
                ++paramNumber;
            }
            if (to != null) {
                s.setTimestamp(paramNumber, new Timestamp(to.getTime()));
                ++paramNumber;
            }
            if (action != -1) {
                s.setInt(paramNumber, action);
                ++paramNumber;
            }
            s.setInt(paramNumber, CurrentSession.getTenantId());
            results = s.executeQuery();
            ArrayList<LogEntry> resultList = new ArrayList<LogEntry>();
            while (results.next()) {
                LogEntry logEntry = new LogEntry();
                logEntry.setResourcePath(results.getString("REG_PATH"));
                logEntry.setUserName(results.getString("REG_USER_ID"));
                logEntry.setDate(new Date(results.getTimestamp("REG_LOGGED_TIME").getTime()));
                logEntry.setAction(results.getInt("REG_ACTION"));
                logEntry.setActionData(results.getString("REG_ACTION_DATA"));
                resultList.add(logEntry);
            }
            LogEntry[] logEntryArray = resultList.toArray(new LogEntry[resultList.size()]);
            return logEntryArray;
        }
        catch (SQLException e) {
            String msg = "Failed to get logs. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLogsCount(String resourcePath, int action, String userName, Date from, Date to, boolean descending) throws RegistryException {
        int count = 0;
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        String sql = "SELECT COUNT(*) AS REG_LOG_COUNT FROM REG_LOG";
        boolean queryStarted = false;
        sql = this.addWherePart(resourcePath, queryStarted, sql, userName, from, to, action);
        PreparedStatement s = null;
        ResultSet results = null;
        try {
            s = conn.prepareStatement(sql);
            int paramNumber = 1;
            if (resourcePath != null) {
                s.setString(paramNumber, resourcePath);
                ++paramNumber;
            }
            if (userName != null) {
                s.setString(paramNumber, userName);
                ++paramNumber;
            }
            if (from != null) {
                s.setTimestamp(paramNumber, new Timestamp(from.getTime()));
                ++paramNumber;
            }
            if (to != null) {
                s.setTimestamp(paramNumber, new Timestamp(to.getTime()));
                ++paramNumber;
            }
            if (action != -1) {
                s.setInt(paramNumber, action);
                ++paramNumber;
            }
            s.setInt(paramNumber, CurrentSession.getTenantId());
            results = s.executeQuery();
            if (results.next()) {
                count = results.getInt("REG_LOG_COUNT");
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get logs. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return count;
    }
}

