/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.dialect;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.util.stax.dialect.AbstractStAXDialect;
import org.apache.axiom.util.stax.dialect.NormalizingXMLInputFactoryWrapper;
import org.apache.axiom.util.stax.dialect.StAXDialectUtils;
import org.apache.axiom.util.stax.dialect.WoodstoxOutputFactoryWrapper;
import org.apache.axiom.util.stax.dialect.WoodstoxStreamReaderWrapper;
import org.apache.axiom.util.stax.dialect.WoodstoxStreamWriterWrapper;

class WoodstoxDialect
extends AbstractStAXDialect {
    public static final WoodstoxDialect INSTANCE = new WoodstoxDialect();

    WoodstoxDialect() {
    }

    @Override
    public String getName() {
        return "Woodstox";
    }

    @Override
    public XMLInputFactory enableCDataReporting(XMLInputFactory factory) {
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        return factory;
    }

    @Override
    public XMLInputFactory disallowDoctypeDecl(XMLInputFactory factory) {
        return StAXDialectUtils.disallowDoctypeDecl(factory);
    }

    @Override
    public XMLInputFactory makeThreadSafe(XMLInputFactory factory) {
        return factory;
    }

    @Override
    public XMLOutputFactory makeThreadSafe(XMLOutputFactory factory) {
        return factory;
    }

    @Override
    public XMLStreamReader normalize(XMLStreamReader reader) {
        return new WoodstoxStreamReaderWrapper(reader);
    }

    @Override
    public XMLStreamWriter normalize(XMLStreamWriter writer) {
        return new WoodstoxStreamWriterWrapper(writer);
    }

    @Override
    public XMLInputFactory normalize(XMLInputFactory factory) {
        return new NormalizingXMLInputFactoryWrapper(factory, this);
    }

    @Override
    public XMLOutputFactory normalize(XMLOutputFactory factory) {
        return new WoodstoxOutputFactoryWrapper(factory, this);
    }
}

