/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.internal;

import java.io.File;
import java.lang.management.ManagementPermission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserRealmService;
import org.wso2.carbon.user.core.common.DefaultRealmService;
import org.wso2.carbon.user.core.internal.BundleCheckActivator;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class Activator
extends BundleCheckActivator {
    private static final Log log = LogFactory.getLog(Activator.class);

    @Override
    public void startDeploy(BundleContext bundleContext) throws Exception {
        CarbonContext.getCurrentContext();
        SecurityManager secMan = System.getSecurityManager();
        ServerConfiguration config = ServerConfiguration.getInstance();
        String type = config.getFirstProperty("Security.TrustStore.Type");
        String password = config.getFirstProperty("Security.TrustStore.Password");
        String storeFile = new File(config.getFirstProperty("Security.TrustStore.Location")).getAbsolutePath();
        System.setProperty("javax.net.ssl.trustStore", storeFile);
        System.setProperty("javax.net.ssl.trustStoreType", type);
        System.setProperty("javax.net.ssl.trustStorePassword", password);
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain("carbon.super");
            carbonContext.setTenantId(-1234);
            DefaultRealmService realmService = new DefaultRealmService(bundleContext);
            bundleContext.registerService(new String[]{RealmService.class.getName(), UserRealmService.class.getName()}, (Object)realmService, null);
            DatabaseUtil.logDatabaseConnections();
            UserCoreUtil.setRealmService(realmService);
        }
        catch (Throwable e) {
            String msg = "Cannot start User Manager Core bundle";
            log.error((Object)msg, e);
        }
    }

    @Override
    public String getName() {
        return "UserCore";
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

