/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.common.UserRolesCacheEntry;
import org.wso2.carbon.user.core.common.UserRolesCacheKey;

public class UserRolesCache {
    private static Log log = LogFactory.getLog(UserRolesCache.class);
    private static final String USER_ROLES_CACHE_MANAGER = "USER_ROLES_CACHE_MANAGER";
    private static final String USER_ROLES_CACHE = "USER_ROLES_CACHE";
    private static UserRolesCache userRolesCache = new UserRolesCache();
    private int timeOut = 5;

    private UserRolesCache() {
    }

    public static UserRolesCache getInstance() {
        return userRolesCache;
    }

    private Cache<UserRolesCacheKey, UserRolesCacheEntry> getUserRolesCache() {
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(USER_ROLES_CACHE_MANAGER);
        return cacheManager.getCache(USER_ROLES_CACHE);
    }

    private boolean isCacheNull(Cache<UserRolesCacheKey, UserRolesCacheEntry> cache) {
        if (cache == null) {
            if (log.isDebugEnabled()) {
                StackTraceElement[] elemets = Thread.currentThread().getStackTrace();
                String traceString = "";
                for (int i = 1; i < elemets.length; ++i) {
                    traceString = traceString + elemets[i] + System.getProperty("line.separator");
                }
                log.debug((Object)("USER_ROLES_CACHE doesn't exist in CacheManager:\n" + traceString));
            }
            return true;
        }
        return false;
    }

    public void addToCache(String serverId, int tenantId, String userName, String[] userRoleList) {
        Cache<UserRolesCacheKey, UserRolesCacheEntry> cache = this.getUserRolesCache();
        if (this.isCacheNull(cache)) {
            return;
        }
        UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userName);
        UserRolesCacheEntry userRolesCacheEntry = new UserRolesCacheEntry(userRoleList);
        cache.put((Object)userRolesCacheKey, (Object)userRolesCacheEntry);
    }

    public String[] getRolesListOfUser(String serverId, int tenantId, String userName) {
        Cache<UserRolesCacheKey, UserRolesCacheEntry> cache = this.getUserRolesCache();
        if (this.isCacheNull(cache)) {
            return new String[0];
        }
        UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userName);
        UserRolesCacheEntry userRolesCacheEntry = (UserRolesCacheEntry)cache.get((Object)userRolesCacheKey);
        return userRolesCacheEntry.getUserRolesList();
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public void clearCacheByTenant(int tenantId) {
        Cache<UserRolesCacheKey, UserRolesCacheEntry> cache = this.getUserRolesCache();
        cache.removeAll();
    }

    public void clearCacheEntry(String serverId, int tenantId, String userName) {
        Cache<UserRolesCacheKey, UserRolesCacheEntry> cache = this.getUserRolesCache();
        if (this.isCacheNull(cache)) {
            return;
        }
        UserRolesCacheKey userRolesCacheKey = new UserRolesCacheKey(serverId, tenantId, userName);
        if (cache.containsKey((Object)userRolesCacheKey)) {
            cache.remove((Object)userRolesCacheKey);
        }
    }
}

