/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;

public class RetryPolicies {
    public static final RetryPolicy TRY_ONCE_THEN_FAIL = new TryOnceThenFail();
    public static final RetryPolicy TRY_ONCE_DONT_FAIL = new TryOnceDontFail();
    public static final RetryPolicy RETRY_FOREVER = new RetryForever();

    public static final RetryPolicy retryUpToMaximumCountWithFixedSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithFixedSleep(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryUpToMaximumTimeWithFixedSleep(long maxTime, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumTimeWithFixedSleep(maxTime, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryUpToMaximumCountWithProportionalSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new RetryUpToMaximumCountWithProportionalSleep(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy exponentialBackoffRetry(int maxRetries, long sleepTime, TimeUnit timeUnit) {
        return new ExponentialBackoffRetry(maxRetries, sleepTime, timeUnit);
    }

    public static final RetryPolicy retryByException(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
        return new ExceptionDependentRetry(defaultPolicy, exceptionToPolicyMap);
    }

    public static final RetryPolicy retryByRemoteException(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
        return new RemoteExceptionDependentRetry(defaultPolicy, exceptionToPolicyMap);
    }

    static class ExponentialBackoffRetry
    extends RetryLimited {
        private Random r = new Random();

        public ExponentialBackoffRetry(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return this.sleepTime * (long)this.r.nextInt(1 << retries + 1);
        }
    }

    static class RemoteExceptionDependentRetry
    implements RetryPolicy {
        RetryPolicy defaultPolicy;
        Map<String, RetryPolicy> exceptionNameToPolicyMap;

        public RemoteExceptionDependentRetry(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
            this.defaultPolicy = defaultPolicy;
            this.exceptionNameToPolicyMap = new HashMap<String, RetryPolicy>();
            for (Map.Entry<Class<? extends Exception>, RetryPolicy> e : exceptionToPolicyMap.entrySet()) {
                this.exceptionNameToPolicyMap.put(e.getKey().getName(), e.getValue());
            }
        }

        @Override
        public boolean shouldRetry(Exception e, int retries) throws Exception {
            RetryPolicy policy = null;
            if (e instanceof RemoteException) {
                policy = this.exceptionNameToPolicyMap.get(((RemoteException)e).getClassName());
            }
            if (policy == null) {
                policy = this.defaultPolicy;
            }
            return policy.shouldRetry(e, retries);
        }
    }

    static class ExceptionDependentRetry
    implements RetryPolicy {
        RetryPolicy defaultPolicy;
        Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap;

        public ExceptionDependentRetry(RetryPolicy defaultPolicy, Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap) {
            this.defaultPolicy = defaultPolicy;
            this.exceptionToPolicyMap = exceptionToPolicyMap;
        }

        @Override
        public boolean shouldRetry(Exception e, int retries) throws Exception {
            RetryPolicy policy = this.exceptionToPolicyMap.get(e.getClass());
            if (policy == null) {
                policy = this.defaultPolicy;
            }
            return policy.shouldRetry(e, retries);
        }
    }

    static class RetryUpToMaximumCountWithProportionalSleep
    extends RetryLimited {
        public RetryUpToMaximumCountWithProportionalSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return this.sleepTime * (long)(retries + 1);
        }
    }

    static class RetryUpToMaximumTimeWithFixedSleep
    extends RetryUpToMaximumCountWithFixedSleep {
        public RetryUpToMaximumTimeWithFixedSleep(long maxTime, long sleepTime, TimeUnit timeUnit) {
            super((int)(maxTime / sleepTime), sleepTime, timeUnit);
        }
    }

    static class RetryUpToMaximumCountWithFixedSleep
    extends RetryLimited {
        public RetryUpToMaximumCountWithFixedSleep(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            super(maxRetries, sleepTime, timeUnit);
        }

        @Override
        protected long calculateSleepTime(int retries) {
            return this.sleepTime;
        }
    }

    static abstract class RetryLimited
    implements RetryPolicy {
        int maxRetries;
        long sleepTime;
        TimeUnit timeUnit;

        public RetryLimited(int maxRetries, long sleepTime, TimeUnit timeUnit) {
            this.maxRetries = maxRetries;
            this.sleepTime = sleepTime;
            this.timeUnit = timeUnit;
        }

        @Override
        public boolean shouldRetry(Exception e, int retries) throws Exception {
            if (retries >= this.maxRetries) {
                throw e;
            }
            try {
                this.timeUnit.sleep(this.calculateSleepTime(retries));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }

        protected abstract long calculateSleepTime(int var1);
    }

    static class RetryForever
    implements RetryPolicy {
        RetryForever() {
        }

        @Override
        public boolean shouldRetry(Exception e, int retries) throws Exception {
            return true;
        }
    }

    static class TryOnceDontFail
    implements RetryPolicy {
        TryOnceDontFail() {
        }

        @Override
        public boolean shouldRetry(Exception e, int retries) throws Exception {
            return false;
        }
    }

    static class TryOnceThenFail
    implements RetryPolicy {
        TryOnceThenFail() {
        }

        @Override
        public boolean shouldRetry(Exception e, int retries) throws Exception {
            throw e;
        }
    }
}

