/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;
import java.util.HashSet;

public class MapStoreDeleteProcessor
implements ScheduledEntryProcessor<Data, Object> {
    private final MapContainer mapContainer;
    private final MapService mapService;

    public MapStoreDeleteProcessor(MapContainer mapContainer, MapService mapService) {
        this.mapContainer = mapContainer;
        this.mapService = mapService;
    }

    private Exception tryDelete(EntryTaskScheduler<Data, Object> scheduler, ScheduledEntry<Data, Object> entry) {
        Exception exception = null;
        try {
            this.mapContainer.getStore().delete(this.mapService.toObject(entry.getKey()));
        }
        catch (Exception e) {
            exception = e;
            scheduler.schedule(this.mapContainer.getWriteDelayMillis(), entry.getKey(), entry.getValue());
        }
        return exception;
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> entries) {
        if (entries.isEmpty()) {
            return;
        }
        ILogger logger = this.mapService.getNodeEngine().getLogger(this.getClass());
        if (entries.size() == 1) {
            ScheduledEntry<Data, Object> entry = entries.iterator().next();
            Exception e = this.tryDelete(scheduler, entry);
            if (e != null) {
                logger.severe(e);
            }
        } else {
            HashSet<Object> keys = new HashSet<Object>();
            Exception e = null;
            for (ScheduledEntry<Data, Object> entry : entries) {
                keys.add(this.mapService.toObject(entry.getKey()));
            }
            try {
                this.mapContainer.getStore().deleteAll(keys);
            }
            catch (Exception ex) {
                for (ScheduledEntry<Data, Object> entry : entries) {
                    Exception temp = this.tryDelete(scheduler, entry);
                    if (temp == null) continue;
                    e = temp;
                }
            }
            if (e != null) {
                logger.severe(e);
            }
        }
    }
}

