/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.CallbackLookup;
import org.apache.ws.security.message.DOMCallbackLookup;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.str.SecurityTokenRefSTRParser;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceListProcessor
implements Processor {
    private static Log log = LogFactory.getLog(ReferenceListProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found reference list element");
        }
        List<WSDataRef> dataRefs = this.handleReferenceList(elem, data, wsDocInfo);
        WSSecurityEngineResult result = new WSSecurityEngineResult(4, dataRefs);
        result.put("id", elem.getAttributeNS(null, "Id"));
        wsDocInfo.addTokenElement(elem);
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    private List<WSDataRef> handleReferenceList(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        ArrayList<WSDataRef> dataRefs = new ArrayList<WSDataRef>();
        Element wsseHeaderElement = wsDocInfo.getSecurityHeader();
        boolean asymBinding = WSSecurityUtil.getDirectChildElement(wsseHeaderElement, "EncryptedKey", "http://www.w3.org/2001/04/xmlenc#") != null;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType() || !"http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || !"DataReference".equals(node.getLocalName())) continue;
            String dataRefURI = ((Element)node).getAttribute("URI");
            if (dataRefURI.charAt(0) == '#') {
                dataRefURI = dataRefURI.substring(1);
            }
            if (wsDocInfo.getResultByTag(4, dataRefURI) != null) continue;
            WSDataRef dataRef = this.decryptDataRefEmbedded(elem.getOwnerDocument(), dataRefURI, data, wsDocInfo, asymBinding);
            dataRefs.add(dataRef);
        }
        return dataRefs;
    }

    private WSDataRef decryptDataRefEmbedded(Document doc, String dataRefURI, RequestData data, WSDocInfo wsDocInfo, boolean asymBinding) throws WSSecurityException {
        Element encryptedDataElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found data reference: " + dataRefURI));
        }
        if ((encryptedDataElement = ReferenceListProcessor.findEncryptedDataElement(doc, wsDocInfo, dataRefURI)) != null && asymBinding && data.isRequireSignedEncryptedDataElements()) {
            WSSecurityUtil.verifySignedElement(encryptedDataElement, doc, wsDocInfo.getSecurityHeader());
        }
        String symEncAlgo = X509Util.getEncAlgo(encryptedDataElement);
        Element keyInfoElement = WSSecurityUtil.getDirectChildElement(encryptedDataElement, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfoElement == null) {
            throw new WSSecurityException(3, "noKeyinfo");
        }
        if (data.getWssConfig().isWsiBSPCompliant()) {
            ReferenceListProcessor.checkBSPCompliance(keyInfoElement, symEncAlgo);
        }
        Element secRefToken = WSSecurityUtil.getDirectChildElement(keyInfoElement, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SecretKey symmetricKey = null;
        if (secRefToken == null) {
            symmetricKey = X509Util.getSharedKey(keyInfoElement, symEncAlgo, data.getCallbackHandler());
        } else {
            SecurityTokenRefSTRParser strParser = new SecurityTokenRefSTRParser();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("signature_method", symEncAlgo);
            strParser.parseSecurityTokenReference(secRefToken, data, wsDocInfo, parameters);
            byte[] secretKey = strParser.getSecretKey();
            symmetricKey = WSSecurityUtil.prepareSecretKey(symEncAlgo, secretKey);
        }
        return ReferenceListProcessor.decryptEncryptedData(doc, dataRefURI, encryptedDataElement, symmetricKey, symEncAlgo);
    }

    private static void checkBSPCompliance(Element keyInfoElement, String encAlgo) throws WSSecurityException {
        int result = 0;
        Node child = null;
        for (Node node = keyInfoElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType()) continue;
            ++result;
            child = (Element)node;
        }
        if (result != 1) {
            throw new WSSecurityException(3, "invalidDataRef");
        }
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI()) || !"SecurityTokenReference".equals(child.getLocalName())) {
            throw new WSSecurityException(3, "noSecTokRef");
        }
        if (encAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (!("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(encAlgo))) {
            throw new WSSecurityException(3, "badEncAlgo", new Object[]{encAlgo});
        }
    }

    public static Element findEncryptedDataElement(Document doc, WSDocInfo wsDocInfo, String dataRefURI) throws WSSecurityException {
        Element encryptedDataElement;
        CallbackLookup callbackLookup = wsDocInfo.getCallbackLookup();
        if (callbackLookup == null) {
            callbackLookup = new DOMCallbackLookup(doc);
        }
        if ((encryptedDataElement = callbackLookup.getElement(dataRefURI, null, true)) == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        if (encryptedDataElement.getLocalName().equals("EncryptedHeader") && encryptedDataElement.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
            Node child;
            for (child = encryptedDataElement.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
            }
            return (Element)child;
        }
        return encryptedDataElement;
    }

    public static WSDataRef decryptEncryptedData(Document doc, String dataRefURI, Element encData, SecretKey symmetricKey, String symEncAlgo) throws WSSecurityException {
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.setSecureValidation(true);
            xmlCipher.init(2, (Key)symmetricKey);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(2, null, null, ex);
        }
        WSDataRef dataRef = new WSDataRef();
        dataRef.setWsuId(dataRefURI);
        dataRef.setAlgorithm(symEncAlgo);
        boolean content = X509Util.isContent(encData);
        dataRef.setContent(content);
        Node parent = encData.getParentNode();
        Node previousSibling = encData.getPreviousSibling();
        if (content) {
            encData = (Element)encData.getParentNode();
            parent = encData.getParentNode();
        }
        try {
            xmlCipher.doFinal(doc, encData, content);
        }
        catch (Exception ex) {
            throw new WSSecurityException(6, null, null, ex);
        }
        if (parent.getLocalName().equals("EncryptedHeader") && parent.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
            Node decryptedHeader = parent.getFirstChild();
            Node soapHeader = parent.getParentNode();
            soapHeader.replaceChild(decryptedHeader, parent);
            dataRef.setProtectedElement((Element)decryptedHeader);
            dataRef.setXpath(ReferenceListProcessor.getXPath(decryptedHeader));
        } else if (content) {
            dataRef.setProtectedElement(encData);
            dataRef.setXpath(ReferenceListProcessor.getXPath(encData));
        } else {
            Node decryptedNode = previousSibling == null ? parent.getFirstChild() : previousSibling.getNextSibling();
            if (decryptedNode != null && 1 == decryptedNode.getNodeType()) {
                dataRef.setProtectedElement((Element)decryptedNode);
            }
            dataRef.setXpath(ReferenceListProcessor.getXPath(decryptedNode));
        }
        return dataRef;
    }

    public String getId() {
        return null;
    }

    public static String getXPath(Node decryptedNode) {
        if (decryptedNode == null) {
            return null;
        }
        String result = "";
        if (1 == decryptedNode.getNodeType()) {
            result = decryptedNode.getNodeName();
            result = ReferenceListProcessor.prependFullPath(result, decryptedNode.getParentNode());
        } else if (2 == decryptedNode.getNodeType()) {
            result = "@" + decryptedNode.getNodeName();
            result = ReferenceListProcessor.prependFullPath(result, ((Attr)decryptedNode).getOwnerElement());
        } else {
            return null;
        }
        return result;
    }

    private static String prependFullPath(String xpath, Node node) {
        if (node == null) {
            return null;
        }
        if (1 == node.getNodeType()) {
            xpath = node.getNodeName() + "/" + xpath;
            return ReferenceListProcessor.prependFullPath(xpath, node.getParentNode());
        }
        if (9 == node.getNodeType()) {
            return "/" + xpath;
        }
        return ReferenceListProcessor.prependFullPath(xpath, node.getParentNode());
    }
}

