/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.pdfbox.encryption.ARCFour;
import org.pdfbox.exceptions.CryptographyException;

public final class PDFEncryption {
    private ARCFour rc4 = new ARCFour();
    public static final byte[] ENCRYPT_PADDING = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};

    public final void encryptData(long objectNumber, long genNumber, byte[] key, InputStream data, OutputStream output) throws CryptographyException, IOException {
        byte[] newKey = new byte[key.length + 5];
        System.arraycopy(key, 0, newKey, 0, key.length);
        newKey[newKey.length - 5] = (byte)(objectNumber & 0xFFL);
        newKey[newKey.length - 4] = (byte)(objectNumber >> 8 & 0xFFL);
        newKey[newKey.length - 3] = (byte)(objectNumber >> 16 & 0xFFL);
        newKey[newKey.length - 2] = (byte)(genNumber & 0xFFL);
        newKey[newKey.length - 1] = (byte)(genNumber >> 8 & 0xFFL);
        byte[] digestedKey = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            digestedKey = md.digest(newKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
        int length = Math.min(newKey.length, 16);
        byte[] finalKey = new byte[length];
        System.arraycopy(digestedKey, 0, finalKey, 0, length);
        this.rc4.setKey(finalKey);
        this.rc4.write(data, output);
        output.flush();
    }

    public final byte[] getUserPassword(byte[] ownerPassword, byte[] o, int revision, long length) throws CryptographyException, IOException {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] ownerPadded = this.truncateOrPad(ownerPassword);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(ownerPadded);
            byte[] digest = md.digest();
            if (revision == 3 || revision == 4) {
                for (int i = 0; i < 50; ++i) {
                    md.reset();
                    md.update(digest);
                    digest = md.digest();
                }
            }
            if (revision == 2 && length != 5L) {
                throw new CryptographyException("Error: Expected length=5 actual=" + length);
            }
            byte[] rc4Key = new byte[(int)length];
            System.arraycopy(digest, 0, rc4Key, 0, (int)length);
            if (revision == 2) {
                this.rc4.setKey(rc4Key);
                this.rc4.write(o, (OutputStream)result);
            } else if (revision == 3 || revision == 4) {
                byte[] iterationKey = new byte[rc4Key.length];
                byte[] otemp = new byte[o.length];
                System.arraycopy(o, 0, otemp, 0, o.length);
                this.rc4.write(o, (OutputStream)result);
                for (int i = 19; i >= 0; --i) {
                    System.arraycopy(rc4Key, 0, iterationKey, 0, rc4Key.length);
                    for (int j = 0; j < iterationKey.length; ++j) {
                        iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
                    }
                    this.rc4.setKey(iterationKey);
                    result.reset();
                    this.rc4.write(otemp, (OutputStream)result);
                    otemp = result.toByteArray();
                }
            }
            return result.toByteArray();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
    }

    public final boolean isOwnerPassword(byte[] ownerPassword, byte[] u, byte[] o, int permissions, byte[] id, int revision, int length) throws CryptographyException, IOException {
        byte[] userPassword = this.getUserPassword(ownerPassword, o, revision, length);
        return this.isUserPassword(userPassword, u, o, permissions, id, revision, length);
    }

    public final boolean isUserPassword(byte[] password, byte[] u, byte[] o, int permissions, byte[] id, int revision, int length) throws CryptographyException, IOException {
        boolean matches = false;
        byte[] computedValue = this.computeUserPassword(password, o, permissions, id, revision, length);
        if (revision == 2) {
            matches = this.arraysEqual(u, computedValue);
        } else if (revision == 3 || revision == 4) {
            matches = this.arraysEqual(u, computedValue, 16);
        }
        return matches;
    }

    private final boolean arraysEqual(byte[] first, byte[] second, int count) {
        boolean equal = first.length >= count && second.length >= count;
        for (int i = 0; i < count && equal; ++i) {
            equal = first[i] == second[i];
        }
        return equal;
    }

    private final boolean arraysEqual(byte[] first, byte[] second) {
        boolean equal = first.length == second.length;
        for (int i = 0; i < first.length && equal; ++i) {
            equal = first[i] == second[i];
        }
        return equal;
    }

    public final byte[] computeUserPassword(byte[] password, byte[] o, int permissions, byte[] id, int revision, int length) throws CryptographyException, IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] encryptionKey = this.computeEncryptedKey(password, o, permissions, id, revision, length);
        if (revision == 2) {
            this.rc4.setKey(encryptionKey);
            this.rc4.write(ENCRYPT_PADDING, (OutputStream)result);
        } else if (revision == 3 || revision == 4) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(ENCRYPT_PADDING);
                md.update(id);
                result.write(md.digest());
                byte[] iterationKey = new byte[encryptionKey.length];
                for (int i = 0; i < 20; ++i) {
                    System.arraycopy(encryptionKey, 0, iterationKey, 0, iterationKey.length);
                    for (int j = 0; j < iterationKey.length; ++j) {
                        iterationKey[j] = (byte)(iterationKey[j] ^ i);
                    }
                    this.rc4.setKey(iterationKey);
                    ByteArrayInputStream input = new ByteArrayInputStream(result.toByteArray());
                    result.reset();
                    this.rc4.write(input, (OutputStream)result);
                }
                byte[] finalResult = new byte[32];
                System.arraycopy(result.toByteArray(), 0, finalResult, 0, 16);
                System.arraycopy(ENCRYPT_PADDING, 0, finalResult, 16, 16);
                result.reset();
                result.write(finalResult);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptographyException(e);
            }
        }
        return result.toByteArray();
    }

    public final byte[] computeEncryptedKey(byte[] password, byte[] o, int permissions, byte[] id, int revision, int length) throws CryptographyException {
        byte[] result = new byte[length];
        try {
            byte[] padded = this.truncateOrPad(password);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(padded);
            md.update(o);
            byte zero = (byte)(permissions >>> 0);
            byte one = (byte)(permissions >>> 8);
            byte two = (byte)(permissions >>> 16);
            byte three = (byte)(permissions >>> 24);
            md.update(zero);
            md.update(one);
            md.update(two);
            md.update(three);
            md.update(id);
            byte[] digest = md.digest();
            if (revision == 3 || revision == 4) {
                for (int i = 0; i < 50; ++i) {
                    md.reset();
                    md.update(digest, 0, length);
                    digest = md.digest();
                }
            }
            if (revision == 2 && length != 5) {
                throw new CryptographyException("Error: length should be 5 when revision is two actual=" + length);
            }
            System.arraycopy(digest, 0, result, 0, length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
        return result;
    }

    public final byte[] computeOwnerPassword(byte[] ownerPassword, byte[] userPassword, int revision, int length) throws CryptographyException, IOException {
        try {
            byte[] ownerPadded = this.truncateOrPad(ownerPassword);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(ownerPadded);
            byte[] digest = md.digest();
            if (revision == 3 || revision == 4) {
                for (int i = 0; i < 50; ++i) {
                    md.reset();
                    md.update(digest, 0, length);
                    digest = md.digest();
                }
            }
            if (revision == 2 && length != 5) {
                throw new CryptographyException("Error: Expected length=5 actual=" + length);
            }
            byte[] rc4Key = new byte[length];
            System.arraycopy(digest, 0, rc4Key, 0, length);
            byte[] paddedUser = this.truncateOrPad(userPassword);
            this.rc4.setKey(rc4Key);
            ByteArrayOutputStream crypted = new ByteArrayOutputStream();
            this.rc4.write(new ByteArrayInputStream(paddedUser), (OutputStream)crypted);
            if (revision == 3 || revision == 4) {
                byte[] iterationKey = new byte[rc4Key.length];
                for (int i = 1; i < 20; ++i) {
                    System.arraycopy(rc4Key, 0, iterationKey, 0, rc4Key.length);
                    for (int j = 0; j < iterationKey.length; ++j) {
                        iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
                    }
                    this.rc4.setKey(iterationKey);
                    ByteArrayInputStream input = new ByteArrayInputStream(crypted.toByteArray());
                    crypted.reset();
                    this.rc4.write(input, (OutputStream)crypted);
                }
            }
            return crypted.toByteArray();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e.getMessage());
        }
    }

    private final byte[] truncateOrPad(byte[] password) {
        byte[] padded = new byte[ENCRYPT_PADDING.length];
        int bytesBeforePad = Math.min(password.length, padded.length);
        System.arraycopy(password, 0, padded, 0, bytesBeforePad);
        System.arraycopy(ENCRYPT_PADDING, 0, padded, bytesBeforePad, ENCRYPT_PADDING.length - bytesBeforePad);
        return padded;
    }
}

