/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.readcommitted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.DefaultLuceneSearchEngineHits;
import org.compass.core.lucene.engine.EmptyLuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.manager.LuceneIndexHolder;
import org.compass.core.lucene.engine.transaction.AbstractTransaction;
import org.compass.core.lucene.engine.transaction.readcommitted.BitSetByAliasFilter;
import org.compass.core.lucene.engine.transaction.readcommitted.TransIndexManager;
import org.compass.core.lucene.util.ChainedFilter;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.transaction.context.TransactionalCallable;
import org.compass.core.util.StringUtils;

public class ReadCommittedTransaction
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog(ReadCommittedTransaction.class);
    private TransIndexManager transIndexManager;
    private Map<String, IndexWriter> indexWriterBySubIndex = new HashMap<String, IndexWriter>();
    private BitSetByAliasFilter filter;
    private Map<String, LuceneIndexHolder> indexHoldersBySubIndex = new HashMap<String, LuceneIndexHolder>();

    protected void doBegin() throws SearchEngineException {
        this.transIndexManager = new TransIndexManager(this.searchEngine.getSearchEngineFactory());
        this.transIndexManager.configure(this.searchEngine.getSettings());
        this.filter = new BitSetByAliasFilter();
    }

    protected void doRollback() throws SearchEngineException {
        this.releaseHolders();
        SearchEngineException lastException = null;
        for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
            try {
                entry.getValue().abort();
            }
            catch (IOException e) {
                Directory dir = this.indexManager.getStore().openDirectory(entry.getKey());
                try {
                    if (IndexReader.isLocked(dir)) {
                        IndexReader.unlock(dir);
                    }
                }
                catch (Exception e1) {
                    log.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + entry.getKey() + "]"), (Throwable)e);
                }
                lastException = new SearchEngineException("Failed to rollback sub index [" + entry.getKey() + "]", e);
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    protected void doPrepare() throws SearchEngineException {
        this.releaseHolders();
        if (this.indexManager.supportsConcurrentOperations()) {
            ArrayList prepareCallables = new ArrayList();
            for (String subIndex : this.indexWriterBySubIndex.keySet()) {
                if (!this.transIndexManager.hasTransIndex(subIndex)) continue;
                prepareCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new PrepareCallable(subIndex)));
            }
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(prepareCallables, 1);
        } else {
            for (String subIndex : this.indexWriterBySubIndex.keySet()) {
                if (!this.transIndexManager.hasTransIndex(subIndex)) continue;
                try {
                    new PrepareCallable(subIndex).call();
                }
                catch (SearchEngineException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to prepare transaction for sub index [" + subIndex + "]", e);
                }
            }
        }
    }

    protected void doCommit(boolean onePhase) throws SearchEngineException {
        this.releaseHolders();
        if (onePhase) {
            this.doPrepare();
        }
        if (this.indexManager.supportsConcurrentOperations()) {
            ArrayList commitCallables = new ArrayList();
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                commitCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new CommitCallable(entry.getKey(), entry.getValue(), false)));
            }
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(commitCallables, 1);
        } else {
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                try {
                    new CommitCallable(entry.getKey(), entry.getValue(), false).call();
                }
                catch (SearchEngineException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to commit transaction for sub index [" + entry.getKey() + "]", e);
                }
            }
        }
    }

    protected LuceneSearchEngineInternalSearch doInternalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        if (this.indexHoldersBySubIndex.isEmpty() && !this.transIndexManager.hasTransactions()) {
            return super.doInternalSearch(subIndexes, aliases);
        }
        ArrayList<LuceneIndexHolder> indexHoldersToClose = new ArrayList<LuceneIndexHolder>();
        try {
            String[] calcSubIndexes = this.indexManager.getStore().calcSubIndexes(subIndexes, aliases);
            ArrayList<IndexSearcher> searchers = new ArrayList<IndexSearcher>();
            for (String subIndex : calcSubIndexes) {
                LuceneIndexHolder indexHolder = this.indexHoldersBySubIndex.get(subIndex);
                if (indexHolder == null) {
                    indexHolder = this.indexManager.openIndexHolderBySubIndex(subIndex);
                    indexHoldersToClose.add(indexHolder);
                }
                if (indexHolder.getIndexReader().numDocs() > 0) {
                    searchers.add(indexHolder.getIndexSearcher());
                }
                if (!this.transIndexManager.hasTransIndex(subIndex)) continue;
                searchers.add(this.transIndexManager.getSearcher(subIndex));
            }
            if (searchers.size() == 0) {
                return new LuceneSearchEngineInternalSearch();
            }
            MultiSearcher indexSeracher = new MultiSearcher(searchers.toArray(new Searcher[searchers.size()]));
            return new LuceneSearchEngineInternalSearch(indexSeracher, indexHoldersToClose);
        }
        catch (IOException e) {
            for (LuceneIndexHolder indexHolder : indexHoldersToClose) {
                indexHolder.release();
            }
            throw new SearchEngineException("Failed to open Lucene reader/searcher", e);
        }
    }

    protected LuceneSearchEngineHits doFind(LuceneSearchEngineQuery query) throws SearchEngineException {
        LuceneSearchEngineInternalSearch internalSearch = (LuceneSearchEngineInternalSearch)this.internalSearch(query.getSubIndexes(), query.getAliases());
        if (internalSearch.isEmpty()) {
            return new EmptyLuceneSearchEngineHits();
        }
        Filter qFilter = null;
        if (this.filter.hasDeletes()) {
            qFilter = query.getFilter() == null ? this.filter : new ChainedFilter(new Filter[]{this.filter, query.getFilter().getFilter()}, ChainedFilter.ChainedFilterType.AND);
        } else if (query.getFilter() != null) {
            qFilter = query.getFilter().getFilter();
        }
        Hits hits = this.findByQuery(internalSearch, query, qFilter);
        return new DefaultLuceneSearchEngineHits(hits, this.searchEngine, query, internalSearch);
    }

    /*
     * Exception decompiling
     */
    public Resource[] get(ResourceKey resourceKey) throws SearchEngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 37[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doCreate(InternalResource resource, Analyzer analyzer) throws SearchEngineException {
        try {
            this.openIndexWriterIfNeeded(resource.getSubIndex());
            this.transIndexManager.create(resource, analyzer);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to create resource for alias [" + resource.getAlias() + "] and resource " + resource, e);
        }
    }

    protected void doDelete(ResourceKey resourceKey) throws SearchEngineException {
        try {
            Term deleteTerm;
            block16: {
                this.openIndexWriterIfNeeded(resourceKey.getSubIndex());
                LuceneIndexHolder indexHolder = this.indexHoldersBySubIndex.get(resourceKey.getSubIndex());
                if (indexHolder == null) {
                    this.indexManager.refreshCache(resourceKey.getSubIndex());
                    indexHolder = this.indexManager.openIndexHolderBySubIndex(resourceKey.getSubIndex());
                    this.indexHoldersBySubIndex.put(resourceKey.getSubIndex(), indexHolder);
                }
                deleteTerm = new Term(resourceKey.getUIDPath(), resourceKey.buildUID());
                TermDocs termDocs = null;
                try {
                    termDocs = indexHolder.getIndexReader().termDocs(deleteTerm);
                    if (termDocs == null) break block16;
                    int maxDoc = indexHolder.getIndexReader().maxDoc();
                    try {
                        while (termDocs.next()) {
                            this.filter.markDelete(indexHolder.getIndexReader(), termDocs.doc(), maxDoc);
                        }
                    }
                    catch (IOException e) {
                        throw new SearchEngineException("Failed to iterate data in order to delete", e);
                    }
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to search for property [" + resourceKey + "]", e);
                }
                finally {
                    try {
                        if (termDocs != null) {
                            termDocs.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            this.indexWriterBySubIndex.get(resourceKey.getSubIndex()).deleteDocuments(deleteTerm);
            this.transIndexManager.delete(resourceKey);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete alias [" + resourceKey.getAlias() + "] and ids [" + StringUtils.arrayToCommaDelimitedString(resourceKey.getIds()) + "]", e);
        }
    }

    public void flush() throws SearchEngineException {
    }

    protected void openIndexWriterIfNeeded(String subIndex) throws IOException {
        if (this.indexWriterBySubIndex.containsKey(subIndex)) {
            return;
        }
        IndexWriter indexWriter = this.indexManager.openIndexWriter(this.searchEngine.getSettings(), subIndex, false);
        this.indexWriterBySubIndex.put(subIndex, indexWriter);
    }

    private void releaseHolders() {
        for (LuceneIndexHolder indexHolder : this.indexHoldersBySubIndex.values()) {
            indexHolder.release();
        }
        this.indexHoldersBySubIndex.clear();
    }

    private class CommitCallable
    implements Callable {
        private String subIndex;
        private IndexWriter indexWriter;
        private PrepareCallable prepareCallable;

        public CommitCallable(String subIndex, IndexWriter indexWriter, boolean onePhase) {
            this.subIndex = subIndex;
            this.indexWriter = indexWriter;
            if (onePhase) {
                this.prepareCallable = new PrepareCallable(subIndex);
            }
        }

        public Object call() throws Exception {
            if (this.prepareCallable != null) {
                this.prepareCallable.call();
            }
            try {
                if (ReadCommittedTransaction.this.transIndexManager.hasTransIndex(this.subIndex)) {
                    Directory transDir = ReadCommittedTransaction.this.transIndexManager.getDirectory(this.subIndex);
                    this.indexWriter.addIndexesNoOptimize(new Directory[]{transDir});
                }
                this.indexWriter.close();
            }
            catch (IOException e) {
                Directory dir = ReadCommittedTransaction.this.indexManager.getStore().openDirectory(this.subIndex);
                try {
                    if (IndexReader.isLocked(dir)) {
                        IndexReader.unlock(dir);
                    }
                }
                catch (Exception e1) {
                    log.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + this.subIndex + "]"), (Throwable)e);
                }
                throw new SearchEngineException("Failed to add transaction index to sub index [" + this.subIndex + "]", e);
            }
            if (ReadCommittedTransaction.this.indexManager.getSettings().isClearCacheOnCommit()) {
                ReadCommittedTransaction.this.indexManager.refreshCache(this.subIndex);
            }
            try {
                ReadCommittedTransaction.this.transIndexManager.close(this.subIndex);
            }
            catch (IOException e) {
                log.warn((Object)("Failed to close transactional index for sub index [" + this.subIndex + "], ignoring"), (Throwable)e);
            }
            return null;
        }
    }

    private class PrepareCallable
    implements Callable {
        private String subIndex;

        private PrepareCallable(String subIndex) {
            this.subIndex = subIndex;
        }

        public Object call() throws Exception {
            if (ReadCommittedTransaction.this.transIndexManager.hasTransIndex(this.subIndex)) {
                ReadCommittedTransaction.this.transIndexManager.commit(this.subIndex);
            }
            return null;
        }
    }
}

