/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.compass.core.config.binding.metadata.ClassMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardClassMetaData
implements ClassMetaData {
    private final Class introspectedClass;

    public StandardClassMetaData(Class introspectedClass) {
        this.introspectedClass = introspectedClass;
    }

    public final Class getIntrospectedClass() {
        return this.introspectedClass;
    }

    @Override
    public String getClassName() {
        return this.getIntrospectedClass().getName();
    }

    @Override
    public boolean isInterface() {
        return this.getIntrospectedClass().isInterface();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getIntrospectedClass().getModifiers());
    }

    @Override
    public boolean isConcrete() {
        return !this.isInterface() && !this.isAbstract();
    }

    @Override
    public boolean isIndependent() {
        return !this.hasEnclosingClass() || this.getIntrospectedClass().getDeclaringClass() != null && Modifier.isStatic(this.getIntrospectedClass().getModifiers());
    }

    @Override
    public boolean hasEnclosingClass() {
        return this.getIntrospectedClass().getEnclosingClass() != null;
    }

    @Override
    public String getEnclosingClassName() {
        Class<?> enclosingClass = this.getIntrospectedClass().getEnclosingClass();
        return enclosingClass != null ? enclosingClass.getName() : null;
    }

    @Override
    public boolean hasSuperClass() {
        return this.getIntrospectedClass().getSuperclass() != null;
    }

    @Override
    public String getSuperClassName() {
        Class superClass = this.getIntrospectedClass().getSuperclass();
        return superClass != null ? superClass.getName() : null;
    }

    @Override
    public String[] getInterfaceNames() {
        Class<?>[] ifcs = this.getIntrospectedClass().getInterfaces();
        String[] ifcNames = new String[ifcs.length];
        for (int i = 0; i < ifcs.length; ++i) {
            ifcNames[i] = ifcs[i].getName();
        }
        return ifcNames;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        Annotation[] anns = this.getIntrospectedClass().getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            types.add(anns[i].annotationType().getName());
        }
        return types;
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        Annotation[] anns = this.getIntrospectedClass().getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            if (!anns[i].annotationType().getName().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        Annotation[] anns = this.getIntrospectedClass().getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            Annotation[] metaAnns;
            if (!anns[i].annotationType().getName().equals(annotationType)) continue;
            HashSet<String> types = new HashSet<String>();
            for (Annotation meta : metaAnns = anns[i].annotationType().getAnnotations()) {
                types.add(meta.annotationType().getName());
            }
            return types;
        }
        return null;
    }

    @Override
    public boolean hasMetaAnnotation(String annotationType) {
        Annotation[] anns = this.getIntrospectedClass().getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            Annotation[] metaAnns;
            for (Annotation meta : metaAnns = anns[i].annotationType().getAnnotations()) {
                if (!meta.annotationType().getName().equals(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            Method[] methods;
            if (!ann.annotationType().getName().equals(annotationType)) continue;
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            for (Method method : methods = ann.annotationType().getDeclaredMethods()) {
                if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
                try {
                    attrs.put(method.getName(), method.invoke((Object)ann, new Object[0]));
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not obtain annotation attribute values", ex);
                }
            }
            return attrs;
        }
        return null;
    }
}

