/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index;

import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.index.JdbcBufferedIndexOutput;
import org.apache.lucene.store.jdbc.support.InputStreamBlob;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public abstract class AbstractJdbcIndexOutput
extends JdbcBufferedIndexOutput {
    protected String name;
    protected JdbcDirectory jdbcDirectory;

    public void configure(String name, JdbcDirectory jdbcDirectory, JdbcFileEntrySettings settings) throws IOException {
        super.configure(name, jdbcDirectory, settings);
        this.name = name;
        this.jdbcDirectory = jdbcDirectory;
    }

    public void close() throws IOException {
        super.close();
        final long length = this.length();
        this.doBeforeClose();
        this.jdbcDirectory.getJdbcTemplate().executeUpdate(this.jdbcDirectory.getTable().sqlInsert(), new JdbcTemplate.PrepateStatementAwareCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, AbstractJdbcIndexOutput.this.name);
                InputStream is = AbstractJdbcIndexOutput.this.openInputStream();
                if (AbstractJdbcIndexOutput.this.jdbcDirectory.getDialect().useInputStreamToInsertBlob()) {
                    ps.setBinaryStream(2, is, (int)AbstractJdbcIndexOutput.this.length());
                } else {
                    ps.setBlob(2, new InputStreamBlob(is, length));
                }
                ps.setLong(3, length);
                ps.setBoolean(4, false);
            }
        });
        this.doAfterClose();
    }

    protected abstract InputStream openInputStream() throws IOException;

    protected void doAfterClose() throws IOException {
    }

    protected void doBeforeClose() throws IOException {
    }
}

