/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessInput;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessInputPK;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInputResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInputResource.class);
    private String processId;
    private String inputName;
    private String inputValue;
    private String dataType;
    private String applicationArgument;
    private boolean standardInput = false;
    private String userFriendlyDescription;
    private String metadata;
    private Integer inputOrder;
    private boolean isRequired = false;
    private boolean requiredToAddedToCmd = false;
    private boolean dataStaged = false;
    private String storageResourceId;
    private boolean isReadOnly;

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public String getInputValue() {
        return this.inputValue;
    }

    public void setInputValue(String inputValue) {
        this.inputValue = inputValue;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getApplicationArgument() {
        return this.applicationArgument;
    }

    public void setApplicationArgument(String applicationArgument) {
        this.applicationArgument = applicationArgument;
    }

    public boolean getStandardInput() {
        return this.standardInput;
    }

    public void setStandardInput(boolean standardInput) {
        this.standardInput = standardInput;
    }

    public String getUserFriendlyDescription() {
        return this.userFriendlyDescription;
    }

    public void setUserFriendlyDescription(String userFriendlyDescription) {
        this.userFriendlyDescription = userFriendlyDescription;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public Integer getInputOrder() {
        return this.inputOrder;
    }

    public void setInputOrder(Integer inputOrder) {
        this.inputOrder = inputOrder;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean getRequiredToAddedToCmd() {
        return this.requiredToAddedToCmd;
    }

    public void setRequiredToAddedToCmd(boolean requiredToAddedToCmd) {
        this.requiredToAddedToCmd = requiredToAddedToCmd;
    }

    public boolean getDataStaged() {
        return this.dataStaged;
    }

    public void setDataStaged(boolean dataStaged) {
        this.dataStaged = dataStaged;
    }

    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            if (this.processId == null) {
                throw new RegistryException("Does not have the process id");
            }
            em = ExpCatResourceUtils.getEntityManager();
            ProcessInputPK processInputPk = new ProcessInputPK();
            processInputPk.setProcessId(this.processId);
            processInputPk.setInputName(this.inputName);
            ProcessInput existingProInput = (ProcessInput)em.find(ProcessInput.class, (Object)processInputPk);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ProcessInput processInput = existingProInput == null ? new ProcessInput() : existingProInput;
            processInput.setProcessId(this.processId);
            processInput.setInputName(this.inputName);
            processInput.setInputValue(this.inputValue);
            processInput.setDataType(this.dataType);
            processInput.setApplicationArgument(this.applicationArgument);
            processInput.setStandardInput(this.standardInput);
            processInput.setUserFriendlyDescription(this.userFriendlyDescription);
            processInput.setMetadata(this.metadata);
            processInput.setInputOrder(this.inputOrder);
            processInput.setIsRequired(this.isRequired);
            processInput.setRequiredToAddedToCmd(this.requiredToAddedToCmd);
            processInput.setDataStaged(this.dataStaged);
            processInput.setStorageResourceId(this.storageResourceId);
            processInput.setIsReadOnly(this.isReadOnly);
            if (existingProInput == null) {
                em.persist((Object)processInput);
            } else {
                em.merge((Object)processInput);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

