/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import edu.uiuc.ncsa.security.core.Logable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MyLoggingFacade
implements Logable {
    boolean debugOn = false;
    String className;
    Logger logger;

    public MyLoggingFacade(Logger logger) {
        this.logger = logger;
    }

    public MyLoggingFacade(String className, boolean debugOn) {
        this(className);
        this.setDebugOn(debugOn);
        this.debug("****** enabling debugging ******");
    }

    public MyLoggingFacade(String className) {
        this.setClassName(className);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public boolean isDebugOn() {
        return this.debugOn;
    }

    @Override
    public void setDebugOn(boolean debugOn) {
        this.debugOn = debugOn;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.getClassName());
        }
        return this.logger;
    }

    @Override
    public void debug(String x) {
        if (this.isDebugOn()) {
            String out = this.getClassName() + "(" + new Date() + "): " + x;
            this.getLogger().info(out);
        }
    }

    @Override
    public void info(String x) {
        this.getLogger().info(this.getClassName() + "(" + new Date() + "): " + x);
    }

    public void warn(String x, Throwable t) {
        this.getLogger().log(Level.WARNING, x, t);
    }

    public void warn(Throwable t) {
        this.getLogger().log(Level.WARNING, "(no message)", t);
    }

    @Override
    public void warn(String x) {
        this.getLogger().warning(this.getClassName() + "(" + new Date() + "): " + x);
    }

    public void error(String x, Throwable t) {
        this.getLogger().log(Level.SEVERE, x, t);
    }

    public void error(Throwable t) {
        if (t == null) {
            this.getLogger().log(Level.SEVERE, "(no message)", t);
            return;
        }
        this.getLogger().log(Level.SEVERE, t.getMessage() == null ? "(no message)" : t.getMessage(), t);
    }

    @Override
    public void error(String x) {
        this.getLogger().severe(this.getClassName() + "(" + new Date() + "): " + x);
    }
}

