/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.proxy;

import eu.emi.security.authn.x509.helpers.proxy.ExtendedProxyType;
import eu.emi.security.authn.x509.helpers.proxy.ProxyHelper;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class ProxyUtils {
    public static boolean isProxy(X509Certificate certificate) {
        return ProxyHelper.getProxyType(certificate) != ExtendedProxyType.NOT_A_PROXY;
    }

    public static boolean isProxy(X509Certificate[] certificate) {
        return ProxyUtils.isProxy(certificate[0]);
    }

    public static X509Certificate getEndUserCertificate(X509Certificate[] certificateChain) {
        for (X509Certificate cert : certificateChain) {
            if (ProxyUtils.isProxy(cert)) continue;
            return cert;
        }
        return null;
    }

    public static X500Principal getOriginalUserDN(X509Certificate[] certificateChain) throws IllegalArgumentException {
        X509Certificate eec = ProxyUtils.getEndUserCertificate(certificateChain);
        if (eec == null) {
            throw new IllegalArgumentException("The checked certificate chain contains only proxy certificates");
        }
        return eec.getSubjectX500Principal();
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

