/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bouncycastle.util.Selector;
import org.bouncycastle.x509.ExtendedPKIXBuilderParameters;

public class ExtPKIXParameters
extends ExtendedPKIXBuilderParameters {
    protected boolean proxySupport;
    protected RevocationParameters revocationParams;
    protected ObserversHandler observers;
    private Set<TrustAnchor> unmodTrustAnchors2;

    public ExtPKIXParameters(Set<TrustAnchor> trustAnchors, Selector targetSelector, ObserversHandler observers) throws InvalidAlgorithmParameterException {
        super(trustAnchors, targetSelector);
        this.observers = observers;
        this.revocationParams = new RevocationParameters(CrlCheckingMode.REQUIRE, new OCSPParametes());
        this.setRevocationEnabled(true);
        this.proxySupport = false;
    }

    public boolean isProxySupport() {
        return this.proxySupport;
    }

    public void setProxySupport(boolean proxySupport) {
        this.proxySupport = proxySupport;
    }

    public RevocationParameters getRevocationParams() {
        return this.revocationParams;
    }

    public ObserversHandler getObservers() {
        return this.observers;
    }

    public void setRevocationParams(RevocationParameters revocationParams) {
        this.revocationParams = revocationParams;
        this.setRevocationEnabled(revocationParams.getCrlCheckingMode() != CrlCheckingMode.IGNORE || revocationParams.getOcspParameters().getCheckingMode() != OCSPCheckingMode.IGNORE);
        this.setUseDeltasEnabled(revocationParams.getCrlCheckingMode() != CrlCheckingMode.IGNORE);
    }

    public void setTrustAnchors(Set<TrustAnchor> trustAnchors) throws InvalidAlgorithmParameterException {
        if (trustAnchors == null) {
            throw new NullPointerException("the trustAnchors parameters must be non-null");
        }
        Iterator<TrustAnchor> i = trustAnchors.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof TrustAnchor) continue;
            throw new ClassCastException("all elements of set must be of type java.security.cert.TrustAnchor");
        }
        this.unmodTrustAnchors2 = Collections.unmodifiableSet(new HashSet<TrustAnchor>(trustAnchors));
    }

    public Set<TrustAnchor> getTrustAnchors() {
        return this.unmodTrustAnchors2;
    }

    public String toString() {
        String orig = super.toString();
        if (this.unmodTrustAnchors2 != null) {
            orig = orig.replaceFirst("[\n", "[\n  Trust Anchors: " + this.unmodTrustAnchors2.toString() + "\n");
        }
        return orig;
    }

    public ExtPKIXParameters clone() {
        ExtPKIXParameters params = null;
        try {
            params = new ExtPKIXParameters(this.getTrustAnchors(), this.getTargetConstraints(), this.getObservers());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        params.setParams((PKIXParameters)((Object)this));
        params.setProxySupport(this.proxySupport);
        params.setRevocationParams(this.revocationParams);
        return params;
    }
}

