/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.core;

import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;

public class RequestData {
    private static final int DEFAULT_LIFE_TIME = 3600;
    private static final int DEFAULT_MY_PROXY_PORT = 7512;
    private String tokenId;
    private String requestUser;
    private String gatewayId;
    private String myProxyServerUrl = null;
    private int myProxyPort = 0;
    private String myProxyUserName = null;
    private String myProxyPassword = null;
    private int myProxyLifeTime = 3600;

    public RequestData() {
    }

    public RequestData(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public RequestData(String tokenId, String requestUser, String gatewayId) {
        this.tokenId = tokenId;
        this.requestUser = requestUser;
        this.gatewayId = gatewayId;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getRequestUser() {
        return this.requestUser;
    }

    public void setRequestUser(String requestUser) {
        this.requestUser = requestUser;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getMyProxyServerUrl() throws ApplicationSettingsException {
        if (this.myProxyServerUrl == null) {
            this.myProxyServerUrl = ServerSettings.getSetting((String)"myproxy.server");
        }
        return this.myProxyServerUrl;
    }

    public void setMyProxyServerUrl(String myProxyServerUrl) {
        this.myProxyServerUrl = myProxyServerUrl;
    }

    public int getMyProxyPort() {
        if (this.myProxyPort == 0) {
            String sPort = ServerSettings.getSetting((String)"myproxy.port", (String)Integer.toString(7512));
            this.myProxyPort = Integer.parseInt(sPort);
        }
        return this.myProxyPort;
    }

    public void setMyProxyPort(int myProxyPort) {
        this.myProxyPort = myProxyPort;
    }

    public String getMyProxyUserName() throws ApplicationSettingsException {
        if (this.myProxyUserName == null) {
            this.myProxyUserName = ServerSettings.getSetting((String)"myproxy.username");
        }
        return this.myProxyUserName;
    }

    public void setMyProxyUserName(String myProxyUserName) {
        this.myProxyUserName = myProxyUserName;
    }

    public String getMyProxyPassword() throws ApplicationSettingsException {
        if (this.myProxyPassword == null) {
            this.myProxyPassword = ServerSettings.getSetting((String)"myproxy.password");
        }
        return this.myProxyPassword;
    }

    public int getMyProxyLifeTime() {
        String life = ServerSettings.getSetting((String)"myproxy.life", (String)Integer.toString(this.myProxyLifeTime));
        this.myProxyLifeTime = Integer.parseInt(life);
        return this.myProxyLifeTime;
    }

    public void setMyProxyLifeTime(int myProxyLifeTime) {
        this.myProxyLifeTime = myProxyLifeTime;
    }

    public void setMyProxyPassword(String myProxyPassword) {
        this.myProxyPassword = myProxyPassword;
    }
}

